/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.QueryTest1;

public class TestMathQueries
extends BaseQueryTest {
    public TestMathQueries(String name) {
        super(name);
    }

    public void setUp() {
        this.deleteAll(QueryTest1.class);
        OpenJPAEntityManager pm = this.getEM();
        this.startTx((EntityManager)pm);
        for (int i = 0; i <= 100; ++i) {
            QueryTest1 ob = new QueryTest1();
            ob.setNum(i);
            pm.persist((Object)ob);
        }
        this.endTx((EntityManager)pm);
        for (long i = 0L; i < 100L; ++i) {
            OpenJPAQuery q = pm.createQuery("SELECT q FROM QueryTest1 q WHERE q.numb = :ind").setParameter("ind", (Object)i);
            List l = q.getResultList();
            this.assertSize(1, l);
        }
    }

    public void testMultipleQuery() {
        try {
            OpenJPAQuery q1 = this.getEM().createQuery("SELECT q FROM QueryTest1 q WHERE q.numb * q.numb = 25");
            OpenJPAQuery q2 = this.getEM().createQuery("SELECT q FROM QueryTest1 q WHERE q.numb * q.numb > 25");
            this.assertSize(95, q2.getResultList());
            this.assertSize(1, q1.getResultList());
        }
        catch (Exception e) {
            this.bug(AbstractTestCase.Platform.EMPRESS, 890, (Throwable)e, "Empress cannot handle certain aggregate functions");
        }
    }
}

