/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.common.apps.Osoba;
import org.apache.openjpa.persistence.query.common.apps.Projekt;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNewEntityAsQueryParameter
extends SingleEMFTestCase {
    public static final String ID_PROJEKT1 = "OpenJPA";
    public static final String ID_PROJEKT2 = "Tomcat";
    public static final int MEMBER_COUNT_PROJEKT1 = 6;
    public static final int MEMBER_COUNT_PROJEKT2 = 4;
    public static final int MEMBER_COUNT_TOTAL = 8;

    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, Osoba.class, Projekt.class);
        this.createData();
    }

    private void createData() {
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Osoba[] osoby = new Osoba[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            osoby[i2] = new Osoba("Osoba-" + (i2 + 1), 20 + i2);
            em.persist((Object)osoby[i2]);
        }
        Projekt projekt1 = new Projekt(ID_PROJEKT1);
        Projekt projekt2 = new Projekt(ID_PROJEKT2);
        em.persist((Object)projekt1);
        em.persist((Object)projekt2);
        for (i = 0; i < 6; ++i) {
            this.link(osoby[i], projekt1);
        }
        for (i = 0; i < 4; ++i) {
            this.link(osoby[osoby.length - i - 1], projekt2);
        }
        em.getTransaction().commit();
        em.clear();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQueryWithTransientInstanceAsParameter() {
        Projekt projekt1 = new Projekt(ID_PROJEKT1);
        Projekt projekt2 = new Projekt(ID_PROJEKT2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.queryWithParameter((EntityManager)em, projekt1, projekt2);
    }

    public void testQueryWithUnmanagedPersistentInstanceAsParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Projekt projekt1 = (Projekt)em.find(Projekt.class, (Object)ID_PROJEKT1);
        Projekt projekt2 = (Projekt)em.find(Projekt.class, (Object)ID_PROJEKT2);
        em.clear();
        TestNewEntityAsQueryParameter.assertFalse((boolean)em.contains((Object)projekt1));
        TestNewEntityAsQueryParameter.assertFalse((boolean)em.contains((Object)projekt2));
        this.queryWithParameter((EntityManager)em, projekt1, projekt2);
    }

    public void testQueryWithManagedPersistentInstanceAsParameter() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Projekt projekt1 = (Projekt)em.find(Projekt.class, (Object)ID_PROJEKT1);
        Projekt projekt2 = (Projekt)em.find(Projekt.class, (Object)ID_PROJEKT2);
        TestNewEntityAsQueryParameter.assertTrue((boolean)em.contains((Object)projekt1));
        TestNewEntityAsQueryParameter.assertTrue((boolean)em.contains((Object)projekt2));
        this.queryWithParameter((EntityManager)em, projekt1, projekt2);
    }

    void queryWithParameter(EntityManager em, Projekt projekt1, Projekt projekt2) {
        String jpql = "SELECT DISTINCT o FROM Osoba o WHERE :projekt MEMBER OF o.projekty";
        em.getTransaction().begin();
        Query query = em.createQuery(jpql);
        query.setParameter("projekt", (Object)projekt1);
        List osoby = query.getResultList();
        TestNewEntityAsQueryParameter.assertEquals((int)6, (int)osoby.size());
        query.setParameter("projekt", (Object)projekt2);
        osoby = query.getResultList();
        TestNewEntityAsQueryParameter.assertEquals((int)4, (int)osoby.size());
        em.getTransaction().rollback();
    }

    void link(Osoba o, Projekt p) {
        o.addProjekty(p);
        p.addOsoba(o);
    }
}

