/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.query.Case;
import org.apache.openjpa.persistence.query.Lookup;
import org.apache.openjpa.persistence.query.Role;
import org.apache.openjpa.persistence.query.ScheduleDay;
import org.apache.openjpa.persistence.query.ScheduledAssignment;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOutOfBoundsEx
extends SingleEMFTestCase {
    private EntityManager em = null;
    private Lookup lookup;

    @Override
    public void setUp() throws Exception {
        super.setUp(Lookup.class, Case.class, Role.class, ScheduledAssignment.class, ScheduleDay.class, DROP_TABLES);
        this.em = this.emf.createEntityManager();
        this.insertLookups();
    }

    public void testOutOfBounds() throws Exception {
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        ScheduleDay sd = this.insertScheduleDay(date);
        Role role1 = this.insertJob();
        Role role2 = this.insertJob();
        Case kase1 = this.insertCase(sd);
        Case kase2 = this.insertCase(sd);
        this.insertScheduledAssignmentInCase(role1, kase2);
        this.em.close();
        this.em = this.emf.createEntityManager();
        Query query = this.em.createQuery("select o from Case as o where o.scheduleDay = :sd");
        query.setParameter("sd", (Object)sd);
        FetchPlan fetchPlan = ((QueryImpl)query).getFetchPlan();
        fetchPlan.addField(Case.class, "scheduledAssignments");
        List allCases = query.getResultList();
    }

    public void insertLookups() {
        this.lookup = new Lookup();
        this.lookup.setName("XYZ");
        this.lookup.setId(1);
        this.save(this.lookup);
    }

    public void save(Object obj) {
        this.em.getTransaction().begin();
        this.em.persist(obj);
        this.em.getTransaction().commit();
    }

    public Role insertJob() {
        Role role = new Role();
        role.setLookup(this.lookup);
        this.save(role);
        return role;
    }

    public Case insertCase(ScheduleDay sd) throws Exception {
        Case kase = new Case();
        kase.setScheduleDay(sd);
        this.save(kase);
        return kase;
    }

    public void insertScheduledAssignmentInCase(Role job, Case kase) {
        ScheduledAssignment sa = new ScheduledAssignment();
        sa.setRole(job);
        sa.setCase(kase);
        sa.setScheduleDay(kase.getScheduleDay());
        this.save(sa);
    }

    public ScheduleDay insertScheduleDay(Date date) {
        ScheduleDay sd = new ScheduleDay();
        sd.setDate(date);
        this.save(sd);
        return sd;
    }
}

