/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryConvertPositionalParameters
extends SingleEMFTestCase {
    EntityManager _em;
    long _id1;
    String _name1;
    String _val1;
    long _id2;
    String _name2;
    String _val2;

    @Override
    public void setUp() {
        super.setUp(SimpleEntity.class, "openjpa.Compatibility", "ConvertPositionalParametersToNamed=true");
        this._em = this.emf.createEntityManager();
        this._em.getTransaction().begin();
        SimpleEntity se1 = new SimpleEntity();
        this._name1 = "name1";
        this._val1 = "val1";
        se1.setName(this._name1);
        se1.setValue(this._val1);
        this._em.persist((Object)se1);
        this._id1 = se1.getId();
        this._em.getTransaction().commit();
        this._em.getTransaction().begin();
        SimpleEntity se2 = new SimpleEntity();
        this._name2 = "name2";
        this._val2 = "val2";
        se2.setName(this._name2);
        se2.setValue(this._val2);
        this._em.persist((Object)se2);
        this._id2 = se2.getId();
        this._em.getTransaction().commit();
        this._em.clear();
    }

    @Override
    public void tearDown() throws Exception {
        if (this._em.getTransaction().isActive()) {
            this._em.getTransaction().rollback();
        }
        this._em.close();
        super.tearDown();
    }

    public void testNamedPositionalStartAtNonOne() {
        SimpleEntity se = (SimpleEntity)this._em.createNamedQuery("SelectWithPositionalParameterNonOneStart", SimpleEntity.class).setParameter(900, (Object)this._id1).setParameter(2, (Object)this._name1).setParameter(54, (Object)this._val1).getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se);
    }

    public void testJPQLPositionalStartAtNonOne() {
        int idPos = 7;
        int namePos = 908;
        int valPos = 578;
        SimpleEntity se = (SimpleEntity)this._em.createQuery("Select s FROM simple s where s.id=?" + idPos + " and s.name=?" + namePos + " and s.value=?" + valPos, SimpleEntity.class).setParameter(idPos, (Object)this._id1).setParameter(namePos, (Object)this._name1).setParameter(valPos, (Object)this._val1).getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se);
    }

    public void testJPQLWithSubQueryPositionalStartAtNonOne() {
        int idPos = 7;
        int namePos = 908;
        int valPos = 578;
        SimpleEntity se = (SimpleEntity)this._em.createQuery("Select s FROM simple s where s.id = ?" + idPos + " and (SELECT se.value FROM simple se where se.name=?" + namePos + ")=?" + valPos, SimpleEntity.class).setParameter(idPos, (Object)this._id1).setParameter(namePos, (Object)this._name1).setParameter(valPos, (Object)this._val1).getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se);
    }

    public void testPreparedQueryPositionalStartAtNonOne() {
        int idPos = 54;
        int namePos = 23;
        int valPos = 42;
        String jpql = "Select s FROM simple s where s.id=?" + idPos + " and s.name=?" + namePos + " and s.value=?" + valPos;
        Query q = this._em.createQuery(jpql).setParameter(idPos, (Object)this._id1).setParameter(namePos, (Object)this._name1).setParameter(valPos, (Object)this._val1);
        SimpleEntity se = (SimpleEntity)q.getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se);
        TestQueryConvertPositionalParameters.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q).getLanguage());
        Query q2 = this._em.createQuery(jpql).setParameter(idPos, (Object)this._id2).setParameter(namePos, (Object)this._name2).setParameter(valPos, (Object)this._val2);
        SimpleEntity se2 = (SimpleEntity)q2.getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se2);
        TestQueryConvertPositionalParameters.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
    }

    public void testPreparedQueryWithSubQueryPositionalStartAtNonOne() {
        int idPos = 7;
        int namePos = 908;
        int valPos = 352;
        String jpql = "Select s FROM simple s where s.id = ?" + idPos + " and (SELECT se.value FROM simple se where se.name=?" + namePos + ")=?" + valPos;
        TypedQuery q = this._em.createQuery(jpql, SimpleEntity.class).setParameter(idPos, (Object)this._id1).setParameter(namePos, (Object)this._name1).setParameter(valPos, (Object)this._val1);
        SimpleEntity se = (SimpleEntity)q.getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se);
        TestQueryConvertPositionalParameters.assertEquals((String)"javax.persistence.JPQL", (String)OpenJPAPersistence.cast((Query)q).getLanguage());
        TypedQuery q2 = this._em.createQuery(jpql, SimpleEntity.class).setParameter(idPos, (Object)this._id2).setParameter(namePos, (Object)this._name2).setParameter(valPos, (Object)this._val2);
        SimpleEntity se2 = (SimpleEntity)q2.getSingleResult();
        TestQueryConvertPositionalParameters.assertNotNull((Object)se2);
        TestQueryConvertPositionalParameters.assertEquals((String)"openjpa.prepared.SQL", (String)OpenJPAPersistence.cast((Query)q2).getLanguage());
    }
}

