/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.List;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.ManyOneEntity;
import org.apache.openjpa.persistence.query.ManyOneEntitySub;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQueryIdOfRelationDoesNotJoin
extends SingleEMFTestCase {
    private long e3Id;

    @Override
    public void setUp() {
        this.setUp(ManyOneEntity.class, ManyOneEntitySub.class);
        ManyOneEntity e1 = new ManyOneEntity();
        e1.setName("e1");
        ManyOneEntity e2 = new ManyOneEntity();
        e2.setName("e2");
        ManyOneEntity e3 = new ManyOneEntity();
        e3.setName("e3");
        e1.setRel(e3);
        e2.setRel(e1);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)e1);
        em.getTransaction().commit();
        this.e3Id = e3.getId();
        em.getTransaction().begin();
        em.remove((Object)e3);
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from ManyOneEntity e where e.rel.id = :id").setParameter("id", (Object)this.e3Id);
        List res = q.getResultList();
        TestQueryIdOfRelationDoesNotJoin.assertEquals((int)1, (int)res.size());
        ManyOneEntity e = (ManyOneEntity)res.get(0);
        TestQueryIdOfRelationDoesNotJoin.assertEquals((String)"e1", (String)e.getName());
        TestQueryIdOfRelationDoesNotJoin.assertNull((Object)e.getRel());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestQueryIdOfRelationDoesNotJoin.class);
    }
}

