/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaBuilder;
import org.apache.openjpa.persistence.query.BaseQueryTest;
import org.apache.openjpa.persistence.query.common.apps.Entity1;

public class TestQueryLock
extends BaseQueryTest {
    public TestQueryLock(String test) {
        super(test);
    }

    public void setUp() {
        this.deleteAll(Entity1.class);
    }

    public void testJPQLLock() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Query q = em.createQuery("SELECT o FROM Entity1 o WHERE o.stringField = 'testSimple'");
        try {
            q.setLockMode(LockModeType.NONE);
            TestQueryLock.assertEquals((String)"Verify NONE after set", (Object)LockModeType.NONE, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)("Do not expected " + e.getClass().getName()));
        }
        try {
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            TestQueryLock.fail((String)"Expecting TransactionRequiredException thrown");
        }
        catch (TransactionRequiredException tre) {
            TestQueryLock.assertEquals((String)"Verify still NONE after set incorrect lock mode", (Object)LockModeType.NONE, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)"Expecting TransactionRequiredException thrown");
        }
        this.startTx((EntityManager)em);
        try {
            q.setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            TestQueryLock.assertEquals((String)"Verify changed to OPTIMISTIC_FORCE_INCREMENT", (Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)("Do not expected " + e.getClass().getName()));
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testCriteriaLock() {
        OpenJPAEntityManager em = this.currentEntityManager();
        OpenJPACriteriaBuilder cb = this.getEmf().getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Entity1.class);
        Root customer = cq.from(Entity1.class);
        TypedQuery q = em.createQuery(cq);
        try {
            q.setLockMode(LockModeType.NONE);
            TestQueryLock.assertEquals((String)"Verify NONE after set", (Object)LockModeType.NONE, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)("Do not expected " + e.getClass().getName()));
        }
        try {
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            TestQueryLock.fail((String)"Expecting TransactionRequiredException thrown");
        }
        catch (TransactionRequiredException tre) {
            TestQueryLock.assertEquals((String)"Verify still NONE after set incorrect lock mode", (Object)LockModeType.NONE, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)"Expecting TransactionRequiredException thrown");
        }
        this.startTx((EntityManager)em);
        try {
            q.setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            TestQueryLock.assertEquals((String)"Verify changed to OPTIMISTIC_FORCE_INCREMENT", (Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT, (Object)q.getLockMode());
        }
        catch (Exception e) {
            TestQueryLock.fail((String)("Do not expected " + e.getClass().getName()));
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testNativeLock() {
        OpenJPAEntityManager em = this.currentEntityManager();
        Query q = em.createNativeQuery("SELECT * FROM Entity1");
        try {
            q.setLockMode(LockModeType.NONE);
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        catch (IllegalStateException ise) {
        }
        catch (Exception e) {
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        try {
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        catch (IllegalStateException ise) {
        }
        catch (Exception e) {
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        this.startTx((EntityManager)em);
        try {
            q.setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT);
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        catch (IllegalStateException ise) {
        }
        catch (Exception e) {
            TestQueryLock.fail((String)"Expecting IllegalStateException thrown");
        }
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }
}

