/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MariaDBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.query.Account;
import org.apache.openjpa.persistence.query.Customer;
import org.apache.openjpa.persistence.query.Dependent;
import org.apache.openjpa.persistence.query.DependentId;
import org.apache.openjpa.persistence.query.Employee;
import org.apache.openjpa.persistence.query.Magazine;
import org.apache.openjpa.persistence.query.Order;
import org.apache.openjpa.persistence.query.OrderItem;
import org.apache.openjpa.persistence.query.Publisher;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestSubquery
extends SingleEMFTestCase {
    static String[] querys = new String[]{"select c from Customer c where EXISTS (select o from  in(c.orders)  o)", "select c from Customer c where EXISTS (select o from c.orders o)", "select c from Customer c where NOT EXISTS (select o from in (c.orders) o)", "select c from Customer c where NOT EXISTS (select o from  c.orders o)", "select o1.oid from Order o1 where o1.oid in  (select distinct o.oid from OrderItem i, Order o where i.quantity > 10 and o.amount > 1000 and i.lid = o.oid)", "select o.oid from Order o where o.customer.name = (select max(o2.customer.name) from Order o2 where o.customer.cid.id = o2.customer.cid.id)", "select o from Order o where o.customer.name = (select max(o2.customer.name) from Order o2 where o.customer.cid.id = o2.customer.cid.id)", "select o.oid from Order o where o.amount > (select count(i) from o.lineitems i)", "select o.oid from Order o where o.amount > (select count(o.amount) from Order o)", "select o.oid from Order o where o.amount > (select count(o.oid) from Order o)", "select o.oid from Order o where o.amount > (select avg(o.amount) from Order o)", "select c.name from Customer c where exists (select o from c.orders o where o.oid = 1) or exists (select o from c.orders o where o.oid = 2)", "select c.name from Customer c, in(c.orders) o where o.amount between (select max(o.amount) from Order o) and (select avg(o.amount) from Order o) ", "select o.oid from Order o where o.amount > (select sum(o2.amount) from Customer c, in(c.orders) o2) ", "select o.oid from Order o where o.amount between (select avg(o2.amount) from Customer c, in(c.orders) o2) and (select min(o2.amount) from Customer c, in(c.orders) o2)", "select o.oid from Customer c, in(c.orders)o where o.amount > (select sum(o2.amount) from c.orders o2)", "select o1.oid, c.name from Order o1, Customer c where o1.amount =  any(select o2.amount from in(c.orders) o2)", "SELECT p, m FROM Publisher p LEFT OUTER JOIN p.magazineCollection m WHERE m.id = (SELECT MAX(m2.id) FROM Magazine m2 WHERE m2.idPublisher.id = p.id AND m2.datePublished = (SELECT MAX(m3.datePublished) FROM Magazine m3 WHERE m3.idPublisher.id = p.id)) ", "select o from Order o where o.amount >  (select count(o) from Order o)", "select o from Order o where o.amount > (select count(o2) from Order o2)", "select c from Customer c left join c.orders o where not exists (select o2 from c.orders o2 where o2 = o)"};
    static String[] querys_jpa20 = new String[]{"select o.oid from Order o where o.delivered = (select    CASE WHEN o2.amount > 10 THEN true     WHEN o2.amount = 10 THEN false      ELSE false      END  from Order o2 where o.customer.cid.id = o2.customer.cid.id)", "select o1.oid from Order o1 where o1.amount >  (select o.amount*0.8 from OrderItem i, Order o where i.quantity > 10 and o.amount > 1000 and i.lid = o.oid)", "select o.oid from Order o where o.customer.name = (select substring(o2.customer.name, 3) from Order o2 where o.customer.cid.id = o2.customer.cid.id)", "select o.oid from Order o where o.orderTs > (select CURRENT_TIMESTAMP from o.lineitems i)", "select o.oid from Order o where o.amount > (select SQRT(o.amount) from Order o where o.delivered = true)", "select o.oid from Order o where o.customer.name in (select CONCAT(o.customer.name, 'XX') from Order o where o.amount > 10)", "select c from Customer c where c.creditRating = (select    CASE WHEN o2.amount > 10 THEN org.apache.openjpa.persistence.query.Customer$CreditRating.POOR     WHEN o2.amount = 10 THEN org.apache.openjpa.persistence.query.Customer$CreditRating.GOOD      ELSE org.apache.openjpa.persistence.query.Customer$CreditRating.EXCELLENT      END  from Order o2 where c.cid.id = o2.customer.cid.id)", "select c from Customer c where c.creditRating = (select COALESCE (c1.creditRating, org.apache.openjpa.persistence.query.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC", "select c from Customer c where c.creditRating = (select NULLIF (c1.creditRating, org.apache.openjpa.persistence.query.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC"};
    static String[] updates = new String[]{"update Order o set o.amount = 1000 where o.customer.name =  (select max(o2.customer.name) from Order o2  where o.customer.cid.id = o2.customer.cid.id)"};
    static String[] querys2 = new String[]{"select o1.oid, c.name from Order o1, Customer c where o1.customer.name =  any(select o2.customer.name from in(c.orders) o2)", "select o1.oid, c.name from Order o1, Customer c where o1.amount =  any(select o2.amount from in(c.orders) o2)", "select DISTINCT c.name FROM Customer c JOIN c.orders o WHERE EXISTS (SELECT o FROM o.lineitems l where l.quantity > 2 ) ", "select DISTINCT c.name FROM Customer c, IN(c.orders) co WHERE co.amount > ALL (Select o.amount FROM Order o, in(o.lineitems) l WHERE l.quantity > 2)", "select distinct c.name FROM Customer C, IN(C.orders) co WHERE co.amount < ALL (Select o.amount FROM Order o, IN(o.lineitems) l WHERE l.quantity > 2)", "select c.name FROM Customer c, IN(c.orders) co WHERE co.amount <= ALL (Select o.amount FROM Order o, IN(o.lineitems) l WHERE l.quantity > 2)", "select DISTINCT c.name FROM Customer c, IN(c.orders) co WHERE co.amount > ANY (Select o.amount FROM Order o, IN(o.lineitems) l WHERE l.quantity = 2)", "select DISTINCT c.name FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.amount BETWEEN 1000 AND 1200)", "select DISTINCT c.name FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.amount > 1000 )", "SELECT o.oid from Order o WHERE EXISTS (SELECT c.name From o.customer c WHERE c.name LIKE '%los') ", "select Distinct c.name FROM Customer c, IN(c.orders) co WHERE co.amount >= SOME(Select o.amount FROM Order o, IN(o.lineitems) l WHERE l.quantity = 2)", "select c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o where o.amount > 1000)", "select c FROM Customer c WHERE EXISTS (SELECT o FROM c.orders o)", "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 10", "SELECT o FROM Order o JOIN o.customer c WHERE c.name = SOME (SELECT a.name FROM c.accounts a)"};

    @Override
    public void setUp() {
        this.setUp(Customer.class, Customer.CustomerKey.class, Order.class, OrderItem.class, Magazine.class, Publisher.class, Employee.class, Dependent.class, DependentId.class, Account.class, DROP_TABLES);
    }

    public void testSubquery2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (int i = 0; i < querys2.length; ++i) {
            String q = querys2[i];
            System.err.println(">>> JPQL JPA2 :[ " + i + "]" + q);
            List rs = em.createQuery(q).getResultList();
            TestSubquery.assertEquals((int)0, (int)rs.size());
        }
        em.close();
    }

    public void testSubquery() {
        List rs;
        String q;
        int i;
        JDBCConfiguration conf = (JDBCConfiguration)this.emf.getConfiguration();
        DBDictionary dict = conf.getDBDictionaryInstance();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        for (i = 0; i < querys_jpa20.length; ++i) {
            q = querys_jpa20[i];
            System.err.println(">>> JPQL JPA2 :[ " + i + "]" + q);
            rs = em.createQuery(q).getResultList();
            TestSubquery.assertEquals((int)0, (int)rs.size());
        }
        for (i = 0; i < querys.length; ++i) {
            q = querys[i];
            System.err.println(">>> JPQL: [ " + i + "]" + q);
            rs = em.createQuery(q).getResultList();
            TestSubquery.assertEquals((int)0, (int)rs.size());
        }
        if (dict instanceof MySQLDictionary || dict instanceof MariaDBDictionary) {
            return;
        }
        em.getTransaction().begin();
        for (i = 0; i < updates.length; ++i) {
            int updateCount = em.createQuery(updates[i]).executeUpdate();
            TestSubquery.assertEquals((int)0, (int)updateCount);
        }
        em.getTransaction().rollback();
        em.close();
    }

    public void testSubSelectMaxDateRange() {
        String query = "SELECT e,d from Employee e, Dependent d WHERE e.empId = :empid AND d.id.empid = (SELECT MAX (e2.empId) FROM Employee e2) AND d.id.effDate > :minDate AND d.id.effDate < :maxDate ";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery(query);
        q.setParameter("empid", (Object)101L);
        q.setParameter("minDate", (Object)new Date(100L));
        q.setParameter("maxDate", (Object)new Date(100000L));
        q.getResultList();
        em.close();
    }

    public void testUpdateWithCorrelatedSubquery() {
        String update = "update Customer c set c.creditRating = ?1 where EXISTS (select o from  in(c.orders)  o)";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Customer.CreditRating creditRating = Customer.CreditRating.GOOD;
        int updateCount = em.createQuery(update).setParameter(1, (Object)creditRating).executeUpdate();
        em.getTransaction().rollback();
        em.close();
    }
}

