/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query.results;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.persistence.Query;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.results.Bar;
import org.apache.openjpa.persistence.criteria.results.Foo;
import org.apache.openjpa.persistence.criteria.results.FooBar;
import org.apache.openjpa.persistence.criteria.results.Item;
import org.apache.openjpa.persistence.criteria.results.Order;
import org.apache.openjpa.persistence.criteria.results.Producer;
import org.apache.openjpa.persistence.criteria.results.Shop;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJPQLMultiSelectTypedResults
extends SingleEMFTestCase {
    private static final int N_ORDERS = 15;
    private static final int N_ITEMS_PER_ORDER = 3;
    private static final String[] ORDER_DATES = new String[]{"3/12/2008 1:00 PM", "10/01/2008 1:51 AM", "12/12/2008 10:01 AM", "5/21/2009 3:23 PM"};
    DateFormat df = DateFormat.getDateInstance(3, Locale.US);

    @Override
    public void setUp() throws Exception {
        this.setUp(CLEAR_TABLES, Order.class, Item.class, Shop.class, Producer.class, Person.class, Foo.class, Bar.class, "openjpa.DynamicEnhancementAgent", "false");
        this.populate();
    }

    public void populate() throws ParseException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Shop s = new Shop();
        s.setId(1L);
        s.setName("eBay.com");
        s.setOrders(new HashSet<Order>());
        for (int i = 1; i <= 15; ++i) {
            Order order = new Order();
            order.setId(i);
            order.setDate(this.df.parse(ORDER_DATES[i % ORDER_DATES.length]));
            order.setFilled(i % 2 == 0);
            order.setShop(s);
            order.setItems(new HashSet<Item>());
            s.getOrders().add(order);
            for (int j = 1; j <= 3; ++j) {
                Item item = new Item();
                item.setOrder(order);
                order.getItems().add(item);
                Producer p = new Producer();
                p.setName("filler");
                p.setItem(item);
                item.setProduct(p);
            }
        }
        em.persist((Object)s);
        Person person = new Person("Test Result Shape");
        em.persist((Object)person);
        Foo foo = new Foo(100L, "Test Foo");
        Bar bar = new Bar(200L, "Test Bar");
        foo.setBar(bar);
        em.persist((Object)foo);
        em.persist((Object)bar);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMultipleConstructor() {
        String query = "SELECT NEW Foo(f.fid,f.fint), b, NEW FooBar(f.fid, b.bid) from Foo f JOIN f.bar b WHERE f.bar=b";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query jpqlQuery = em.createQuery(query);
        List result = jpqlQuery.getResultList();
        TestJPQLMultiSelectTypedResults.assertFalse((boolean)result.isEmpty());
        for (Object[] row : result) {
            TestJPQLMultiSelectTypedResults.assertEquals((int)3, (int)row.length);
            TestJPQLMultiSelectTypedResults.assertTrue((String)("0-th element " + row[0].getClass() + " is not Foo"), (boolean)(row[0] instanceof Foo));
            TestJPQLMultiSelectTypedResults.assertTrue((String)("1-st element " + row[1].getClass() + " is not Bar"), (boolean)(row[1] instanceof Bar));
            TestJPQLMultiSelectTypedResults.assertTrue((String)("2-nd element " + row[2].getClass() + " is not FooBar"), (boolean)(row[2] instanceof FooBar));
        }
    }

    public void testMultipleConstructorMixWithMultiSelect() {
        String query = "SELECT NEW Person(p.name), p.id, NEW Person(p.name), p.name FROM Person p ORDER BY p.name";
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query jpqlQuery = em.createQuery(query);
        List result = jpqlQuery.getResultList();
        TestJPQLMultiSelectTypedResults.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        for (Object[] row : result) {
            TestJPQLMultiSelectTypedResults.assertEquals((int)4, (int)row.length);
            TestJPQLMultiSelectTypedResults.assertEquals(Person.class, row[0].getClass());
            TestJPQLMultiSelectTypedResults.assertEquals(Integer.class, row[1].getClass());
            TestJPQLMultiSelectTypedResults.assertEquals(Person.class, row[2].getClass());
            TestJPQLMultiSelectTypedResults.assertEquals(String.class, row[3].getClass());
            TestJPQLMultiSelectTypedResults.assertEquals((String)((Person)row[0]).getName(), (String)((Person)row[2]).getName());
            TestJPQLMultiSelectTypedResults.assertEquals((Object)((Person)row[0]).getName(), (Object)row[3]);
        }
    }

    public void testMultiSelect() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query jpqlQuery = em.createQuery("SELECT o, p from Order o JOIN o.items i JOIN i.producer p WHERE o.filled = true");
        List jpqlResults = jpqlQuery.getResultList();
        TestJPQLMultiSelectTypedResults.assertEquals((int)21, (int)jpqlResults.size());
        for (Object[] os : jpqlResults) {
            TestJPQLMultiSelectTypedResults.assertEquals((int)2, (int)os.length);
            TestJPQLMultiSelectTypedResults.assertTrue((boolean)(os[0] instanceof Order));
            TestJPQLMultiSelectTypedResults.assertTrue((boolean)(os[1] instanceof Producer));
        }
        em.close();
    }
}

