/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.BasicEntity;
import org.apache.openjpa.persistence.relations.DataStoreBasicEntity;
import org.apache.openjpa.persistence.relations.DataStoreManyOneIdOwner;
import org.apache.openjpa.persistence.relations.ManyOneCompoundIdOwner;
import org.apache.openjpa.persistence.relations.ManyOneCompoundIdOwnerId;
import org.apache.openjpa.persistence.relations.ManyOneIdOwner;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestManyOneAsId
extends SingleEMFTestCase {
    private long id;
    private long dsid;
    private long cid;

    @Override
    public void setUp() {
        this.setUp(BasicEntity.class, DataStoreBasicEntity.class, ManyOneIdOwner.class, DataStoreManyOneIdOwner.class, ManyOneCompoundIdOwner.class);
        BasicEntity id1 = new BasicEntity();
        id1.setName("id1");
        BasicEntity id2 = new BasicEntity();
        id2.setName("id2");
        id1.setRel(id2);
        id2.setRel(id1);
        DataStoreBasicEntity dsid1 = new DataStoreBasicEntity();
        dsid1.setName("dsid1");
        dsid1.setRel(id1);
        DataStoreBasicEntity dsid2 = new DataStoreBasicEntity();
        dsid2.setName("dsid2");
        dsid2.setRel(id2);
        ManyOneIdOwner parent = new ManyOneIdOwner();
        parent.setId(id1);
        parent.setName("parent");
        ManyOneIdOwner child = new ManyOneIdOwner();
        child.setId(id2);
        child.setName("child");
        parent.setSelfRel(child);
        DataStoreManyOneIdOwner dsparent = new DataStoreManyOneIdOwner();
        dsparent.setId(dsid1);
        dsparent.setName("dsparent");
        DataStoreManyOneIdOwner dschild = new DataStoreManyOneIdOwner();
        dschild.setId(dsid2);
        dschild.setName("dschild");
        dsparent.setSelfRel(dschild);
        ManyOneCompoundIdOwner cparent = new ManyOneCompoundIdOwner();
        cparent.setEntityId(id1);
        cparent.setName("cparent");
        ManyOneCompoundIdOwner cchild = new ManyOneCompoundIdOwner();
        cchild.setEntityId(id2);
        cchild.setName("cchild");
        cparent.setSelfRel(cchild);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)id1);
        em.persist((Object)id2);
        em.persist((Object)dsid1);
        em.persist((Object)dsid2);
        em.persist((Object)parent);
        em.persist((Object)child);
        em.persist((Object)dsparent);
        em.persist((Object)dschild);
        em.persist((Object)cparent);
        em.persist((Object)cchild);
        em.getTransaction().commit();
        this.id = id1.getId();
        this.assertRelations((EntityManager)em, parent);
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em;
        this.dsid = (Long)oem.getObjectId((Object)dsid1);
        this.assertDataStoreRelations(oem, dsparent);
        this.cid = cparent.getLongId();
        this.assertCompoundRelations(oem, cparent);
        em.close();
    }

    private void assertRelations(EntityManager em, ManyOneIdOwner parent) {
        TestManyOneAsId.assertEquals((String)"parent", (String)parent.getName());
        BasicEntity id1 = parent.getId();
        TestManyOneAsId.assertNotNull((Object)id1);
        TestManyOneAsId.assertEquals((long)this.id, (long)id1.getId());
        TestManyOneAsId.assertEquals((String)"id1", (String)id1.getName());
        TestManyOneAsId.assertTrue((id1 == em.find(BasicEntity.class, (Object)this.id) ? 1 : 0) != 0);
        ManyOneIdOwner child = parent.getSelfRel();
        TestManyOneAsId.assertNotNull((Object)child);
        TestManyOneAsId.assertEquals((String)"child", (String)child.getName());
        BasicEntity id2 = child.getId();
        TestManyOneAsId.assertNotNull((Object)id2);
        TestManyOneAsId.assertEquals((String)"id2", (String)id2.getName());
        TestManyOneAsId.assertTrue((id2 == em.find(BasicEntity.class, (Object)id2.getId()) ? 1 : 0) != 0);
        TestManyOneAsId.assertTrue((id2 == id1.getRel() ? 1 : 0) != 0);
        TestManyOneAsId.assertTrue((id1 == id2.getRel() ? 1 : 0) != 0);
        TestManyOneAsId.assertNull((Object)child.getSelfRel());
    }

    private void assertDataStoreRelations(OpenJPAEntityManager em, DataStoreManyOneIdOwner dsparent) {
        TestManyOneAsId.assertEquals((String)"dsparent", (String)dsparent.getName());
        DataStoreBasicEntity dsid1 = dsparent.getId();
        TestManyOneAsId.assertNotNull((Object)dsid1);
        TestManyOneAsId.assertEquals((long)this.dsid, (long)((Long)em.getObjectId((Object)dsid1)));
        TestManyOneAsId.assertEquals((String)"dsid1", (String)dsid1.getName());
        TestManyOneAsId.assertTrue((dsid1 == em.find(DataStoreBasicEntity.class, (Object)this.dsid) ? 1 : 0) != 0);
        DataStoreManyOneIdOwner dschild = dsparent.getSelfRel();
        TestManyOneAsId.assertNotNull((Object)dschild);
        TestManyOneAsId.assertEquals((String)"dschild", (String)dschild.getName());
        DataStoreBasicEntity dsid2 = dschild.getId();
        TestManyOneAsId.assertNotNull((Object)dsid2);
        TestManyOneAsId.assertEquals((String)"dsid2", (String)dsid2.getName());
        TestManyOneAsId.assertTrue((dsid2 == em.find(DataStoreBasicEntity.class, em.getObjectId((Object)dsid2)) ? 1 : 0) != 0);
        TestManyOneAsId.assertNull((Object)dschild.getSelfRel());
    }

    private void assertCompoundRelations(OpenJPAEntityManager em, ManyOneCompoundIdOwner cparent) {
        TestManyOneAsId.assertEquals((String)"cparent", (String)cparent.getName());
        BasicEntity id1 = cparent.getEntityId();
        TestManyOneAsId.assertNotNull((Object)id1);
        TestManyOneAsId.assertEquals((long)this.id, (long)id1.getId());
        TestManyOneAsId.assertEquals((String)"id1", (String)id1.getName());
        TestManyOneAsId.assertTrue((id1 == em.find(BasicEntity.class, (Object)this.id) ? 1 : 0) != 0);
        ManyOneCompoundIdOwner cchild = cparent.getSelfRel();
        TestManyOneAsId.assertNotNull((Object)cchild);
        TestManyOneAsId.assertEquals((String)"cchild", (String)cchild.getName());
        BasicEntity id2 = cchild.getEntityId();
        TestManyOneAsId.assertNotNull((Object)id2);
        TestManyOneAsId.assertEquals((String)"id2", (String)id2.getName());
        TestManyOneAsId.assertTrue((id2 == em.find(BasicEntity.class, (Object)id2.getId()) ? 1 : 0) != 0);
        TestManyOneAsId.assertNull((Object)cchild.getSelfRel());
        ManyOneCompoundIdOwnerId oid = (ManyOneCompoundIdOwnerId)em.getObjectId((Object)cparent);
        TestManyOneAsId.assertEquals((long)this.id, (long)oid.entityId);
    }

    public void testRetrieveWithManyOneId() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ManyOneIdOwner parent = (ManyOneIdOwner)em.find(ManyOneIdOwner.class, (Object)this.id);
        TestManyOneAsId.assertNotNull((Object)parent);
        this.assertRelations((EntityManager)em, parent);
        em.close();
    }

    public void testRetrieveWithDataStoreManyOneId() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DataStoreManyOneIdOwner dsparent = (DataStoreManyOneIdOwner)em.find(DataStoreManyOneIdOwner.class, (Object)this.dsid);
        TestManyOneAsId.assertNotNull((Object)dsparent);
        this.assertDataStoreRelations((OpenJPAEntityManager)em, dsparent);
        em.close();
    }

    public void testRetrieveWithCompoundManyOneId() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ManyOneCompoundIdOwnerId oid = new ManyOneCompoundIdOwnerId();
        oid.entityId = this.id;
        oid.longId = this.cid;
        ManyOneCompoundIdOwner cparent = (ManyOneCompoundIdOwner)em.find(ManyOneCompoundIdOwner.class, (Object)oid);
        TestManyOneAsId.assertNotNull((Object)cparent);
        this.assertCompoundRelations((OpenJPAEntityManager)em, cparent);
        em.close();
    }

    public void testAttemptToChangeManyOne() {
        OpenJPAEntityManagerSPI em;
        block2: {
            em = this.emf.createEntityManager();
            ManyOneIdOwner parent = (ManyOneIdOwner)em.find(ManyOneIdOwner.class, (Object)this.id);
            TestManyOneAsId.assertNotNull((Object)parent);
            TestManyOneAsId.assertNotNull((Object)parent.getSelfRel());
            em.getTransaction().begin();
            try {
                parent.setId(parent.getSelfRel().getId());
                em.getTransaction().commit();
                TestManyOneAsId.fail((String)"Successfully changed id relation.");
            }
            catch (Exception e) {
                if (!em.getTransaction().isActive()) break block2;
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    public void testChangeRelationToManyOneOwner() {
        BasicEntity id3 = new BasicEntity();
        id3.setName("id3");
        ManyOneIdOwner child2 = new ManyOneIdOwner();
        child2.setName("child2");
        child2.setId(id3);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)id3);
        em.persist((Object)child2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        ManyOneIdOwner parent = (ManyOneIdOwner)em.find(ManyOneIdOwner.class, (Object)this.id);
        TestManyOneAsId.assertNotNull((Object)parent);
        em.getTransaction().begin();
        parent.setSelfRel(child2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        parent = (ManyOneIdOwner)em.find(ManyOneIdOwner.class, (Object)this.id);
        child2 = parent.getSelfRel();
        TestManyOneAsId.assertEquals((String)"child2", (String)child2.getName());
        TestManyOneAsId.assertEquals((long)id3.getId(), (long)child2.getId().getId());
        em.close();
    }

    public void testChangeRelationToDataStoreManyOneOwner() {
        DataStoreBasicEntity dsid3 = new DataStoreBasicEntity();
        dsid3.setName("dsid3");
        DataStoreManyOneIdOwner dschild2 = new DataStoreManyOneIdOwner();
        dschild2.setName("dschild2");
        dschild2.setId(dsid3);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)dsid3);
        em.persist((Object)dschild2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        DataStoreManyOneIdOwner dsparent = (DataStoreManyOneIdOwner)em.find(DataStoreManyOneIdOwner.class, (Object)this.dsid);
        TestManyOneAsId.assertNotNull((Object)dsparent);
        em.getTransaction().begin();
        dsparent.setSelfRel(dschild2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        dsparent = (DataStoreManyOneIdOwner)em.find(DataStoreManyOneIdOwner.class, (Object)this.dsid);
        dschild2 = dsparent.getSelfRel();
        TestManyOneAsId.assertEquals((String)"dschild2", (String)dschild2.getName());
        OpenJPAEntityManager oem = (OpenJPAEntityManager)em;
        TestManyOneAsId.assertEquals((Object)oem.getObjectId((Object)dsid3), (Object)oem.getObjectId((Object)dschild2.getId()));
        em.close();
    }

    public void testChangeRelationToCompoundManyOneOwner() {
        BasicEntity id3 = new BasicEntity();
        id3.setName("id3");
        ManyOneCompoundIdOwner cchild2 = new ManyOneCompoundIdOwner();
        cchild2.setName("cchild2");
        cchild2.setEntityId(id3);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)id3);
        em.persist((Object)cchild2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        ManyOneCompoundIdOwnerId oid = new ManyOneCompoundIdOwnerId();
        oid.entityId = this.id;
        oid.longId = this.cid;
        ManyOneCompoundIdOwner cparent = (ManyOneCompoundIdOwner)em.find(ManyOneCompoundIdOwner.class, (Object)oid);
        TestManyOneAsId.assertNotNull((Object)cparent);
        em.getTransaction().begin();
        cparent.setSelfRel(cchild2);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        cparent = (ManyOneCompoundIdOwner)em.find(ManyOneCompoundIdOwner.class, (Object)oid);
        cchild2 = cparent.getSelfRel();
        TestManyOneAsId.assertEquals((String)"cchild2", (String)cchild2.getName());
        TestManyOneAsId.assertEquals((long)id3.getId(), (long)cchild2.getEntityId().getId());
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from ManyOneIdOwner e where e.id.id = :id");
        q.setParameter("id", (Object)this.id);
        ManyOneIdOwner pc = (ManyOneIdOwner)q.getSingleResult();
        TestManyOneAsId.assertNotNull((Object)pc);
        TestManyOneAsId.assertEquals((String)"parent", (String)pc.getName());
        em.close();
        em = this.emf.createEntityManager();
        BasicEntity id1 = (BasicEntity)em.find(BasicEntity.class, (Object)this.id);
        TestManyOneAsId.assertNotNull((Object)id1);
        TestManyOneAsId.assertEquals((String)"id1", (String)id1.getName());
        q = em.createQuery("select e from ManyOneIdOwner e where e.id = :id");
        q.setParameter("id", (Object)id1);
        pc = (ManyOneIdOwner)q.getSingleResult();
        TestManyOneAsId.assertNotNull((Object)pc);
        TestManyOneAsId.assertEquals((String)"parent", (String)pc.getName());
        em.close();
    }

    public void testDataStoreQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        DataStoreBasicEntity dsid1 = (DataStoreBasicEntity)em.find(DataStoreBasicEntity.class, (Object)this.dsid);
        TestManyOneAsId.assertNotNull((Object)dsid1);
        TestManyOneAsId.assertEquals((String)"dsid1", (String)dsid1.getName());
        Query q = em.createQuery("select e from DataStoreManyOneIdOwner e where e.id = :id");
        q.setParameter("id", (Object)dsid1);
        DataStoreManyOneIdOwner dspc = (DataStoreManyOneIdOwner)q.getSingleResult();
        TestManyOneAsId.assertNotNull((Object)dspc);
        TestManyOneAsId.assertEquals((String)"dsparent", (String)dspc.getName());
        em.close();
    }

    public void testCompoundQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select e from ManyOneCompoundIdOwner e where e.longId = :cid and e.entityId.id = :id");
        q.setParameter("cid", (Object)this.cid);
        q.setParameter("id", (Object)this.id);
        ManyOneCompoundIdOwner pc = (ManyOneCompoundIdOwner)q.getSingleResult();
        TestManyOneAsId.assertNotNull((Object)pc);
        TestManyOneAsId.assertEquals((String)"cparent", (String)pc.getName());
        em.close();
        em = this.emf.createEntityManager();
        BasicEntity id1 = (BasicEntity)em.find(BasicEntity.class, (Object)this.id);
        TestManyOneAsId.assertNotNull((Object)id1);
        TestManyOneAsId.assertEquals((String)"id1", (String)id1.getName());
        q = em.createQuery("select e from ManyOneCompoundIdOwner e where e.longId = :cid and e.entityId = :id");
        q.setParameter("cid", (Object)this.cid);
        q.setParameter("id", (Object)id1);
        pc = (ManyOneCompoundIdOwner)q.getSingleResult();
        TestManyOneAsId.assertNotNull((Object)pc);
        TestManyOneAsId.assertEquals((String)"cparent", (String)pc.getName());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestManyOneAsId.class);
    }
}

