/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import javax.persistence.Query;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.EmbeddableWithRelation;
import org.apache.openjpa.persistence.relations.MultipleSameTypedEmbedded;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMultipleSameTypedEmbeddedWithEagerRelations
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(EmbeddableWithRelation.class, MultipleSameTypedEmbedded.class);
        EmbeddableWithRelation embed1 = new EmbeddableWithRelation();
        embed1.setName("embed1");
        EmbeddableWithRelation embed2 = new EmbeddableWithRelation();
        embed2.setName("embed2");
        MultipleSameTypedEmbedded m1 = new MultipleSameTypedEmbedded();
        m1.setName("m1");
        m1.setEmbed1(embed1);
        m1.setEmbed2(embed2);
        MultipleSameTypedEmbedded m2 = new MultipleSameTypedEmbedded();
        m2.setName("m2");
        m2.setEmbed1(embed2);
        m2.setEmbed2(embed1);
        embed1.setRel(m1);
        embed2.setRel(m2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)m1);
        em.persist((Object)m2);
        em.getTransaction().commit();
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query q = em.createQuery("select m from MultipleSameTypedEmbedded m where m.embed1.rel.name = 'm1' and m.embed2.rel.name = 'm2'");
        List res = q.getResultList();
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((int)1, (int)res.size());
        MultipleSameTypedEmbedded m = (MultipleSameTypedEmbedded)res.get(0);
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((String)"m1", (String)m.getName());
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((String)"embed1", (String)m.getEmbed1().getName());
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((String)"m1", (String)m.getEmbed1().getRel().getName());
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((String)"embed2", (String)m.getEmbed2().getName());
        TestMultipleSameTypedEmbeddedWithEagerRelations.assertEquals((String)"m2", (String)m.getEmbed2().getRel().getName());
        em.close();
    }

    public static void main(String[] args) {
        TestRunner.run(TestMultipleSameTypedEmbeddedWithEagerRelations.class);
    }
}

