/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.ACase;
import org.apache.openjpa.persistence.relations.AEvident;
import org.apache.openjpa.persistence.relations.AText;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestO2ORefColumn
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, ACase.class, AText.class, AEvident.class, "openjpa.jdbc.MappingDefaults", "ForeignKeyDeleteAction=cascade,JoinForeignKeyDeleteAction=cascade");
    }

    public void testRefColumnJoinEntities() {
        AEvident aEvident = new AEvident();
        aEvident.setName("Evident_A");
        AText aText = new AText();
        aText.setName("Text_A");
        aText.getAEvidents().add(aEvident);
        aEvident.setAText(aText);
        ACase aCase = new ACase();
        aCase.setName("Case_A");
        aCase.setAText(aText);
        aText.setACase(aCase);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)aEvident);
        em.persist((Object)aText);
        em.persist((Object)aCase);
        em.getTransaction().commit();
        this.verify(aCase, aText, aEvident);
        em.clear();
        ACase fACase = (ACase)em.find(ACase.class, (Object)aCase.getId());
        AText fAText = fACase.getAText();
        AEvident fAEvident = fAText.getAEvidents().iterator().next();
        this.verify(fACase, fAText, fAEvident);
        em.close();
    }

    private void verify(ACase aCase, AText aText, AEvident aEvident) {
        Assert.assertNotNull((Object)aCase);
        Assert.assertNotNull((Object)aText);
        Assert.assertNotNull((Object)aEvident);
        Assert.assertTrue((aCase.getId() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((aText.getId() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((aEvident.getId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Case_A", (String)aCase.getName());
        Assert.assertEquals((String)"Text_A", (String)aText.getName());
        Assert.assertEquals((String)"Evident_A", (String)aEvident.getName());
        Assert.assertNotNull((Object)aCase.getAText());
        Assert.assertSame((Object)aCase.getAText(), (Object)aText);
        Assert.assertNotNull((Object)aText.getACase());
        Assert.assertSame((Object)aCase, (Object)aText.getACase());
        Assert.assertEquals((int)aText.getACaseId(), (int)aCase.getId());
        Assert.assertNotNull(aText.getAEvidents());
        Assert.assertTrue((boolean)aText.getAEvidents().iterator().hasNext());
        Assert.assertSame((Object)aEvident, (Object)aText.getAEvidents().iterator().next());
        Assert.assertNotNull((Object)aEvident.getAText());
        Assert.assertSame((Object)aText, (Object)aEvident.getAText());
    }
}

