/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.relations;

import java.util.List;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.relations.C;
import org.apache.openjpa.persistence.relations.CM;
import org.apache.openjpa.persistence.relations.D;
import org.apache.openjpa.persistence.relations.E;
import org.apache.openjpa.persistence.relations.VC;
import org.apache.openjpa.persistence.relations.VCS;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestRelationFieldAsPrimaryKeyAndForeignKey
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(C.class, CM.class, D.class, E.class, VC.class, VCS.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            List es = em.createQuery("Select e from E e").getResultList();
            for (E e : es) {
                em.remove((Object)e);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        E e = new E();
        e.setEId("E1");
        e.setName("E1");
        VC vc = new VC();
        vc.setVcId("VC1");
        VCS vcset = new VCS();
        vcset.setVcsId("VCS1");
        vcset.setName("VCSET1");
        vcset.addVC(vc);
        vcset.setE(e);
        C c = new C();
        c.setCId("C1");
        CM cm = new CM();
        cm.setCmId("CM1");
        cm.setE(e);
        cm.addC(c);
        D d = new D();
        d.setA("addr");
        d.setVc(vc);
        d.setId("IM1");
        em.persist((Object)e);
        em.persist((Object)vc);
        em.persist((Object)vcset);
        em.persist((Object)c);
        em.persist((Object)cm);
        em.persist((Object)d);
        em.getTransaction().commit();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnboundEntities() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        VCS vcSet = new VCS();
        vcSet.setVcsId("VCSET2");
        vcSet.setName("VCSET2");
        try {
            em.persist((Object)vcSet);
            em.getTransaction().commit();
            Assert.fail((String)"didn't throw expected PersistenceException");
        }
        catch (Exception e) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.getTransaction().begin();
        VC vc = new VC();
        vc.setVcId("VC2");
        try {
            em.persist((Object)vc);
            em.getTransaction().commit();
            Assert.fail((String)"didn't throw expected PersistenceException");
        }
        catch (Exception e) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.getTransaction().begin();
        CM cm = new CM();
        cm.setCmId("CMID2");
        try {
            em.persist((Object)cm);
            em.getTransaction().commit();
            Assert.fail((String)"didn't throw expected PersistenceException");
        }
        catch (Exception e) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.getTransaction().begin();
        C c = new C();
        c.setCId("CID2");
        try {
            em.persist((Object)c);
            em.getTransaction().commit();
            Assert.fail((String)"didn't throw expected PersistenceException");
        }
        catch (Exception e) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        List es = em.createQuery("Select e from E e where e.name='E1'").getResultList();
        Assert.assertEquals((int)1, (int)es.size());
        E e = (E)es.get(0);
        Assert.assertEquals((String)"E1", (String)e.getName());
        Assert.assertEquals((int)1, (int)e.getVcss().size());
        Assert.assertEquals((int)1, (int)e.getCms().size());
        Assert.assertEquals((int)1, (int)e.getVcss().size());
        List vcss = em.createQuery("Select vcset from VCS vcset where vcset.vcsId='VCS1'").getResultList();
        Assert.assertEquals((int)1, (int)vcss.size());
        Assert.assertEquals((Object)e, (Object)((VCS)vcss.get(0)).getE());
        em.close();
    }

    public void testDeletes() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        VCS vcset = (VCS)em.createQuery("Select vcset from VCS vcset where vcset.vcsId='VCS1'").getSingleResult();
        em.remove((Object)vcset);
        em.getTransaction().commit();
        List vcs = em.createQuery("Select vc from VC vc where vc.vcId='VC1'").getResultList();
        Assert.assertEquals((int)0, (int)vcs.size());
        List es = em.createQuery("Select e from E e").getResultList();
        Assert.assertEquals((int)1, (int)es.size());
    }

    @Override
    public void tearDown() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        List es = em.createQuery("Select e from E e").getResultList();
        for (E e : es) {
            em.remove((Object)e);
        }
        em.getTransaction().commit();
        em.close();
        super.tearDown();
    }
}

