/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.results.cls;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.results.cls.ResultClsXml;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestResultClsXml
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        this.setUp(ResultClsXml.class, DROP_TABLES);
        TestResultClsXml.assertNotNull((Object)this.emf);
        this.populate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIt() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Query q = this.getQuery((EntityManager)em);
            List result = q.getResultList();
            TestResultClsXml.assertEquals((int)1, (int)result.size());
            for (Object obj : result) {
                ResultClsXml ct = (ResultClsXml)obj;
                TestResultClsXml.assertEquals((String)"id1", (String)ct.getId());
                TestResultClsXml.assertEquals((String)"description1", (String)ct.getDescription());
            }
        }
        catch (Exception ex) {
            TestResultClsXml.fail((String)("unexpected exception: " + ex.getMessage()));
            ex.printStackTrace();
        }
        finally {
            em.close();
        }
    }

    @Override
    protected String getPersistenceUnitName() {
        return "query-result";
    }

    private void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        ResultClsXml ct = new ResultClsXml();
        ct.setId("id1");
        ct.setDescription("description1");
        em.persist((Object)ct);
        em.getTransaction().commit();
        em.close();
    }

    private Query getQuery(EntityManager em) {
        DBDictionary dict = this.getDBDictionary();
        Query query = null;
        query = dict.getLeadingDelimiter().equals("\"") && dict.getTrailingDelimiter().equals("\"") ? em.createNamedQuery("ResultClsQueryDoubleQuotes") : (dict.getLeadingDelimiter().equals("`") && dict.getTrailingDelimiter().equals("`") ? em.createNamedQuery("ResultClsQueryBackTicks") : (dict.getLeadingDelimiter().equals("[") && dict.getTrailingDelimiter().equals("]") ? em.createNamedQuery("ResultClsQueryBrackets") : em.createNamedQuery("ResultClsQueryDefault")));
        return query;
    }
}

