/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.sequence;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDropAddSequence
extends SingleEMFTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        OpenJPAEntityManagerFactorySPI tempEMF = this.createNamedEMF("test", new Object[0]);
        try {
            if (!this.supportsSequences(tempEMF)) {
                return;
            }
        }
        finally {
            if (tempEMF != null) {
                tempEMF.close();
            }
        }
        super.setUp();
        this.emf.createEntityManager().close();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "TestDropAddSequence";
    }

    public void testDropAddSequence() {
        if (!this.supportsSequences(this.emf)) {
            return;
        }
        Object[] props = new Object[]{"openjpa.jdbc.SynchronizeMappings", "buildSchema(SchemaAction='drop,add')"};
        OpenJPAEntityManagerFactorySPI oemf = this.createNamedEMF("TestDropAddSequence", props);
        OpenJPAEntityManagerSPI em = oemf.createEntityManager();
        em.close();
        oemf.close();
    }

    private boolean supportsSequences(OpenJPAEntityManagerFactorySPI oemf) {
        if (oemf == null) {
            return false;
        }
        DBDictionary dict = ((JDBCConfiguration)oemf.getConfiguration()).getDBDictionaryInstance();
        if (dict != null) {
            return dict.nextSequenceQuery != null;
        }
        return false;
    }
}

