/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.sequence.hsql;

import java.util.List;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.HSQLDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.sequence.hsql.HSQLEmployee;
import org.apache.openjpa.persistence.sequence.hsql.HSQLEmployee2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestHSQLSequence
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    JDBCConfiguration conf;
    DBDictionary dict;

    @Override
    public void setUp() throws Exception {
        boolean supportsNativeSequence;
        this.setSupportedDatabases(HSQLDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(HSQLEmployee.class, HSQLEmployee2.class, DROP_TABLES, "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        TestHSQLSequence.assertNotNull((Object)this.emf);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
        boolean bl = supportsNativeSequence = this.dict.nextSequenceQuery != null;
        if (supportsNativeSequence) {
            this.em = this.emf.createEntityManager();
            TestHSQLSequence.assertNotNull((Object)this.em);
            OpenJPAQuery q = this.em.createNativeQuery("SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES");
            List rs = q.getResultList();
            this.em.getTransaction().begin();
            for (Object[] os : rs) {
                String schemaQualifier = (String)os[0];
                String schemaName = (String)os[1];
                if (!"PUBLIC".equals(schemaQualifier) || schemaName.equals("HEMP_SEQ")) continue;
                q = this.em.createNativeQuery("DROP SEQUENCE " + schemaName);
                q.executeUpdate();
            }
            this.em.getTransaction().commit();
            this.em.clear();
        }
    }

    public HSQLEmployee createHSQLEmployee(String first, String last) {
        HSQLEmployee e = new HSQLEmployee();
        e.setFirstName(first);
        e.setLastName(last);
        this.em.getTransaction().begin();
        this.em.persist((Object)e);
        this.em.getTransaction().commit();
        int id = e.getId();
        this.em.clear();
        return (HSQLEmployee)this.em.find(HSQLEmployee.class, (Object)id);
    }

    public HSQLEmployee2 createHSQLEmployee2(String first, String last) {
        HSQLEmployee2 e = new HSQLEmployee2();
        e.setFirstName(first);
        e.setLastName(last);
        this.em.getTransaction().begin();
        this.em.persist((Object)e);
        this.em.getTransaction().commit();
        int id = e.getId();
        this.em.clear();
        return (HSQLEmployee2)this.em.find(HSQLEmployee2.class, (Object)id);
    }

    public void testId() {
        int id = 0;
        for (int counter = 1; counter <= 20; ++counter) {
            HSQLEmployee2 e = this.createHSQLEmployee2("Ferris" + counter, "Erris");
            TestHSQLSequence.assertNotNull((Object)e);
            id = e.getId();
            TestHSQLSequence.assertEquals((int)counter, (int)id);
        }
    }

    public void testId2() {
        int id = 0;
        for (int counter = 1; counter <= 20; ++counter) {
            HSQLEmployee e = this.createHSQLEmployee("Ferris" + counter, "Erris");
            TestHSQLSequence.assertNotNull((Object)e);
            id = e.getId();
            TestHSQLSequence.assertEquals((int)counter, (int)id);
        }
    }
}

