/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.math.BigDecimal;
import junit.textui.TestRunner;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.simple.Item;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestEntityManagerClear
extends SingleEMTestCase {
    @Override
    public void setUp() {
        this.setUp(AllFieldTypes.class, Item.class, CLEAR_TABLES);
    }

    public void testDetach() {
        this.begin();
        AllFieldTypes testObject1 = new AllFieldTypes();
        testObject1.setStringField("my test object1");
        this.persist(testObject1);
        this.em.flush();
        TestEntityManagerClear.assertTrue((String)"testObject1 not found in pc", (boolean)this.em.contains((Object)testObject1));
        AllFieldTypes testObject2 = new AllFieldTypes();
        testObject1.setStringField("my test object2");
        this.persist(testObject2);
        TestEntityManagerClear.assertTrue((String)"testObject2 not found in pc", (boolean)this.em.contains((Object)testObject2));
        this.rollback();
        TestEntityManagerClear.assertFalse((String)"testObject1 found in pc", (boolean)this.em.contains((Object)testObject1));
        TestEntityManagerClear.assertFalse((String)"testObject2 found in pc", (boolean)this.em.contains((Object)testObject2));
    }

    public void testClear() {
        this.begin();
        AllFieldTypes testObject1 = new AllFieldTypes();
        testObject1.setStringField("my test object1");
        this.persist(testObject1);
        this.em.flush();
        AllFieldTypes testObject2 = new AllFieldTypes();
        testObject1.setStringField("my test object2");
        this.persist(testObject2);
        this.em.clear();
        this.commit();
        this.begin();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from AllFieldTypes x where x.stringField = 'my test object1'").getResultList().size());
        TestEntityManagerClear.assertEquals((int)0, (int)this.query("select x from AllFieldTypes x where x.stringField = 'my test object2'").getResultList().size());
        this.rollback();
    }

    public void testNewClearMerge() {
        this.begin();
        AllFieldTypes testObject1 = new AllFieldTypes();
        testObject1.setStringField("my test object1");
        this.persist(testObject1);
        this.em.clear();
        TestEntityManagerClear.assertEquals((int)0, (int)this.query("select x from AllFieldTypes x where x.stringField = 'my test object1'").getResultList().size());
        this.em.merge((Object)testObject1);
        this.commit();
        this.begin();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from AllFieldTypes x where x.stringField = 'my test object1'").getResultList().size());
        this.rollback();
    }

    public void testUpdateClearMerge() {
        this.begin();
        Item i = new Item();
        i.setItemName("cup");
        this.persist(i);
        this.commit();
        int id = i.getItemId();
        this.begin();
        Item i2 = (Item)this.em.find(Item.class, (Object)id);
        i2.setItemName("fancy cup");
        this.em.clear();
        TestEntityManagerClear.assertEquals((int)0, (int)this.query("select x from Item x where x.itemName = 'fancy cup'").getResultList().size());
        this.em.merge((Object)i2);
        this.commit();
        this.begin();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from Item x where x.itemName = 'fancy cup'").getResultList().size());
        this.rollback();
    }

    public void testUpdateClearUpdateMerge() {
        this.begin();
        Item i = new Item();
        i.setItemName("cup");
        i.setItemPrice(new BigDecimal(100.0));
        this.persist(i);
        this.commit();
        int id = i.getItemId();
        this.begin();
        Item i2 = (Item)this.em.find(Item.class, (Object)id);
        i2.setItemName("fancy cup");
        this.em.clear();
        TestEntityManagerClear.assertEquals((int)0, (int)this.query("select x from Item x where x.itemName = 'fancy cup'").getResultList().size());
        i2.setItemPrice(new BigDecimal(120.0));
        this.em.merge((Object)i2);
        this.commit();
        this.begin();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from Item x where x.itemName = 'fancy cup' and x.itemPrice = 120.00").getResultList().size());
        this.rollback();
    }

    public void testUpdateFlushClearUpdateMerge() {
        this.begin();
        Item i = new Item();
        i.setItemName("cup");
        i.setItemPrice(new BigDecimal(100.0));
        this.persist(i);
        this.commit();
        int id = i.getItemId();
        this.begin();
        Item i2 = (Item)this.em.find(Item.class, (Object)id);
        i2.setItemName("fancy cup");
        this.em.flush();
        this.em.clear();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from Item x where x.itemName = 'fancy cup'").getResultList().size());
        i2.setItemPrice(new BigDecimal(120.0));
        i2.setItemName("red cup");
        this.em.merge((Object)i2);
        this.commit();
        this.begin();
        TestEntityManagerClear.assertEquals((int)1, (int)this.query("select x from Item x where x.itemName = 'red cup' and x.itemPrice = 120.00").getResultList().size());
        this.rollback();
    }

    public static void main(String[] args) {
        TestRunner.run(TestEntityManagerClear.class);
    }
}

