/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.simple.Item;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestFlushBeforeDetach
extends SQLListenerTestCase {
    private int _id;

    @Override
    public void setUp() {
        this.setUp(Item.class, "openjpa.Compatibility", "default(flushBeforeDetach=false,copyOnDetach=true)");
        this.persistSampleEntity();
    }

    private void persistSampleEntity() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = new Item();
        em.persist((Object)i);
        em.getTransaction().commit();
        em.refresh((Object)i);
        this._id = i.getItemId();
        em.close();
    }

    public void testClear() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = (Item)em.find(Item.class, (Object)this._id);
        i.setItemData("ABCD");
        em.clear();
        em.getTransaction().rollback();
        this.assertNotSQL("UPDATE ITEM.*");
        em.close();
    }

    public void testDetach() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = (Item)em.find(Item.class, (Object)this._id);
        i.setItemData("EFGH");
        OpenJPAPersistence.cast((EntityManager)em).detach((Object)i);
        em.getTransaction().rollback();
        this.assertNotSQL("UPDATE ITEM SET.*");
        em.close();
    }

    public void testDetachAll() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = (Item)em.find(Item.class, (Object)this._id);
        i.setItemData("IJKL");
        OpenJPAPersistence.cast((EntityManager)em).detachAll(new Object[]{i});
        em.getTransaction().rollback();
        this.assertNotSQL("UPDATE ITEM SET.*");
        em.close();
    }

    public void testDetachAllCollection() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = (Item)em.find(Item.class, (Object)this._id);
        i.setItemData("MNOP");
        ArrayList<Item> c = new ArrayList<Item>();
        c.add(i);
        OpenJPAPersistence.cast((EntityManager)em).detachAll(c);
        em.getTransaction().rollback();
        this.assertNotSQL("UPDATE ITEM SET.*");
        em.close();
    }

    public void testSerialize() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Item i = (Item)em.find(Item.class, (Object)this._id);
        i.setItemData("QRSTU");
        this.serializeObject(i);
        em.getTransaction().rollback();
        this.assertNotSQL("UPDATE ITEM SET.*");
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object serializeObject(Object orig) throws Exception {
        Object deserialized = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(orig);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream(bais);
            Object object = deserialized = ois.readObject();
            return object;
        }
        finally {
            oos.close();
            ois.close();
        }
    }
}

