/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.spring;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.openjpa.persistence.models.library.Book;
import org.apache.openjpa.persistence.models.library.Borrower;
import org.apache.openjpa.persistence.spring.LibService;
import org.apache.openjpa.persistence.spring.TransactionalEntityManagerFactory;

public class LibServiceImpl
implements LibService {
    private TransactionalEntityManagerFactory txEMF;

    private void closeEM(EntityManager em) {
        if (em != null && em.isOpen()) {
            em.close();
        }
    }

    private EntityManager openEM() {
        EntityManager em = this.txEMF.getTransactionalEntityManager();
        return em;
    }

    private void commit(EntityTransaction tx) {
        if (tx != null && tx.isActive()) {
            if (tx.getRollbackOnly()) {
                tx.rollback();
            } else {
                tx.commit();
            }
        }
    }

    @Override
    public void setTransactionalEntityManagerFactory(TransactionalEntityManagerFactory txEMF) {
        this.txEMF = txEMF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book findBookByTitle(String title) {
        EntityManager em = null;
        try {
            Book retv;
            em = this.openEM();
            if (title != null) {
                title = title.trim();
            }
            if (title == null || title.length() <= 0) {
                throw new IllegalArgumentException("the title cannot be null or empty");
            }
            Query query = em.createQuery("select b from Book b join fetch b.subjects where b.title = :x");
            query.setParameter("x", (Object)title);
            Book book = retv = (Book)query.getSingleResult();
            return book;
        }
        finally {
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Borrower findBorrowerByName(String name) {
        EntityManager em = null;
        try {
            Borrower retv;
            em = this.openEM();
            if (name != null) {
                name = name.trim();
            }
            if (name == null || name.length() <= 0) {
                throw new IllegalArgumentException("the name cannot be null or empty");
            }
            Query query = em.createQuery("select b from Borrower b where b.name = :x");
            query.setParameter("x", (Object)name);
            Borrower borrower = retv = (Borrower)query.getSingleResult();
            return borrower;
        }
        finally {
            this.closeEM(em);
        }
    }

    @Override
    public void borrowBook(Borrower borrower, Book book) {
        EntityTransaction tx;
        EntityManager em;
        block5: {
            em = null;
            tx = null;
            em = this.openEM();
            tx = em.getTransaction();
            tx.begin();
            if (borrower != null && book != null) break block5;
            this.commit(tx);
            this.closeEM(em);
            return;
        }
        try {
            borrower.borrowBook(book);
            em.merge((Object)book);
        }
        catch (RuntimeException e) {
            try {
                tx.setRollbackOnly();
                throw e;
            }
            catch (Throwable throwable) {
                this.commit(tx);
                this.closeEM(em);
                throw throwable;
            }
        }
        this.commit(tx);
        this.closeEM(em);
    }

    @Override
    public void returnBook(Book book) {
        EntityTransaction tx;
        EntityManager em;
        block6: {
            em = null;
            tx = null;
            em = this.openEM();
            tx = em.getTransaction();
            tx.begin();
            if (book != null) break block6;
            this.commit(tx);
            this.closeEM(em);
            return;
        }
        try {
            Borrower borrower = book.getBorrower();
            if (borrower != null) {
                borrower.returnBook(book);
                em.merge((Object)book);
            }
        }
        catch (RuntimeException e) {
            try {
                tx.setRollbackOnly();
                throw e;
            }
            catch (Throwable throwable) {
                this.commit(tx);
                this.closeEM(em);
                throw throwable;
            }
        }
        this.commit(tx);
        this.closeEM(em);
    }
}

