/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.DatabasePlatform;
import org.apache.openjpa.persistence.test.JPAEntityClassEnum;

public abstract class AbstractPersistenceTestCase
extends TestCase {
    public static final String FRESH_EMF = "Creates new EntityManagerFactory";
    public static final String RETAIN_DATA = "Retain data after test run";
    private boolean retainDataOnTearDown;
    protected boolean _fresh = false;
    private Boolean testsDisabled = Boolean.FALSE;
    public static final String ALLOW_FAILURE_LOG = "log";
    public static final String ALLOW_FAILURE_IGNORE = "ignore";
    public static final String ALLOW_FAILURE_SYS_PROP = "tests.openjpa.allowfailure";
    private static String allowFailureConfig = System.getProperty("tests.openjpa.allowfailure", "ignore");
    protected static final Object CLEAR_TABLES = new Object();
    protected static final Object DROP_TABLES = new Object();
    protected TestResult testResult;

    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF(this.getPersistenceUnitName(), props);
    }

    protected String getPersistenceUnitName() {
        return "test";
    }

    protected OpenJPAEntityManagerFactorySPI createNamedEMF(String pu, Object ... props) {
        Map<String, Object> map = this.getPropertiesMap(props);
        OpenJPAEntityManagerFactorySPI oemf = null;
        HashMap<Object, Object> config = new HashMap<Object, Object>(System.getProperties());
        config.putAll(map);
        oemf = (OpenJPAEntityManagerFactorySPI)Persistence.createEntityManagerFactory((String)pu, config);
        if (oemf == null) {
            throw new NullPointerException("Expected an entity manager factory for the persistence unit named: \"" + pu + "\"");
        }
        return oemf;
    }

    protected OpenJPAEntityManagerFactorySPI createNamedOpenJPAEMF(String pu, String res, Map<String, Object> props) {
        OpenJPAEntityManagerFactorySPI oemf = null;
        HashMap<Object, Object> config = new HashMap<Object, Object>(System.getProperties());
        if (props != null) {
            config.putAll(props);
        }
        if ((oemf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)pu, (String)res, props)) == null) {
            throw new NullPointerException("Expected an OpenJPA entity manager factory for the persistence unit named: \"" + pu + "\"");
        }
        return oemf;
    }

    protected Map<String, Object> getPropertiesMap(Object ... props) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("openjpa.DynamicEnhancementAgent", "false");
        ArrayList<Class> types = new ArrayList<Class>();
        boolean prop = false;
        for (int i = 0; props != null && i < props.length; ++i) {
            if (props[i] == FRESH_EMF) {
                this._fresh = true;
                continue;
            }
            if (props[i] == RETAIN_DATA) {
                this.retainDataOnTearDown = true;
                continue;
            }
            if (prop) {
                map.put((String)props[i - 1], props[i]);
                prop = false;
                continue;
            }
            if (props[i] == CLEAR_TABLES) {
                map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add,deleteTableContents')");
                continue;
            }
            if (props[i] == DROP_TABLES) {
                map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
                continue;
            }
            if (props[i] instanceof Class) {
                types.add((Class)props[i]);
                continue;
            }
            if (props[i] instanceof Class[]) {
                for (Class clss : (Class[])props[i]) {
                    types.add(clss);
                }
                continue;
            }
            if (props[i] == null) continue;
            prop = true;
        }
        if (!types.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            for (Class c : types) {
                if (buf.length() > 0) {
                    buf.append(";");
                }
                buf.append(c.getName());
            }
            String oldValue = map.containsKey("openjpa.MetaDataFactory") ? "," + map.get("openjpa.MetaDataFactory").toString() : "";
            map.put("openjpa.MetaDataFactory", "jpa(Types=" + buf.toString() + oldValue + ")");
        } else {
            map.put("openjpa.MetaDataFactory", "jpa");
        }
        return map;
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        super.run(testResult);
    }

    public void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Exception e) {
                if (!this.testResult.wasSuccessful()) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeEMF(EntityManagerFactory emf) {
        boolean brc = false;
        if (emf == null || !emf.isOpen()) {
            return brc;
        }
        try {
            this.closeAllOpenEMs(emf);
        }
        catch (Throwable throwable) {
            emf.close();
            boolean bl = brc = !emf.isOpen();
            if (!brc) {
                System.err.println("AbstractPersistenceTestCase().closeEMF() - EMF is still open.");
            }
            throw throwable;
        }
        emf.close();
        boolean bl = brc = !emf.isOpen();
        if (!brc) {
            System.err.println("AbstractPersistenceTestCase().closeEMF() - EMF is still open.");
        }
        return brc;
    }

    protected boolean closeEM(EntityManager em) {
        boolean brc;
        if (em == null || !em.isOpen()) {
            return false;
        }
        if (em.getTransaction().isActive()) {
            em.getTransaction().rollback();
        }
        em.close();
        boolean bl = brc = !em.isOpen();
        if (!brc) {
            System.err.println("AbstractPersistenceTestCase().closeEM() - EM is still open.");
        }
        return brc;
    }

    protected void closeAllOpenEMs(EntityManagerFactory emf) {
        if (emf == null || !emf.isOpen()) {
            return;
        }
        for (Broker b : ((AbstractBrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf)).getOpenBrokers()) {
            if (b == null || b.isClosed()) continue;
            OpenJPAEntityManager em = JPAFacadeHelper.toEntityManager((Broker)b);
            if (em.getTransaction().isActive()) {
                try {
                    em.getTransaction().rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.closeEM((EntityManager)em);
        }
    }

    protected void clear(EntityManagerFactory emf, Class<?> ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        ArrayList<ClassMetaData> metas = new ArrayList<ClassMetaData>(types.length);
        for (Class<?> c : types) {
            ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, c);
            if (meta == null) continue;
            metas.add(meta);
        }
        this.clear(emf, false, metas.toArray(new ClassMetaData[metas.size()]));
    }

    protected void clear(EntityManagerFactory emf) {
        if (emf == null) {
            return;
        }
        this.clear(emf, true, ((OpenJPAEntityManagerFactorySPI)emf).getConfiguration().getMetaDataRepositoryInstance().getMetaDatas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(EntityManagerFactory emf, boolean closeEMs, ClassMetaData ... types) {
        if (emf == null || types.length == 0) {
            return;
        }
        if (closeEMs) {
            this.closeAllOpenEMs(emf);
        }
        if (this.retainDataOnTearDown) {
            return;
        }
        EntityManager em = emf.createEntityManager();
        try {
            em.getTransaction().begin();
            for (ClassMetaData meta : types) {
                if (!meta.isMapped() || meta.isEmbeddedOnly() || Modifier.isAbstract(meta.getDescribedType().getModifiers()) && !this.isBaseManagedInterface(meta, types)) continue;
                em.createQuery("DELETE FROM " + meta.getTypeAlias() + " o").executeUpdate();
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
        }
        finally {
            this.closeEM(em);
        }
    }

    protected String entityName(EntityManagerFactory emf, Class<?> c) {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)emf, c);
        return meta == null ? null : meta.getTypeAlias();
    }

    private boolean isBaseManagedInterface(ClassMetaData meta, ClassMetaData ... types) {
        return Modifier.isInterface(meta.getDescribedType().getModifiers()) && !this.isExtendedManagedInterface(meta, types);
    }

    private boolean isExtendedManagedInterface(ClassMetaData meta, ClassMetaData ... types) {
        if (!Modifier.isInterface(meta.getDescribedType().getModifiers())) {
            return false;
        }
        Class<?>[] ifaces = meta.getDescribedType().getInterfaces();
        for (int i = 0; ifaces != null && i < ifaces.length; ++i) {
            for (ClassMetaData meta2 : types) {
                if (!ifaces[i].equals(meta2.getDescribedType())) continue;
                return true;
            }
        }
        return false;
    }

    public static void assertNotEquals(Object o1, Object o2) {
        if (o1 == o2) {
            AbstractPersistenceTestCase.fail((String)"expected args to be different; were the same instance.");
        } else {
            if (o1 == null || o2 == null) {
                return;
            }
            if (o1.equals(o2)) {
                AbstractPersistenceTestCase.fail((String)"expected args to be different; compared equal.");
            }
        }
    }

    public static <T> T roundtrip(T o) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        return (T)in.readObject();
    }

    protected void assertException(Throwable actual, Class<?> targetType) {
        this.assertException(actual, targetType, null);
    }

    protected void assertException(Throwable actual, Class<?> targetType, Class<?> nestedTargetType) {
        AbstractPersistenceTestCase.assertNotNull((Object)actual);
        Class<?> actualType = actual.getClass();
        if (targetType != null && !targetType.isAssignableFrom(actualType)) {
            actual.printStackTrace();
            AbstractPersistenceTestCase.fail((String)(targetType.getName() + " is not assignable from " + actualType.getName()));
        }
        if (nestedTargetType != null) {
            Class<?> nestedActualType;
            Throwable nested = actual.getCause();
            Class<?> clazz = nestedActualType = nested == null ? null : nested.getClass();
            while (nestedActualType != null) {
                if (nestedTargetType.isAssignableFrom(nestedActualType)) {
                    return;
                }
                Throwable next = nested.getCause();
                if (next == null || next == nested) break;
                nestedActualType = next.getClass();
                nested = next;
            }
            actual.printStackTrace();
            AbstractPersistenceTestCase.fail((String)("No nested type " + nestedTargetType + " in " + actual));
        }
    }

    protected void assertExceptionMessage(Throwable actual, Class<?> targetType, String ... messages) {
        this.assertException(actual, targetType, null);
        this.assertMessage(actual, messages);
    }

    protected void assertMessage(Throwable actual, String ... keys) {
        if (actual == null || keys == null) {
            return;
        }
        String message = actual.getMessage();
        for (String key : keys) {
            AbstractPersistenceTestCase.assertTrue((String)(key + " is not in " + message), (boolean)message.contains(key));
        }
    }

    public void printException(Throwable t) {
        this.printException(t, 2);
    }

    public void printException(Throwable t, int tab) {
        if (t == null) {
            return;
        }
        for (int i = 0; i < tab * 4; ++i) {
            System.out.print(" ");
        }
        String sqlState = t instanceof SQLException ? "(SQLState=" + ((SQLException)t).getSQLState() + ":" + t.getMessage() + ")" : "";
        System.out.println(t.getClass().getName() + sqlState);
        if (t.getCause() == t) {
            return;
        }
        this.printException(t.getCause(), tab + 2);
    }

    public void runBare() throws Throwable {
        if (!this.isRunsOnCurrentPlatform()) {
            return;
        }
        this.runBare(this.getAllowFailure());
    }

    protected void runBare(AllowFailure allowFailureAnnotation) throws Throwable {
        boolean allowFailureValue;
        boolean bl = allowFailureValue = allowFailureAnnotation == null ? false : allowFailureAnnotation.value();
        if (allowFailureValue) {
            if (ALLOW_FAILURE_IGNORE.equalsIgnoreCase(allowFailureConfig)) {
                return;
            }
            try {
                super.runBare();
            }
            catch (Throwable t) {
                if (ALLOW_FAILURE_LOG.equalsIgnoreCase(allowFailureConfig)) {
                    System.err.println("*** FAILED (but ignored): " + (Object)((Object)this));
                    System.err.println("***              Reason : " + allowFailureAnnotation.message());
                    System.err.println("Stacktrace of failure");
                    t.printStackTrace();
                }
                throw t;
            }
        } else {
            super.runBare();
        }
    }

    protected void runTest() throws Throwable {
        if (this.isTestsDisabled()) {
            return;
        }
        super.runTest();
    }

    protected AllowFailure getAllowFailure() {
        try {
            Method runMethod = ((Object)((Object)this)).getClass().getMethod(this.getName(), null);
            AllowFailure anno = runMethod.getAnnotation(AllowFailure.class);
            if (anno != null) {
                return anno;
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getAnnotation(AllowFailure.class);
    }

    protected boolean isRunsOnCurrentPlatform() {
        DatabasePlatform anno = ((Object)((Object)this)).getClass().getAnnotation(DatabasePlatform.class);
        if (anno == null) {
            return true;
        }
        if (anno != null) {
            String[] drivers;
            String value = anno.value();
            if (value == null || value.trim().length() == 0) {
                return true;
            }
            for (String driver : drivers = value.split("\\,")) {
                try {
                    Class.forName(driver.trim(), false, Thread.currentThread().getContextClassLoader());
                    return true;
                }
                catch (Throwable t) {
                }
            }
        }
        return false;
    }

    public boolean isTargetPlatform(String target) {
        String url = this.getPlatform();
        return url != null && url.indexOf(target) != -1;
    }

    public String getPlatform() {
        return System.getProperty("platform", "derby");
    }

    protected void assertCached(Cache cache, Class<?> clss, Object id, boolean expected) {
        if (expected) {
            AbstractPersistenceTestCase.assertTrue((String)String.format("Expected %s:%s to exist in cache", clss, id), (boolean)cache.contains(clss, id));
        } else {
            AbstractPersistenceTestCase.assertFalse((String)String.format("Expected %s:%s not to exist in cache", clss, id), (boolean)cache.contains(clss, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTestsDisabled(boolean disable) {
        Boolean bl = this.testsDisabled;
        synchronized (bl) {
            this.testsDisabled = new Boolean(disable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTestsDisabled() {
        Boolean bl = this.testsDisabled;
        synchronized (bl) {
            return this.testsDisabled;
        }
    }

    protected Class<?> resolveEntityClass(JPAEntityClassEnum enumerationRef) throws ClassNotFoundException {
        if (enumerationRef == null) {
            throw new IllegalArgumentException("Null value passed into the constructNewEntityObject method.");
        }
        String className = enumerationRef.getEntityClassName();
        if (className == null) {
            throw new IllegalArgumentException("Enumeration toString() method implementation returned a null value.");
        }
        return Class.forName(className);
    }

    protected Object constructNewEntityObject(JPAEntityClassEnum enumerationRef) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> classType = this.resolveEntityClass(enumerationRef);
        Class[] constructorArgSig = new Class[]{};
        Object[] constructorArgs = new Object[]{};
        Constructor<?> classConstructor = classType.getConstructor(constructorArgSig);
        Object newEntity = classConstructor.newInstance(constructorArgs);
        return newEntity;
    }

    protected Object constructNewEntityObject(Class<?> entityClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] constructorArgSig = new Class[]{};
        Object[] constructorArgs = new Object[]{};
        Constructor<?> classConstructor = entityClass.getConstructor(constructorArgSig);
        Object newEntity = classConstructor.newInstance(constructorArgs);
        return newEntity;
    }
}

