/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbeddedIdClass;
import org.apache.openjpa.persistence.annotations.common.apps.annotApp.annotype.EmbeddedIdEntity;
import org.apache.openjpa.persistence.derivedid.EBigDecimalID;
import org.apache.openjpa.persistence.derivedid.EBigIntegerID;
import org.apache.openjpa.persistence.derivedid.EDBigDecimalID;
import org.apache.openjpa.persistence.derivedid.EDBigIntegerID;
import org.apache.openjpa.persistence.derivedid.EDDateID;
import org.apache.openjpa.persistence.derivedid.EDSQLDateID;
import org.apache.openjpa.persistence.derivedid.EDateID;
import org.apache.openjpa.persistence.derivedid.ESQLDateID;
import org.apache.openjpa.persistence.enhance.identity.Book;
import org.apache.openjpa.persistence.enhance.identity.BookId;
import org.apache.openjpa.persistence.enhance.identity.Library;
import org.apache.openjpa.persistence.enhance.identity.MedicalHistory4;
import org.apache.openjpa.persistence.enhance.identity.Page;
import org.apache.openjpa.persistence.enhance.identity.Person4;
import org.apache.openjpa.persistence.enhance.identity.PersonId4;
import org.apache.openjpa.persistence.identity.BooleanIdEntity;
import org.apache.openjpa.persistence.identity.DoubleObjIdEntity;
import org.apache.openjpa.persistence.identity.FloatIdEntity;
import org.apache.openjpa.persistence.identity.SQLBigDecimalIdEntity;
import org.apache.openjpa.persistence.identity.SQLBigIntegerIdEntity;
import org.apache.openjpa.persistence.identity.SQLDateIdEntity;
import org.apache.openjpa.persistence.identity.StringIdEntity;
import org.apache.openjpa.persistence.identity.entityasidentity.Person;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.CompositeId;
import org.apache.openjpa.persistence.jdbc.common.apps.mappingApp.EntityWithCompositeId;
import org.apache.openjpa.persistence.relations.BasicEntity;
import org.apache.openjpa.persistence.simple.AllFieldTypes;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.UserException;

public class TestJPAFacadeHelper
extends SingleEMFTestCase {
    MetaDataRepository repo = null;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, EmbeddedIdEntity.class, EmbeddedIdClass.class, EBigDecimalID.class, EDBigDecimalID.class, EBigIntegerID.class, EDBigIntegerID.class, EDateID.class, EDDateID.class, ESQLDateID.class, EDSQLDateID.class, EntityWithCompositeId.class, AllFieldTypes.class, BasicEntity.class, Book.class, Library.class, Page.class, Person.class, DoubleObjIdEntity.class, FloatIdEntity.class, BooleanIdEntity.class, StringIdEntity.class, SQLBigIntegerIdEntity.class, SQLDateIdEntity.class, SQLBigDecimalIdEntity.class, MedicalHistory4.class, Person4.class, PersonId4.class);
        this.repo = this.emf.getConfiguration().getMetaDataRepositoryInstance();
    }

    public void testEmbeddedId() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(EmbeddedIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new EmbeddedIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        EmbeddedIdClass id = new EmbeddedIdClass();
        id.setPk1(1L);
        id.setPk2(2L);
        EmbeddedIdEntity entity = new EmbeddedIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        EmbeddedIdEntity persistedEntity = (EmbeddedIdEntity)em.find(EmbeddedIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testCompositeId() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(EntityWithCompositeId.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new EntityWithCompositeId());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        int intId = 1;
        String nameId = "CompositeEntity";
        EntityWithCompositeId entity = new EntityWithCompositeId();
        entity.setId(intId);
        entity.setName(nameId);
        CompositeId id = new CompositeId(intId, nameId);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        EntityWithCompositeId persistedEntity = (EntityWithCompositeId)em.find(EntityWithCompositeId.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testBasic() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(BasicEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new BasicEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)"a");
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        BasicEntity entity = new BasicEntity();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        BasicEntity persistedEntity = (BasicEntity)em.find(BasicEntity.class, (Object)entity.getId());
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)entity.getId()));
        Object o = JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)entity.getId());
        TestJPAFacadeHelper.assertEquals((Object)o, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)o));
    }

    public void testIntegerId() {
        ClassMetaData cmd = this.repo.getMetaData(Person.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new Person());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        Integer id = 1;
        Person entity = new Person();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        Person persistedEntity = (Person)em.find(Person.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testDoubleId() {
        ClassMetaData cmd = this.repo.getMetaData(DoubleObjIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new DoubleObjIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        Double id = 1.0;
        DoubleObjIdEntity entity = new DoubleObjIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        DoubleObjIdEntity persistedEntity = (DoubleObjIdEntity)em.find(DoubleObjIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testFloatId() {
        ClassMetaData cmd = this.repo.getMetaData(FloatIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new FloatIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        Float id = Float.valueOf(1.0f);
        FloatIdEntity entity = new FloatIdEntity();
        entity.setId(id.floatValue());
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        FloatIdEntity persistedEntity = (FloatIdEntity)em.find(FloatIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testBooleanId() {
        ClassMetaData cmd = this.repo.getMetaData(BooleanIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new BooleanIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        Boolean id = true;
        BooleanIdEntity entity = new BooleanIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        BooleanIdEntity persistedEntity = (BooleanIdEntity)em.find(BooleanIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testStringId() {
        ClassMetaData cmd = this.repo.getMetaData(StringIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new StringIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        String id = "StringId";
        StringIdEntity entity = new StringIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        StringIdEntity persistedEntity = (StringIdEntity)em.find(StringIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testBigIntegerId() {
        ClassMetaData cmd = this.repo.getMetaData(SQLBigIntegerIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new SQLBigIntegerIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        BigInteger id = BigInteger.valueOf(1L);
        SQLBigIntegerIdEntity entity = new SQLBigIntegerIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        SQLBigIntegerIdEntity persistedEntity = (SQLBigIntegerIdEntity)em.find(SQLBigIntegerIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testBigDecimalId() {
        ClassMetaData cmd = this.repo.getMetaData(SQLBigDecimalIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new SQLBigDecimalIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        BigDecimal id = BigDecimal.valueOf(1L);
        SQLBigDecimalIdEntity entity = new SQLBigDecimalIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        SQLBigDecimalIdEntity persistedEntity = (SQLBigDecimalIdEntity)em.find(SQLBigDecimalIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testDateId() {
        ClassMetaData cmd = this.repo.getMetaData(SQLDateIdEntity.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new SQLDateIdEntity());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        long time = System.currentTimeMillis() / 1000L * 1000L;
        Date id = new Date(time);
        SQLDateIdEntity entity = new SQLDateIdEntity();
        entity.setId(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        SQLDateIdEntity persistedEntity = (SQLDateIdEntity)em.find(SQLDateIdEntity.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testDerivedId() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(EDSQLDateID.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new EDSQLDateID());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        Date d = new Date(2014, 3, 26);
        ESQLDateID id = new ESQLDateID(d);
        EDSQLDateID entity = new EDSQLDateID(id);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)id);
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        EDSQLDateID persistedEntity = (EDSQLDateID)em.find(EDSQLDateID.class, (Object)d);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)d));
    }

    public void testCompositeDerivedId() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(Book.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new Book());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        String bookName = "Harry Potter";
        String libName = "Library Name";
        Library entity = new Library();
        entity.setName(libName);
        Book book = new Book();
        book.setName(bookName);
        entity.addBook(book);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        BookId id = new BookId();
        id.setName(bookName);
        id.setLibrary(libName);
        Book persistedEntity = (Book)em.find(Book.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testCompositeDerivedEmbeddedId() {
        ClassMetaData cmd = this.repo.getMetaData(MedicalHistory4.class, null, true);
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)new MedicalHistory4());
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        PersonId4 id = new PersonId4("First", "Last");
        Person4 person = new Person4();
        person.setId(id);
        MedicalHistory4 entity = new MedicalHistory4();
        entity.setPatient(person);
        entity.setName("MedicalHistory");
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)person);
        em.persist((Object)entity);
        em.getTransaction().commit();
        em.clear();
        MedicalHistory4 persistedEntity = (MedicalHistory4)em.find(MedicalHistory4.class, (Object)id);
        StateManagerImpl smi = (StateManagerImpl)((PersistenceCapable)persistedEntity).pcGetStateManager();
        Object oid = smi.getObjectId();
        TestJPAFacadeHelper.assertEquals((Object)oid, (Object)JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)id));
    }

    public void testNoId() throws Exception {
        ClassMetaData cmd = this.repo.getMetaData(AllFieldTypes.class, null, true);
        try {
            ArrayList<AllFieldTypes> ids = new ArrayList<AllFieldTypes>();
            ids.add(new AllFieldTypes());
            JPAFacadeHelper.toOpenJPAObjectIds((ClassMetaData)cmd, ids);
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        try {
            JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)"a");
            TestJPAFacadeHelper.fail((String)"Didn't fail!");
        }
        catch (UserException re) {
            // empty catch block
        }
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        AllFieldTypes type = new AllFieldTypes();
        em.persist((Object)type);
        em.getTransaction().commit();
        Object oid = em.getObjectId((Object)type);
        TestJPAFacadeHelper.assertEquals(Id.class, JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)cmd, (Object)oid).getClass());
    }
}

