/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.util.EagerEmbed;
import org.apache.openjpa.persistence.util.EagerEmbedRel;
import org.apache.openjpa.persistence.util.EagerEntity;
import org.apache.openjpa.persistence.util.LazyEmbed;
import org.apache.openjpa.persistence.util.LazyEntity;
import org.apache.openjpa.persistence.util.MapEntity;
import org.apache.openjpa.persistence.util.MapKeyEmbed;
import org.apache.openjpa.persistence.util.MapValEntity;
import org.apache.openjpa.persistence.util.OneToEntity;
import org.apache.openjpa.persistence.util.RelEntity;
import org.apache.openjpa.persistence.util.ToManyEager;
import org.apache.openjpa.persistence.util.ToManyLazy;

public class TestPersistenceUnitUtil
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, EagerEntity.class, LazyEmbed.class, LazyEntity.class, EagerEmbed.class, RelEntity.class, EagerEmbedRel.class, MapEntity.class, MapKeyEmbed.class, MapValEntity.class, OneToEntity.class, ToManyLazy.class, ToManyEager.class);
    }

    public void testIsLoadedEager() {
        this.verifyIsLoadedEagerState(true);
    }

    public void testNotLoadedLazy() {
        this.verifyIsLoadedEagerState(false);
    }

    public void testIsLoadedLazy() {
        this.verifyIsLoadedLazyState(true);
    }

    public void testNotLoadedEager() {
        this.verifyIsLoadedEagerState(false);
    }

    public void testMultiplePUs() {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"PUtil1", (String)"org/apache/openjpa/persistence/util/persistence.xml");
        TestPersistenceUnitUtil.assertNotNull((Object)emf1);
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"PUtil2", (String)"org/apache/openjpa/persistence/util/persistence.xml");
        TestPersistenceUnitUtil.assertNotNull((Object)emf2);
        TestPersistenceUnitUtil.assertNotSame((Object)this.emf, (Object)emf1);
        TestPersistenceUnitUtil.assertNotSame((Object)emf1, (Object)emf2);
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        PersistenceUnitUtil puu1 = emf1.getPersistenceUnitUtil();
        PersistenceUnitUtil puu2 = emf2.getPersistenceUnitUtil();
        TestPersistenceUnitUtil.assertNotSame((Object)puu, (Object)puu1);
        TestPersistenceUnitUtil.assertNotSame((Object)puu, (Object)puu2);
        TestPersistenceUnitUtil.assertNotSame((Object)puu1, (Object)puu2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OpenJPAEntityManagerSPI em1 = emf1.createEntityManager();
        OpenJPAEntityManagerSPI em2 = emf2.createEntityManager();
        this.verifyPULoadState((EntityManager)em, puu, puu1, puu2);
        this.verifyPULoadState((EntityManager)em1, puu1, puu, puu2);
        this.verifyPULoadState((EntityManager)em2, puu2, puu, puu1);
        em.close();
        em1.close();
        em2.close();
        if (emf1 != null) {
            emf1.close();
        }
        if (emf2 != null) {
            emf2.close();
        }
    }

    private void verifyPULoadState(EntityManager em, PersistenceUnitUtil ... puu) {
        EagerEntity ee = this.createEagerEntity();
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[0].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[0].isLoaded((Object)ee, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[1].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[1].isLoaded((Object)ee, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[2].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[2].isLoaded((Object)ee, "id"));
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu[0].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu[0].isLoaded((Object)ee, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[1].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[1].isLoaded((Object)ee, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[2].isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu[2].isLoaded((Object)ee, "id"));
    }

    private void verifyIsLoadedEagerState(boolean loaded) {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        TestPersistenceUnitUtil.assertSame((Object)this.emf, (Object)puu);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)ee, "id"));
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = loaded ? (EagerEntity)em.find(EagerEntity.class, (Object)ee.getId()) : (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)ee));
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)ee, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)ee, "name"));
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)ee, "eagerEmbed"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)ee, "transField"));
        em.close();
    }

    private void verifyIsLoadedLazyState(boolean loaded) {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        TestPersistenceUnitUtil.assertSame((Object)this.emf, (Object)puu);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LazyEntity le = this.createLazyEntity();
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)le));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)le, "id"));
        em.getTransaction().begin();
        em.persist((Object)le);
        em.getTransaction().commit();
        em.clear();
        le = loaded ? (LazyEntity)em.find(LazyEntity.class, (Object)le.getId()) : (LazyEntity)em.getReference(LazyEntity.class, (Object)le.getId());
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)le));
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)le, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)le, "name"));
        TestPersistenceUnitUtil.assertEquals((boolean)loaded, (boolean)puu.isLoaded((Object)le, "lazyEmbed"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)le, "transField"));
        em.close();
    }

    public void testIsApplicationLoaded() {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        TestPersistenceUnitUtil.assertSame((Object)this.emf, (Object)puu);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestPersistenceUnitUtil.assertNotNull((Object)ee);
        this.assertEagerLoadState(puu, ee, false);
        ee.setName("AppEagerName");
        EagerEmbed emb = this.createEagerEmbed();
        ee.setEagerEmbed(emb);
        this.assertEagerLoadState(puu, ee, true);
        TestPersistenceUnitUtil.assertEquals((String)"AppEagerName", (String)ee.getName());
        TestPersistenceUnitUtil.assertEquals((Object)emb, (Object)ee.getEagerEmbed());
        em.close();
    }

    public void testPCMapEager() {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        MapValEntity mve = new MapValEntity();
        mve.setIntVal(10);
        MapKeyEmbed mke = new MapKeyEmbed();
        mke.setFirstName("Jane");
        mke.setLastName("Doe");
        MapEntity me = new MapEntity();
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)me));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)me, "mapValEntity"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)me, "mapEntities"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)puu.isLoaded((Object)mve));
        me.setMapValEntity(mve);
        mve.setMapEntity(me);
        HashMap<MapKeyEmbed, MapValEntity> hm = new HashMap<MapKeyEmbed, MapValEntity>();
        hm.put(mke, mve);
        me.setMapEntities(hm);
        em.getTransaction().begin();
        em.persist((Object)me);
        em.getTransaction().commit();
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu.isLoaded((Object)me));
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu.isLoaded((Object)me, "mapValEntity"));
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu.isLoaded((Object)me, "mapEntities"));
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu.isLoaded((Object)mve));
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNullLazyRelationship() {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            OneToEntity ote = new OneToEntity();
            TestPersistenceUnitUtil.assertFalse((boolean)puu.isLoaded((Object)ote, "toManyLazy"));
            em.getTransaction().begin();
            em.persist((Object)ote);
            em.getTransaction().commit();
            em.clear();
            ote = (OneToEntity)em.find(OneToEntity.class, (Object)ote.getId());
            TestPersistenceUnitUtil.assertFalse((boolean)puu.isLoaded((Object)ote, "toManyLazy"));
            ote.getToManyLazy();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote, "toManyLazy"));
            OneToEntity ote2 = new OneToEntity();
            em.getTransaction().begin();
            em.persist((Object)ote2);
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
            em.clear();
            ote2 = (OneToEntity)em.find(OneToEntity.class, (Object)ote2.getId());
            TestPersistenceUnitUtil.assertFalse((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
            ArrayList<ToManyLazy> tmes = new ArrayList<ToManyLazy>();
            for (int i = 0; i < 5; ++i) {
                tmes.add(new ToManyLazy("ToMany" + i));
            }
            em.getTransaction().begin();
            ote2.setToManyLazy(tmes);
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
            em.getTransaction().begin();
            ote2.setToManyLazy(null);
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyLazy"));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNullEagerRelationship() {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            OneToEntity ote = new OneToEntity();
            TestPersistenceUnitUtil.assertFalse((boolean)puu.isLoaded((Object)ote, "toManyEager"));
            em.getTransaction().begin();
            em.persist((Object)ote);
            em.getTransaction().commit();
            em.clear();
            ote = (OneToEntity)em.find(OneToEntity.class, (Object)ote.getId());
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote, "toManyEager"));
            OneToEntity ote2 = new OneToEntity();
            em.getTransaction().begin();
            em.persist((Object)ote2);
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            em.clear();
            ote2 = (OneToEntity)em.find(OneToEntity.class, (Object)ote2.getId());
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            ArrayList<ToManyEager> tmes = new ArrayList<ToManyEager>();
            for (int i = 0; i < 5; ++i) {
                tmes.add(new ToManyEager("ToMany" + i));
            }
            em.getTransaction().begin();
            ote2.setToManyEager(tmes);
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            em.getTransaction().begin();
            ote2.setToManyEager(null);
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2));
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
            em.getTransaction().commit();
            TestPersistenceUnitUtil.assertTrue((boolean)puu.isLoaded((Object)ote2, "toManyEager"));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    public void testBasicTypeNotLoaded() {
        PersistenceUnitUtil puu = this.emf.getPersistenceUnitUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity();
        int id = ee.getId();
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        OpenJPAEntityManager kem = OpenJPAPersistence.cast((EntityManager)em);
        kem.getFetchPlan().resetFetchGroups().removeFetchGroup("default").addField(EagerEntity.class, "eagerEmbed");
        ee = (EagerEntity)em.find(EagerEntity.class, (Object)id);
        TestPersistenceUnitUtil.assertEquals((boolean)true, (boolean)puu.isLoaded((Object)ee));
    }

    private EagerEntity createEagerEntity() {
        EagerEntity ee = new EagerEntity();
        ee.setId(new Random().nextInt());
        ee.setName("EagerEntity");
        EagerEmbed emb = this.createEagerEmbed();
        ee.setEagerEmbed(emb);
        return ee;
    }

    private EagerEmbed createEagerEmbed() {
        EagerEmbed emb = new EagerEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        return emb;
    }

    private LazyEntity createLazyEntity() {
        LazyEntity le = new LazyEntity();
        le.setId(new Random().nextInt());
        le.setName("LazyEntity");
        LazyEmbed emb = new LazyEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        le.setLazyEmbed(emb);
        RelEntity re = new RelEntity();
        re.setName("My ent");
        ArrayList<RelEntity> rel = new ArrayList<RelEntity>();
        rel.add(new RelEntity());
        return le;
    }

    private void assertEagerLoadState(PersistenceUnitUtil pu, Object ent, boolean state) {
        TestPersistenceUnitUtil.assertEquals((boolean)state, (boolean)pu.isLoaded(ent));
        TestPersistenceUnitUtil.assertEquals((boolean)state, (boolean)pu.isLoaded(ent, "id"));
        TestPersistenceUnitUtil.assertEquals((boolean)state, (boolean)pu.isLoaded(ent, "name"));
        TestPersistenceUnitUtil.assertEquals((boolean)state, (boolean)pu.isLoaded(ent, "eagerEmbed"));
        TestPersistenceUnitUtil.assertEquals((boolean)false, (boolean)pu.isLoaded(ent, "transField"));
    }
}

