/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.ProviderUtil;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.util.EagerEmbed;
import org.apache.openjpa.persistence.util.EagerEmbedRel;
import org.apache.openjpa.persistence.util.EagerEntity;
import org.apache.openjpa.persistence.util.LazyEmbed;
import org.apache.openjpa.persistence.util.LazyEntity;
import org.apache.openjpa.persistence.util.RelEntity;

public class TestProviderUtil
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, EagerEntity.class, LazyEmbed.class, LazyEntity.class, EagerEmbed.class, EagerEmbedRel.class, RelEntity.class);
    }

    public void testIsLoadedEager() {
        this.verifyIsLoadedEagerState(LoadState.LOADED);
    }

    public void testNotLoadedLazy() {
        this.verifyIsLoadedEagerState(LoadState.NOT_LOADED);
    }

    public void testIsLoadedLazy() {
        this.verifyIsLoadedLazyState(LoadState.LOADED);
    }

    public void testNotLoadedEager() {
        this.verifyIsLoadedEagerState(LoadState.NOT_LOADED);
    }

    private void verifyIsLoadedEagerState(LoadState state) {
        ProviderUtil pu = this.getProviderUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity(true);
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoaded((Object)ee));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference((Object)ee, "id"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference((Object)ee, "id"));
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = state == LoadState.LOADED ? (EagerEntity)em.find(EagerEntity.class, (Object)ee.getId()) : (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoaded((Object)ee));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)ee, "id"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)ee, "id"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)ee, "name"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)ee, "name"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)ee, "eagerEmbed"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)ee, "eagerEmbed"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)ee, "eagerEmbedColl"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)ee, "eagerEmbedColl"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference((Object)ee, "transField"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference((Object)ee, "transField"));
        em.close();
    }

    private void verifyIsLoadedLazyState(LoadState state) {
        ProviderUtil pu = this.getProviderUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        LazyEntity le = this.createLazyEntity();
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoaded((Object)le));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference((Object)le, "id"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference((Object)le, "id"));
        em.getTransaction().begin();
        em.persist((Object)le);
        em.getTransaction().commit();
        em.clear();
        le = state == LoadState.LOADED ? (LazyEntity)em.find(LazyEntity.class, (Object)le.getId()) : (LazyEntity)em.getReference(LazyEntity.class, (Object)le.getId());
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoaded((Object)le));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)le, "id"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)le, "id"));
        TestProviderUtil.assertEquals((Object)LoadState.NOT_LOADED, (Object)pu.isLoadedWithReference((Object)le, "name"));
        TestProviderUtil.assertEquals((Object)LoadState.NOT_LOADED, (Object)pu.isLoadedWithoutReference((Object)le, "name"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference((Object)le, "lazyEmbed"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference((Object)le, "lazyEmbed"));
        TestProviderUtil.assertEquals((Object)LoadState.NOT_LOADED, (Object)pu.isLoadedWithReference((Object)le, "lazyEmbedColl"));
        TestProviderUtil.assertEquals((Object)LoadState.NOT_LOADED, (Object)pu.isLoadedWithoutReference((Object)le, "lazyEmbedColl"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference((Object)le, "transField"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference((Object)le, "transField"));
        em.close();
    }

    public void testIsApplicationLoaded() {
        ProviderUtil pu = this.getProviderUtil();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EagerEntity ee = this.createEagerEntity(true);
        em.getTransaction().begin();
        em.persist((Object)ee);
        em.getTransaction().commit();
        em.clear();
        ee = (EagerEntity)em.getReference(EagerEntity.class, (Object)ee.getId());
        TestProviderUtil.assertNotNull((Object)ee);
        this.assertEagerLoadState(pu, ee, LoadState.NOT_LOADED);
        ee.setName("AppEagerName");
        EagerEmbed emb = this.createEagerEmbed();
        ee.setEagerEmbed(emb);
        this.assertEagerLoadState(pu, ee, LoadState.LOADED);
        TestProviderUtil.assertEquals((String)"AppEagerName", (String)ee.getName());
        TestProviderUtil.assertEquals((Object)emb, (Object)ee.getEagerEmbed());
        em.close();
    }

    public void testIsLoadedUnknown() {
        ProviderUtil pu = this.getProviderUtil();
        EagerEntity ee = new EagerEntity();
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoaded((Object)ee));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference((Object)ee, "id"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference((Object)ee, "id"));
    }

    private EagerEntity createEagerEntity(boolean createRels) {
        EagerEntity ee = new EagerEntity();
        ee.setId(new Random().nextInt());
        ee.setName("EagerEntity");
        EagerEmbed emb = this.createEagerEmbed();
        List<EagerEmbed> embcoll = this.createEagerEmbedColl();
        ee.setEagerEmbed(emb);
        ee.setEagerEmbedColl(embcoll);
        if (createRels) {
            EagerEmbedRel eer = this.createEagerEmbedRel(createRels);
            ee.setEagerEmbedRel(eer);
        }
        ee.setEagerEmbedRel(null);
        return ee;
    }

    private List<EagerEmbed> createEagerEmbedColl() {
        ArrayList<EagerEmbed> al = new ArrayList<EagerEmbed>();
        for (int i = 0; i < 5; ++i) {
            al.add(this.createEagerEmbed());
        }
        return al;
    }

    private EagerEmbed createEagerEmbed() {
        EagerEmbed emb = new EagerEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        return emb;
    }

    private EagerEmbedRel createEagerEmbedRel(boolean createRels) {
        EagerEmbedRel emb = new EagerEmbedRel();
        HashSet<EagerEntity> ee = new HashSet<EagerEntity>();
        if (createRels) {
            ee.add(this.createEagerEntity(false));
            ee.add(this.createEagerEntity(false));
            ee.add(this.createEagerEntity(false));
        }
        HashSet<Integer> ints = new HashSet<Integer>();
        for (int i = 0; i < 12; ++i) {
            ints.add(new Integer(i));
        }
        emb.setIntVals(ints);
        emb.setEagerEnts(ee);
        return emb;
    }

    private LazyEntity createLazyEntity() {
        LazyEntity le = new LazyEntity();
        le.setId(new Random().nextInt());
        le.setName("LazyEntity");
        LazyEmbed emb = this.createLazyEmbed();
        le.setLazyEmbed(emb);
        le.setLazyEmbedColl(this.createLazyEmbedColl());
        return le;
    }

    private LazyEmbed createLazyEmbed() {
        LazyEmbed emb = new LazyEmbed();
        emb.setEndDate(new Date(System.currentTimeMillis()));
        emb.setStartDate(new Date(System.currentTimeMillis()));
        return emb;
    }

    private List<LazyEmbed> createLazyEmbedColl() {
        ArrayList<LazyEmbed> al = new ArrayList<LazyEmbed>();
        for (int i = 0; i < 5; ++i) {
            al.add(this.createLazyEmbed());
        }
        return al;
    }

    private void assertEagerLoadState(ProviderUtil pu, Object ent, LoadState state) {
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoaded(ent));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference(ent, "id"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference(ent, "id"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference(ent, "name"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference(ent, "name"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference(ent, "eagerEmbed"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference(ent, "eagerEmbed"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithReference(ent, "eagerEmbedRel"));
        TestProviderUtil.assertEquals((Object)state, (Object)pu.isLoadedWithoutReference(ent, "eagerEmbedRel"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithReference(ent, "transField"));
        TestProviderUtil.assertEquals((Object)LoadState.UNKNOWN, (Object)pu.isLoadedWithoutReference(ent, "transField"));
    }

    private ProviderUtil getProviderUtil() {
        PersistenceProviderImpl pp = new PersistenceProviderImpl();
        ProviderUtil pu = pp.getProviderUtil();
        return pu;
    }
}

