/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.validation;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.ValidationMode;
import junit.framework.Assert;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.PersistListener;
import org.apache.openjpa.event.StoreListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.query.SimpleEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestValidationMode
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, SimpleEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode1() {
        this.getLog().trace((Object)"testValidationMode1() - Default mode is AUTO");
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple", (String)"org/apache/openjpa/persistence/validation/persistence.xml");
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Default validation mode", (String)String.valueOf(ValidationMode.AUTO), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode2() {
        this.getLog().trace((Object)"testValidationMode1() - AUTO in persistence.xml");
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple-auto-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml");
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.AUTO), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode3() {
        this.getLog().trace((Object)"testValidationMode3() - persistence.xml overrides Default");
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple-none-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml");
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.NONE), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode4() {
        this.getLog().trace((Object)"testValidationMode4() - persistence.xml overrides Default");
        OpenJPAEntityManagerFactorySPI emf = null;
        try {
            emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple-callback-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml");
            TestValidationMode.assertNotNull((Object)emf);
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.CALLBACK), (String)conf.getValidationMode());
        }
        catch (PersistenceException e) {
            this.getLog().trace((Object)"testValidationMode4() - caught expected exception", (Throwable)e);
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode5() {
        this.getLog().trace((Object)"testValidationMode5() - Map(NONE) overrides default");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.validation.mode", String.valueOf(ValidationMode.NONE));
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.NONE), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode6() {
        this.getLog().trace((Object)"testValidationMode6() - Map(NONE) overrides PU provided mode=callback");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.validation.mode", String.valueOf(ValidationMode.NONE));
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple-callback-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.NONE), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidationMode7() {
        this.getLog().trace((Object)"testValidationMode7() - Map(ValidationMode.NONE) overrides PU provided mode=callback");
        HashMap<String, ValidationMode> props = new HashMap<String, ValidationMode>();
        props.put("javax.persistence.validation.mode", ValidationMode.NONE);
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple-callback-mode", (String)"org/apache/openjpa/persistence/validation/persistence.xml", props);
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAConfiguration conf = emf.getConfiguration();
            TestValidationMode.assertNotNull((Object)conf);
            TestValidationMode.assertEquals((String)"Validation mode", (String)String.valueOf(ValidationMode.NONE), (String)conf.getValidationMode());
        }
        finally {
            this.cleanup(emf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUniqueLifecycleManager() {
        this.getLog().trace((Object)"testUniqueLifecycleManager() - Life cycle event tests");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"simple", (String)"org/apache/openjpa/persistence/validation/persistence.xml", prop);
        TestValidationMode.assertNotNull((Object)emf);
        try {
            OpenJPAEntityManagerSPI em = emf.createEntityManager();
            OpenJPAEntityManagerSPI em2 = emf.createEntityManager();
            UniqueLifecycleListener l1 = new UniqueLifecycleListener();
            UniqueLifecycleListener l2 = new UniqueLifecycleListener();
            em.addLifecycleListener((Object)l1, (Class[])null);
            em2.addLifecycleListener((Object)l2, (Class[])null);
            l1.assertCounts(0, 0, 0, 0);
            l2.assertCounts(0, 0, 0, 0);
            em.getTransaction().begin();
            SimpleEntity e1 = new SimpleEntity();
            em.persist((Object)e1);
            l1.assertCounts(1, 1, 0, 0);
            l2.assertCounts(0, 0, 0, 0);
            em2.getTransaction().begin();
            SimpleEntity e2 = new SimpleEntity();
            em2.persist((Object)e2);
            l1.assertCounts(1, 1, 0, 0);
            l2.assertCounts(1, 1, 0, 0);
            em2.getTransaction().commit();
            l1.assertCounts(1, 1, 0, 0);
            l2.assertCounts(1, 1, 1, 1);
            em.getTransaction().commit();
            l1.assertCounts(1, 1, 1, 1);
            l2.assertCounts(1, 1, 1, 1);
        }
        finally {
            this.cleanup(emf);
        }
    }

    private void cleanup(OpenJPAEntityManagerFactorySPI emf) {
        this.clear((EntityManagerFactory)emf);
        this.closeEMF((EntityManagerFactory)emf);
    }

    class UniqueLifecycleListener
    implements PersistListener,
    StoreListener {
        public int beforePersistCount;
        public int afterPersistCount;
        public int beforeStoreCount;
        public int afterStoreCount;

        UniqueLifecycleListener() {
        }

        public void beforePersist(LifecycleEvent event) {
            ++this.beforePersistCount;
        }

        public void afterPersist(LifecycleEvent event) {
            ++this.afterPersistCount;
        }

        public void beforeStore(LifecycleEvent event) {
            ++this.beforeStoreCount;
        }

        public void afterStore(LifecycleEvent event) {
            ++this.afterStoreCount;
        }

        public void assertCounts(int beforePersist, int afterPersist, int beforeStore, int afterStore) {
            Assert.assertEquals((int)beforePersist, (int)this.beforePersistCount);
            Assert.assertEquals((int)afterPersist, (int)this.afterPersistCount);
            Assert.assertEquals((int)beforeStore, (int)this.beforeStoreCount);
            Assert.assertEquals((int)afterStore, (int)this.afterStoreCount);
        }
    }
}

