/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xml;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;
import org.apache.openjpa.persistence.xml.XmlOverrideToOneEntity;

public class TestToOneLazyXmlOverride
extends SQLListenerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp(CLEAR_TABLES, XmlOverrideToOneEntity.class);
    }

    @Override
    protected String getPersistenceUnitName() {
        return "to-one-xml-override";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToManyLazyOverride() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            XmlOverrideToOneEntity x = new XmlOverrideToOneEntity();
            x.setOtherM2O(x);
            x.setOtherO2O(x);
            em.persist((Object)x);
            em.getTransaction().commit();
            em.clear();
            this.resetSQL();
            em.find(XmlOverrideToOneEntity.class, (Object)x.getId());
            TestToOneLazyXmlOverride.assertTrue((this.sql.size() == 1 ? 1 : 0) != 0);
            String lastSql = (String)this.sql.get(0);
            TestToOneLazyXmlOverride.assertFalse((String)("Shouldn't have found any instances of join or JOIN in last sql, but did. Last SQL = " + lastSql), (lastSql.contains("join") || lastSql.contains("JOIN") ? 1 : 0) != 0);
            TestToOneLazyXmlOverride.assertTrue((boolean)lastSql.contains("o2o"));
            TestToOneLazyXmlOverride.assertTrue((boolean)lastSql.contains("m2o"));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

