/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.xml;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.attrOverrides.AnnoOverEmbed;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;
import org.apache.openjpa.persistence.xml.XmlOverrideEntity;

public class TestXmlOverrideEntity
extends SingleEMFTestCase {
    @Override
    public void setUp() throws ClassNotFoundException {
        this.setUp(AnnoOverEmbed.class, CLEAR_TABLES);
        Class.forName(XmlOverrideEntity.class.getName(), true, XmlOverrideEntity.class.getClassLoader());
    }

    @Override
    protected String getPersistenceUnitName() {
        return "xml-persistence-unit";
    }

    public void testOverrideHappenedDuringEnhancement() throws ClassNotFoundException {
        TestXmlOverrideEntity.assertTrue((boolean)PersistenceCapable.class.isAssignableFrom(XmlOverrideEntity.class));
        TestXmlOverrideEntity.assertEquals((String)"XmlOverride", (String)PCRegistry.getTypeAlias(XmlOverrideEntity.class));
    }

    public void testOverriddenEntityName() {
        this.emf.createEntityManager().close();
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.emf, XmlOverrideEntity.class);
        TestXmlOverrideEntity.assertEquals((String)"XmlOverride", (String)meta.getTypeAlias());
        MetaDataRepository repo = this.emf.getConfiguration().getMetaDataRepositoryInstance();
        TestXmlOverrideEntity.assertEquals((Object)meta, (Object)repo.getMetaData("XmlOverride", XmlOverrideEntity.class.getClassLoader(), true));
    }

    public void testOptionalAttributeOverride() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        XmlOverrideEntity optional = new XmlOverrideEntity();
        optional.setName(null);
        optional.setDescription("description");
        em.getTransaction().begin();
        em.persist((Object)optional);
        em.getTransaction().commit();
        try {
            em.getTransaction().begin();
            optional.setDescription(null);
            em.getTransaction().commit();
            TestXmlOverrideEntity.fail((String)"XmlOrverrideEntity.description should not be optional. Expecting an InvalidStateException.");
        }
        catch (InvalidStateException invalidStateException) {
            // empty catch block
        }
        em.getTransaction().begin();
        em.remove(em.find(XmlOverrideEntity.class, (Object)optional.getId()));
        em.getTransaction().commit();
        em.close();
    }

    public void testColumnOverride() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        ClassMapping mapping = this.getMapping("XmlOverride");
        FieldMapping fm = mapping.getFieldMapping("picture");
        Column[] columns = fm.getColumns();
        TestXmlOverrideEntity.assertEquals((int)1, (int)columns.length);
        TestXmlOverrideEntity.assertEquals((String)"pic_xml", (String)columns[0].getName());
        em.close();
    }
}

