/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FieldResult;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldMappingInfo;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataParser;
import org.apache.openjpa.persistence.jdbc.ClassCriteria;
import org.apache.openjpa.persistence.jdbc.Columns;
import org.apache.openjpa.persistence.jdbc.ContainerTable;
import org.apache.openjpa.persistence.jdbc.DataStoreIdColumn;
import org.apache.openjpa.persistence.jdbc.DiscriminatorStrategy;
import org.apache.openjpa.persistence.jdbc.EagerFetchMode;
import org.apache.openjpa.persistence.jdbc.ElementClassCriteria;
import org.apache.openjpa.persistence.jdbc.ElementColumn;
import org.apache.openjpa.persistence.jdbc.ElementColumns;
import org.apache.openjpa.persistence.jdbc.ElementEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.ElementForeignKey;
import org.apache.openjpa.persistence.jdbc.ElementIndex;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumns;
import org.apache.openjpa.persistence.jdbc.ElementNonpolymorphic;
import org.apache.openjpa.persistence.jdbc.ElementStrategy;
import org.apache.openjpa.persistence.jdbc.EmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.persistence.jdbc.ForeignKeyAction;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.KeyClassCriteria;
import org.apache.openjpa.persistence.jdbc.KeyColumn;
import org.apache.openjpa.persistence.jdbc.KeyColumns;
import org.apache.openjpa.persistence.jdbc.KeyEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.KeyForeignKey;
import org.apache.openjpa.persistence.jdbc.KeyIndex;
import org.apache.openjpa.persistence.jdbc.KeyJoinColumn;
import org.apache.openjpa.persistence.jdbc.KeyJoinColumns;
import org.apache.openjpa.persistence.jdbc.KeyNonpolymorphic;
import org.apache.openjpa.persistence.jdbc.KeyStrategy;
import org.apache.openjpa.persistence.jdbc.MappingOverride;
import org.apache.openjpa.persistence.jdbc.MappingOverrides;
import org.apache.openjpa.persistence.jdbc.MappingTag;
import org.apache.openjpa.persistence.jdbc.Nonpolymorphic;
import org.apache.openjpa.persistence.jdbc.NonpolymorphicType;
import org.apache.openjpa.persistence.jdbc.OrderColumn;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.persistence.jdbc.SubclassFetchMode;
import org.apache.openjpa.persistence.jdbc.Unique;
import org.apache.openjpa.persistence.jdbc.VersionColumn;
import org.apache.openjpa.persistence.jdbc.VersionColumns;
import org.apache.openjpa.persistence.jdbc.VersionStrategy;
import org.apache.openjpa.persistence.jdbc.XEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.XJoinColumn;
import org.apache.openjpa.persistence.jdbc.XJoinColumns;
import org.apache.openjpa.persistence.jdbc.XMappingOverride;
import org.apache.openjpa.persistence.jdbc.XMappingOverrides;
import org.apache.openjpa.persistence.jdbc.XSecondaryTable;
import org.apache.openjpa.persistence.jdbc.XSecondaryTables;
import org.apache.openjpa.persistence.jdbc.XTable;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

public class AnnotationPersistenceMappingParser
extends AnnotationPersistenceMetaDataParser {
    protected static final int TRUE = 1;
    protected static final int FALSE = 2;
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceMappingParser.class);
    private static final Map<Class<?>, MappingTag> _tags = new HashMap();
    private DBDictionary _dict;
    private static final char SINGLE_QUOTE = '\'';

    public AnnotationPersistenceMappingParser(JDBCConfiguration conf) {
        super((OpenJPAConfiguration)conf);
        this._dict = conf.getDBDictionaryInstance();
    }

    protected void parsePackageMappingAnnotations(Package pkg) {
        block3: for (Annotation anno : pkg.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownPackageMappingAnnotation(pkg, anno);
                continue;
            }
            switch (tag) {
                case TABLE_GEN: {
                    this.parseTableGenerator(pkg, (TableGenerator)anno);
                    continue block3;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)pkg, (Object)anno.toString()));
                }
            }
        }
    }

    protected boolean handleUnknownPackageMappingAnnotation(Package pkg, Annotation anno) {
        return false;
    }

    private void parseTableGenerator(AnnotatedElement el, TableGenerator gen) {
        SequenceMapping meta;
        String name = gen.name();
        if (StringUtils.isEmpty((String)name)) {
            throw new MetaDataException(_loc.get("no-gen-name", (Object)el));
        }
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-gen", (Object)name));
        }
        if ((meta = (SequenceMapping)this.getRepository().getCachedSequenceMetaData(name)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get("dup-gen", (Object)name, (Object)el));
            }
            return;
        }
        meta = (SequenceMapping)this.getRepository().addSequenceMetaData(name);
        meta.setSequencePlugin("value-table");
        meta.setTableIdentifier(this.toTableIdentifier(gen.schema(), gen.table()));
        meta.setPrimaryKeyColumnIdentifier(DBIdentifier.newColumn((String)gen.pkColumnName(), (boolean)this.delimit()));
        meta.setSequenceColumnIdentifier(DBIdentifier.newColumn((String)gen.valueColumnName(), (boolean)this.delimit()));
        meta.setPrimaryKeyValue(gen.pkColumnValue());
        meta.setInitialValue(gen.initialValue());
        meta.setAllocate(gen.allocationSize());
        meta.setSource(this.getSourceFile(), (Object)(el instanceof Class ? el : null), 1);
        switch (gen.uniqueConstraints().length) {
            case 0: {
                break;
            }
            case 1: {
                meta.setUniqueColumnsIdentifier(DBIdentifier.toArray((String[])gen.uniqueConstraints()[0].columnNames(), (DBIdentifier.DBIdentifierType)DBIdentifier.DBIdentifierType.COLUMN, (boolean)this.delimit()));
                meta.setUniqueConstraintIdentifier(DBIdentifier.newConstraint((String)gen.uniqueConstraints()[0].name(), (boolean)this.delimit()));
                break;
            }
            default: {
                log.warn((Object)_loc.get("unique-many-on-seq-unsupported", (Object)el, (Object)name));
            }
        }
    }

    protected void parseClassMappingAnnotations(ClassMetaData meta) {
        ClassMapping cm = (ClassMapping)meta;
        Class cls = cm.getDescribedType();
        block29: for (Annotation anno : cls.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownClassMappingAnnotation(cm, anno);
                continue;
            }
            switch (tag) {
                case ASSOC_OVERRIDE: {
                    this.parseAssociationOverrides(cm, (AssociationOverride)anno);
                    continue block29;
                }
                case ASSOC_OVERRIDES: {
                    this.parseAssociationOverrides(cm, ((AssociationOverrides)anno).value());
                    continue block29;
                }
                case ATTR_OVERRIDE: {
                    this.parseAttributeOverrides(cm, (AttributeOverride)anno);
                    continue block29;
                }
                case ATTR_OVERRIDES: {
                    this.parseAttributeOverrides(cm, ((AttributeOverrides)anno).value());
                    continue block29;
                }
                case DISCRIM_COL: {
                    this.parseDiscriminatorColumn(cm, (DiscriminatorColumn)anno);
                    continue block29;
                }
                case DISCRIM_VAL: {
                    cm.getDiscriminator().getMappingInfo().setValue(((DiscriminatorValue)anno).value());
                    if (!Modifier.isAbstract(cm.getDescribedType().getModifiers()) || !this.getLog().isInfoEnabled()) continue block29;
                    this.getLog().info((Object)_loc.get("discriminator-on-abstract-class", (Object)cm.getDescribedType().getName()));
                    continue block29;
                }
                case INHERITANCE: {
                    this.parseInheritance(cm, (Inheritance)anno);
                    continue block29;
                }
                case PK_JOIN_COL: {
                    this.parsePrimaryKeyJoinColumns(cm, (PrimaryKeyJoinColumn)anno);
                    continue block29;
                }
                case PK_JOIN_COLS: {
                    this.parsePrimaryKeyJoinColumns(cm, ((PrimaryKeyJoinColumns)anno).value());
                    continue block29;
                }
                case SECONDARY_TABLE: {
                    this.parseSecondaryTables(cm, (SecondaryTable)anno);
                    continue block29;
                }
                case SECONDARY_TABLES: {
                    this.parseSecondaryTables(cm, ((SecondaryTables)anno).value());
                    continue block29;
                }
                case SQL_RESULT_SET_MAPPING: {
                    this.parseSQLResultSetMappings(cm, (SqlResultSetMapping)anno);
                    continue block29;
                }
                case SQL_RESULT_SET_MAPPINGS: {
                    this.parseSQLResultSetMappings(cm, ((SqlResultSetMappings)anno).value());
                    continue block29;
                }
                case TABLE: {
                    this.parseTable(cm, (Table)anno);
                    continue block29;
                }
                case TABLE_GEN: {
                    this.parseTableGenerator(cls, (TableGenerator)anno);
                    continue block29;
                }
                case DATASTORE_ID_COL: {
                    this.parseDataStoreIdColumn(cm, (DataStoreIdColumn)anno);
                    continue block29;
                }
                case DISCRIM_STRAT: {
                    cm.getDiscriminator().getMappingInfo().setStrategy(((DiscriminatorStrategy)anno).value());
                    continue block29;
                }
                case FK: {
                    this.parseForeignKey((MappingInfo)cm.getMappingInfo(), (ForeignKey)anno);
                    continue block29;
                }
                case MAPPING_OVERRIDE: {
                    this.parseMappingOverrides(cm, (MappingOverride)anno);
                    continue block29;
                }
                case MAPPING_OVERRIDES: {
                    this.parseMappingOverrides(cm, ((MappingOverrides)anno).value());
                    continue block29;
                }
                case STRAT: {
                    cm.getMappingInfo().setStrategy(((Strategy)anno).value());
                    continue block29;
                }
                case SUBCLASS_FETCH_MODE: {
                    cm.setSubclassFetchMode(AnnotationPersistenceMappingParser.toEagerFetchModeConstant(((SubclassFetchMode)anno).value()));
                    continue block29;
                }
                case VERSION_COL: {
                    this.parseVersionColumns(cm, (VersionColumn)anno);
                    continue block29;
                }
                case VERSION_COLS: {
                    this.parseVersionColumns(cm, ((VersionColumns)anno).value());
                    continue block29;
                }
                case VERSION_STRAT: {
                    cm.getVersion().getMappingInfo().setStrategy(((VersionStrategy)anno).value());
                    continue block29;
                }
                case X_MAPPING_OVERRIDE: {
                    this.parseMappingOverrides(cm, (XMappingOverride)anno);
                    continue block29;
                }
                case X_MAPPING_OVERRIDES: {
                    this.parseMappingOverrides(cm, ((XMappingOverrides)anno).value());
                    continue block29;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)cm, (Object)anno));
                }
            }
        }
    }

    protected boolean handleUnknownClassMappingAnnotation(ClassMapping cls, Annotation anno) {
        return false;
    }

    private void parseAssociationOverrides(ClassMapping cm, AssociationOverride ... assocs) {
        for (AssociationOverride assoc : assocs) {
            if (StringUtils.isEmpty((String)assoc.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(assoc.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(assoc.name(), Object.class, Object.class);
            }
            JoinColumn[] scols = assoc.joinColumns();
            JoinTable joinTbl = assoc.joinTable();
            if ((scols == null || scols.length == 0) && joinTbl == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)sup, (Object)assoc.name()));
            }
            if (scols != null && scols.length > 0) {
                ArrayList<Column> jcols = new ArrayList<Column>(scols.length);
                int unique = 0;
                for (JoinColumn scol : scols) {
                    unique |= scol.unique() ? 1 : 2;
                    jcols.add(this.newColumn(scol));
                }
                this.setColumns(sup, (MappingInfo)sup.getValueInfo(), jcols, unique);
                continue;
            }
            if (joinTbl == null) continue;
            this.parseJoinTable(sup, joinTbl);
        }
    }

    private void parseAttributeOverrides(ClassMapping cm, AttributeOverride ... attrs) {
        for (AttributeOverride attr : attrs) {
            if (StringUtils.isEmpty((String)attr.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(attr.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(attr.name(), Object.class, Object.class);
            }
            if (attr.column() == null) continue;
            this.parseColumns(sup, attr.column());
        }
    }

    private void parsePrimaryKeyJoinColumns(ClassMapping cm, PrimaryKeyJoinColumn ... joins) {
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        for (PrimaryKeyJoinColumn join : joins) {
            cols.add(this.newColumn(join));
        }
        cm.getMappingInfo().setColumns(cols);
    }

    private Column newColumn(PrimaryKeyJoinColumn join) {
        Column col = new Column();
        col.setFlag(128, true);
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            this.setTargetIdentifier(col, join.referencedColumnName());
        }
        return col;
    }

    private void parseSecondaryTables(ClassMapping cm, SecondaryTable ... tables) {
        ClassMappingInfo info = cm.getMappingInfo();
        ArrayList<Column> joins = null;
        for (SecondaryTable table : tables) {
            DBIdentifier sName = DBIdentifier.newTable((String)table.name(), (boolean)this.delimit());
            if (DBIdentifier.isEmpty((DBIdentifier)sName)) {
                throw new MetaDataException(_loc.get("second-name", (Object)cm));
            }
            if (!StringUtils.isEmpty((String)table.schema())) {
                DBIdentifier sSchema = DBIdentifier.newSchema((String)table.schema(), (boolean)this.delimit());
                sName = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sSchema, sName});
            }
            if (table.pkJoinColumns().length > 0) {
                joins = new ArrayList<Column>(table.pkJoinColumns().length);
                for (PrimaryKeyJoinColumn join : table.pkJoinColumns()) {
                    joins.add(this.newColumn(join));
                }
                info.setSecondaryTableJoinColumns(sName, joins);
            } else {
                info.addSecondaryTable(sName);
            }
            this.addUniqueConstraints(sName.getName(), (MetaDataContext)cm, (MappingInfo)info, table.uniqueConstraints());
        }
    }

    private void parseTable(ClassMapping cm, Table table) {
        if (cm.isAbstract()) {
            throw new UserException(_loc.get("table-not-allowed", (Object)cm));
        }
        DBIdentifier tName = this.toTableIdentifier(table.schema(), table.name());
        if (!DBIdentifier.isNull((DBIdentifier)tName)) {
            cm.getMappingInfo().setTableIdentifier(tName);
        }
        this.addUniqueConstraints(tName.getName(), (MetaDataContext)cm, (MappingInfo)cm.getMappingInfo(), table.uniqueConstraints());
    }

    org.apache.openjpa.jdbc.schema.Unique createUniqueConstraint(MetaDataContext ctx, UniqueConstraint anno) {
        String[] columnNames = anno.columnNames();
        if (columnNames == null || columnNames.length == 0) {
            throw new UserException(_loc.get("unique-no-column", (Object)ctx));
        }
        Object[] sColNames = DBIdentifier.toArray((String[])columnNames, (DBIdentifier.DBIdentifierType)DBIdentifier.DBIdentifierType.COLUMN, (boolean)this.delimit());
        org.apache.openjpa.jdbc.schema.Unique uniqueConstraint = new org.apache.openjpa.jdbc.schema.Unique();
        for (int i = 0; i < sColNames.length; ++i) {
            if (DBIdentifier.isEmpty((DBIdentifier)sColNames[i])) {
                throw new UserException(_loc.get("unique-empty-column", (Object)Arrays.toString(sColNames), (Object)ctx));
            }
            Column column = new Column();
            column.setIdentifier((DBIdentifier)sColNames[i]);
            uniqueConstraint.addColumn(column);
        }
        if (!StringUtils.isEmpty((String)anno.name())) {
            uniqueConstraint.setIdentifier(DBIdentifier.newConstraint((String)anno.name(), (boolean)this.delimit()));
        }
        return uniqueConstraint;
    }

    void addUniqueConstraints(String table, MetaDataContext ctx, MappingInfo info, UniqueConstraint ... uniqueConstraints) {
        for (UniqueConstraint anno : uniqueConstraints) {
            org.apache.openjpa.jdbc.schema.Unique unique = this.createUniqueConstraint(ctx, anno);
            unique.setTableIdentifier(DBIdentifier.newTable((String)table, (boolean)this.delimit()));
            if (info instanceof ClassMappingInfo) {
                ((ClassMappingInfo)info).addUnique(table, unique);
                continue;
            }
            if (info instanceof FieldMappingInfo) {
                ((FieldMappingInfo)info).addJoinTableUnique(unique);
                continue;
            }
            throw new InternalException();
        }
    }

    private DBIdentifier toTableIdentifier(String schema, String table) {
        if (StringUtils.isEmpty((String)table)) {
            return DBIdentifier.NULL;
        }
        DBIdentifier tName = DBIdentifier.newTable((String)table, (boolean)this.delimit());
        DBIdentifier sName = DBIdentifier.newSchema((String)schema, (boolean)this.delimit());
        if (DBIdentifier.isEmpty((DBIdentifier)tName) || DBIdentifier.isEmpty((DBIdentifier)sName)) {
            return tName;
        }
        return QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sName, tName});
    }

    private void parseSQLResultSetMappings(ClassMapping cm, SqlResultSetMapping ... annos) {
        MappingRepository repos = (MappingRepository)this.getRepository();
        Log log = this.getLog();
        for (SqlResultSetMapping anno : annos) {
            QueryResultMapping result;
            if (log.isTraceEnabled()) {
                log.trace((Object)_loc.get("parse-sqlrsmapping", (Object)anno.name()));
            }
            if ((result = repos.getCachedQueryResultMapping(null, anno.name())) != null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)_loc.get("dup-sqlrsmapping", (Object)anno.name(), (Object)cm));
                continue;
            }
            result = repos.addQueryResultMapping(null, anno.name());
            result.setSource(this.getSourceFile(), (Object)cm.getDescribedType(), 1);
            for (EntityResult entityResult : anno.entities()) {
                QueryResultMapping.PCResult entityResult2 = result.addPCResult(entityResult.entityClass());
                if (!StringUtils.isEmpty((String)entityResult.discriminatorColumn())) {
                    entityResult2.addMapping("<discriminator>", (Object)entityResult.discriminatorColumn());
                }
                for (FieldResult field : entityResult.fields()) {
                    DBIdentifier sColName = DBIdentifier.newColumn((String)field.column(), (boolean)this.delimit());
                    entityResult2.addMapping(field.name(), (Object)sColName.getName());
                }
            }
            for (EntityResult entityResult : anno.columns()) {
                DBIdentifier sName = DBIdentifier.newColumn((String)entityResult.name(), (boolean)this.delimit());
                result.addColumnResult((Object)sName.getName());
            }
        }
    }

    private void parseDiscriminatorColumn(ClassMapping cm, DiscriminatorColumn dcol) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)dcol.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)dcol.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)dcol.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)dcol.columnDefinition()));
        }
        Discriminator discrim = cm.getDiscriminator();
        switch (dcol.discriminatorType()) {
            case CHAR: {
                col.setJavaType(2);
                discrim.setJavaType(2);
                break;
            }
            case INTEGER: {
                col.setJavaType(5);
                if (dcol.length() != 31) {
                    col.setSize(dcol.length());
                }
                discrim.setJavaType(5);
                break;
            }
            default: {
                col.setJavaType(9);
                col.setSize(dcol.length());
                discrim.setJavaType(9);
            }
        }
        cm.getDiscriminator().getMappingInfo().setColumns(Arrays.asList(col));
    }

    private void parseInheritance(ClassMapping cm, Inheritance inherit) {
        ClassMappingInfo info = cm.getMappingInfo();
        switch (inherit.strategy()) {
            case SINGLE_TABLE: {
                info.setHierarchyStrategy("flat");
                break;
            }
            case JOINED: {
                info.setHierarchyStrategy("vertical");
                break;
            }
            case TABLE_PER_CLASS: {
                info.setHierarchyStrategy("full");
                break;
            }
            default: {
                throw new InternalException();
            }
        }
    }

    private void parseMappingOverrides(ClassMapping cm, MappingOverride ... overs) {
        for (MappingOverride over : overs) {
            if (StringUtils.isEmpty((String)over.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(over.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(over.name(), Object.class, Object.class);
            }
            this.populate(sup, over);
        }
    }

    private void populate(FieldMapping fm, MappingOverride over) {
        if (over.containerTable().specified()) {
            this.parseContainerTable(fm, over.containerTable());
        }
        this.parseColumns(fm, over.columns());
        this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, over.joinColumns());
        this.parseElementJoinColumns(fm, over.elementJoinColumns());
    }

    private void parseDataStoreIdColumn(ClassMapping cm, DataStoreIdColumn id) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)id.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)id.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)id.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)id.columnDefinition()));
        }
        if (id.precision() != 0) {
            col.setSize(id.precision());
        }
        col.setFlag(2, !id.insertable());
        col.setFlag(4, !id.updatable());
        cm.getMappingInfo().setColumns(Arrays.asList(col));
    }

    private void parseForeignKey(MappingInfo info, ForeignKey fk) {
        if (!fk.implicit()) {
            this.parseForeignKey(info, fk.name(), fk.enabled(), fk.deferred(), fk.deleteAction(), fk.updateAction());
        } else {
            info.setImplicitRelation(true);
            this.assertDefault(fk);
        }
    }

    protected void parseForeignKey(MappingInfo info, String name, boolean enabled, boolean deferred, ForeignKeyAction deleteAction, ForeignKeyAction updateAction) {
        if (!enabled) {
            info.setCanForeignKey(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.ForeignKey fk = new org.apache.openjpa.jdbc.schema.ForeignKey();
        if (!StringUtils.isEmpty((String)name)) {
            fk.setIdentifier(DBIdentifier.newForeignKey((String)name, (boolean)this.delimit()));
        }
        fk.setDeferred(deferred);
        fk.setDeleteAction(this.toForeignKeyAction(deleteAction));
        fk.setUpdateAction(this.toForeignKeyAction(updateAction));
        info.setForeignKey(fk);
    }

    void assertDefault(ForeignKey fk) {
        boolean isDefault;
        boolean bl = isDefault = StringUtils.isEmpty((String)fk.name()) && fk.enabled() && !fk.deferred() && fk.deleteAction() == ForeignKeyAction.RESTRICT && fk.updateAction() == ForeignKeyAction.RESTRICT && fk.columnNames().length == 0 && fk.specified();
        if (!isDefault) {
            throw new UserException(_loc.get("implicit-non-default-fk", (Object)this._cls, (Object)this.getSourceFile()).getMessage());
        }
    }

    private int toForeignKeyAction(ForeignKeyAction action) {
        switch (action) {
            case RESTRICT: {
                return 2;
            }
            case CASCADE: {
                return 3;
            }
            case NULL: {
                return 4;
            }
            case DEFAULT: {
                return 5;
            }
        }
        throw new InternalException();
    }

    private void parseIndex(MappingInfo info, Index idx) {
        this.parseIndex(info, idx.name(), idx.enabled(), idx.unique());
    }

    protected void parseIndex(MappingInfo info, String name, boolean enabled, boolean unique) {
        if (!enabled) {
            info.setCanIndex(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.Index idx = new org.apache.openjpa.jdbc.schema.Index();
        if (!StringUtils.isEmpty((String)name)) {
            idx.setIdentifier(DBIdentifier.newConstraint((String)name, (boolean)this.delimit()));
        }
        idx.setUnique(unique);
        info.setIndex(idx);
    }

    private void parseUnique(FieldMapping fm, Unique anno) {
        ValueMappingInfo info = fm.getValueInfo();
        if (!anno.enabled()) {
            info.setCanUnique(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.Unique unq = new org.apache.openjpa.jdbc.schema.Unique();
        if (!StringUtils.isEmpty((String)anno.name())) {
            unq.setIdentifier(DBIdentifier.newIndex((String)anno.name(), (boolean)this.delimit()));
        }
        unq.setDeferred(anno.deferred());
        info.setUnique(unq);
    }

    private void parseVersionColumns(ClassMapping cm, VersionColumn ... vcols) {
        if (vcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(vcols.length);
        for (VersionColumn vcol : vcols) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(vcol, this.delimit()));
        }
        cm.getVersion().getMappingInfo().setColumns(cols);
    }

    private static Column newColumn(VersionColumn anno, boolean delimit) {
        return AnnotationPersistenceMappingParser.newColumn(anno.name(), anno.nullable(), anno.insertable(), anno.updatable(), anno.columnDefinition(), anno.length(), anno.precision(), anno.scale(), anno.table(), delimit);
    }

    static Column newColumn(String name, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, int length, int precision, int scale, String table, boolean delimit) {
        Column col = new Column();
        col.setTableIdentifier(DBIdentifier.newTable((String)table, (boolean)delimit));
        if (!StringUtils.isEmpty((String)name)) {
            col.setIdentifier(DBIdentifier.newColumn((String)name, (boolean)delimit));
        }
        if (precision != 0) {
            col.setSize(precision);
        } else if (length != 255) {
            col.setSize(length);
        }
        col.setNotNull(!nullable);
        col.setDecimalDigits(scale);
        if (!StringUtils.isEmpty((String)columnDefinition)) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)columnDefinition));
            col.setType(Schemas.getJDBCType((String)col.getTypeIdentifier().getName()));
            col.setJavaType(JavaTypes.getTypeCode((Class)Schemas.getJavaType((int)col.getType(), (int)col.getSize(), (int)col.getDecimalDigits())));
        }
        col.setFlag(2, !insertable);
        col.setFlag(4, !updatable);
        return col;
    }

    private void parseMappingOverrides(ClassMapping cm, XMappingOverride ... overs) {
        for (XMappingOverride over : overs) {
            if (StringUtils.isEmpty((String)over.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(over.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(over.name(), Object.class, Object.class);
            }
            this.populate(sup, over);
        }
    }

    private void populate(FieldMapping fm, XMappingOverride over) {
        if (over.containerTable().specified()) {
            this.parseContainerTable(fm, over.containerTable());
        }
        this.parseColumns(fm, over.columns());
        this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, over.joinColumns());
        this.parseElementColumns(fm, over.elementColumns());
        this.parseElementJoinColumns(fm, over.elementJoinColumns());
        this.parseKeyColumns(fm, over.keyColumns());
        this.parseKeyJoinColumns(fm, over.keyJoinColumns());
    }

    private void parseElementColumns(FieldMapping fm, ElementColumn ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(pcols.length);
        int unique = 0;
        for (int i = 0; i < pcols.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i], this.delimit()));
            unique |= pcols[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(ElementColumn anno, boolean delimit) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)anno.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)anno.columnDefinition()));
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
        return col;
    }

    private void parseKeyJoinColumns(FieldMapping fm, KeyJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(joins[i], this.delimit()));
            unique |= joins[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(KeyJoinColumn join, boolean delimit) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTargetIdentifier(DBIdentifier.newColumn((String)join.referencedColumnName(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private static int toEagerFetchModeConstant(FetchMode mode) {
        switch (mode) {
            case NONE: {
                return 0;
            }
            case JOIN: {
                return 1;
            }
            case PARALLEL: {
                return 2;
            }
        }
        throw new InternalException();
    }

    protected void parseLobMapping(FieldMetaData fmd) {
        Class type;
        Column col = new Column();
        int typeCode = fmd.isElementCollection() ? fmd.getElement().getDeclaredTypeCode() : fmd.getDeclaredTypeCode();
        Class clazz = type = fmd.isElementCollection() ? fmd.getElement().getDeclaredType() : fmd.getDeclaredType();
        if (typeCode == 9 || type == char[].class || type == Character[].class) {
            col.setType(2005);
        } else {
            col.setType(2004);
        }
        if (fmd.isElementCollection()) {
            ((FieldMapping)fmd).getElementMapping().getValueInfo().setColumns(Arrays.asList(col));
        } else {
            ((FieldMapping)fmd).getValueInfo().setColumns(Arrays.asList(col));
        }
    }

    protected void parseMemberMappingAnnotations(FieldMetaData fmd) {
        FieldMapping fm = (FieldMapping)fmd;
        AnnotatedElement el = (AnnotatedElement)((Object)this.getRepository().getMetaDataFactory().getDefaults().getBackingMember(fmd));
        block56: for (Annotation anno : el.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownMemberMappingAnnotation(fm, anno);
                continue;
            }
            switch (tag) {
                case ASSOC_OVERRIDE: {
                    this.parseAssociationOverrides(fm, (AssociationOverride)anno);
                    continue block56;
                }
                case ASSOC_OVERRIDES: {
                    this.parseAssociationOverrides(fm, ((AssociationOverrides)anno).value());
                    continue block56;
                }
                case ATTR_OVERRIDE: {
                    this.parseAttributeOverrides(fm, (AttributeOverride)anno);
                    continue block56;
                }
                case ATTR_OVERRIDES: {
                    this.parseAttributeOverrides(fm, ((AttributeOverrides)anno).value());
                    continue block56;
                }
                case COL: {
                    this.parseColumns(fm, (javax.persistence.Column)anno);
                    continue block56;
                }
                case COLS: {
                    this.parseColumns(fm, ((Columns)anno).value());
                    continue block56;
                }
                case ENUMERATED: {
                    this.parseEnumerated(fm, (Enumerated)anno);
                    continue block56;
                }
                case JOIN_COL: {
                    this.parseJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, (JoinColumn)anno);
                    continue block56;
                }
                case JOIN_COLS: {
                    this.parseJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, ((JoinColumns)anno).value());
                    continue block56;
                }
                case JOIN_TABLE: {
                    this.parseJoinTable(fm, (JoinTable)anno);
                    continue block56;
                }
                case KEY_CLASS_CRIT: {
                    fm.getKeyMapping().getValueInfo().setUseClassCriteria(((KeyClassCriteria)anno).value());
                    continue block56;
                }
                case KEY_COL: {
                    this.parseKeyColumns(fm, (KeyColumn)anno);
                    continue block56;
                }
                case KEY_COLS: {
                    this.parseKeyColumns(fm, ((KeyColumns)anno).value());
                    continue block56;
                }
                case KEY_EMBEDDED_MAPPING: {
                    KeyEmbeddedMapping kembed = (KeyEmbeddedMapping)anno;
                    this.parseEmbeddedMapping(fm.getKeyMapping(), DBIdentifier.newColumn((String)kembed.nullIndicatorColumnName(), (boolean)this.delimit()), DBIdentifier.newConstant((String)kembed.nullIndicatorAttributeName()), kembed.overrides());
                    continue block56;
                }
                case KEY_FK: {
                    KeyForeignKey kfk = (KeyForeignKey)anno;
                    this.parseForeignKey((MappingInfo)fm.getKeyMapping().getValueInfo(), kfk.name(), kfk.enabled(), kfk.deferred(), kfk.deleteAction(), kfk.updateAction());
                    continue block56;
                }
                case KEY_INDEX: {
                    KeyIndex kidx = (KeyIndex)anno;
                    this.parseIndex((MappingInfo)fm.getKeyMapping().getValueInfo(), kidx.name(), kidx.enabled(), kidx.unique());
                    continue block56;
                }
                case KEY_JOIN_COL: {
                    this.parseKeyJoinColumns(fm, (KeyJoinColumn)anno);
                    continue block56;
                }
                case KEY_JOIN_COLS: {
                    this.parseKeyJoinColumns(fm, ((KeyJoinColumns)anno).value());
                    continue block56;
                }
                case KEY_NONPOLY: {
                    fm.getKeyMapping().setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((KeyNonpolymorphic)anno).value()));
                    continue block56;
                }
                case KEY_STRAT: {
                    fm.getKeyMapping().getValueInfo().setStrategy(((KeyStrategy)anno).value());
                    continue block56;
                }
                case MAP_KEY_COL: {
                    this.parseMapKeyColumn(fm, (MapKeyColumn)anno);
                    continue block56;
                }
                case MAP_KEY_ENUMERATED: {
                    this.parseMapKeyEnumerated(fm, (MapKeyEnumerated)anno);
                    continue block56;
                }
                case MAP_KEY_JOIN_COL: {
                    this.parseMapKeyJoinColumns(fm, (MapKeyJoinColumn)anno);
                    continue block56;
                }
                case MAP_KEY_JOIN_COLS: {
                    this.parseMapKeyJoinColumns(fm, ((MapKeyJoinColumns)anno).value());
                    continue block56;
                }
                case PK_JOIN_COL: {
                    this.parsePrimaryKeyJoinColumns(fm, (PrimaryKeyJoinColumn)anno);
                    continue block56;
                }
                case PK_JOIN_COLS: {
                    this.parsePrimaryKeyJoinColumns(fm, ((PrimaryKeyJoinColumns)anno).value());
                    continue block56;
                }
                case TABLE_GEN: {
                    this.parseTableGenerator(el, (TableGenerator)anno);
                    continue block56;
                }
                case TEMPORAL: {
                    this.parseTemporal(fm, (Temporal)anno);
                    continue block56;
                }
                case MAP_KEY_TEMPORAL: {
                    this.parseMapKeyTemporal(fm, (MapKeyTemporal)anno);
                    continue block56;
                }
                case CLASS_CRIT: {
                    fm.getValueInfo().setUseClassCriteria(((ClassCriteria)anno).value());
                    continue block56;
                }
                case CONTAINER_TABLE: {
                    this.parseContainerTable(fm, (ContainerTable)anno);
                    continue block56;
                }
                case COLLECTION_TABLE: {
                    this.parseCollectionTable(fm, (CollectionTable)anno);
                    continue block56;
                }
                case EAGER_FETCH_MODE: {
                    fm.setEagerFetchMode(AnnotationPersistenceMappingParser.toEagerFetchModeConstant(((EagerFetchMode)anno).value()));
                    continue block56;
                }
                case ELEM_CLASS_CRIT: {
                    fm.getElementMapping().getValueInfo().setUseClassCriteria(((ElementClassCriteria)anno).value());
                    continue block56;
                }
                case ELEM_COL: {
                    this.parseElementColumns(fm, (ElementColumn)anno);
                    continue block56;
                }
                case ELEM_COLS: {
                    this.parseElementColumns(fm, ((ElementColumns)anno).value());
                    continue block56;
                }
                case ELEM_EMBEDDED_MAPPING: {
                    ElementEmbeddedMapping ee = (ElementEmbeddedMapping)anno;
                    this.parseEmbeddedMapping(fm.getElementMapping(), DBIdentifier.newConstant((String)ee.nullIndicatorAttributeName()), DBIdentifier.newColumn((String)ee.nullIndicatorColumnName(), (boolean)this.delimit()), ee.overrides());
                    continue block56;
                }
                case ELEM_FK: {
                    ElementForeignKey efk = (ElementForeignKey)anno;
                    this.parseForeignKey((MappingInfo)fm.getElementMapping().getValueInfo(), efk.name(), efk.enabled(), efk.deferred(), efk.deleteAction(), efk.updateAction());
                    continue block56;
                }
                case ELEM_INDEX: {
                    ElementIndex eidx = (ElementIndex)anno;
                    this.parseIndex((MappingInfo)fm.getElementMapping().getValueInfo(), eidx.name(), eidx.enabled(), eidx.unique());
                    continue block56;
                }
                case ELEM_JOIN_COL: {
                    this.parseElementJoinColumns(fm, (ElementJoinColumn)anno);
                    continue block56;
                }
                case ELEM_JOIN_COLS: {
                    this.parseElementJoinColumns(fm, ((ElementJoinColumns)anno).value());
                    continue block56;
                }
                case ELEM_NONPOLY: {
                    fm.getElementMapping().setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((ElementNonpolymorphic)anno).value()));
                    continue block56;
                }
                case ELEM_STRAT: {
                    fm.getElementMapping().getValueInfo().setStrategy(((ElementStrategy)anno).value());
                    continue block56;
                }
                case EMBEDDED_MAPPING: {
                    this.parseEmbeddedMapping(fm, (EmbeddedMapping)anno);
                    continue block56;
                }
                case FK: {
                    this.parseForeignKey((MappingInfo)fm.getValueInfo(), (ForeignKey)anno);
                    continue block56;
                }
                case INDEX: {
                    this.parseIndex((MappingInfo)fm.getValueInfo(), (Index)anno);
                    continue block56;
                }
                case NONPOLY: {
                    fm.setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((Nonpolymorphic)anno).value()));
                    continue block56;
                }
                case ORDER_COLUMN: {
                    this.parseJavaxOrderColumn(fm, (javax.persistence.OrderColumn)anno);
                    continue block56;
                }
                case ORDER_COL: {
                    this.parseOrderColumn(fm, (OrderColumn)anno);
                    continue block56;
                }
                case STRAT: {
                    fm.getMappingInfo().setStrategy(((Strategy)anno).value());
                    continue block56;
                }
                case UNIQUE: {
                    this.parseUnique(fm, (Unique)anno);
                    continue block56;
                }
                case X_EMBEDDED_MAPPING: {
                    XEmbeddedMapping embed = (XEmbeddedMapping)anno;
                    this.parseEmbeddedMapping((ValueMapping)fm, DBIdentifier.newColumn((String)embed.nullIndicatorColumnName(), (boolean)this.delimit()), DBIdentifier.newConstant((String)embed.nullIndicatorAttributeName()), embed.overrides());
                    continue block56;
                }
                case X_JOIN_COL: {
                    this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, (XJoinColumn)anno);
                    continue block56;
                }
                case X_JOIN_COLS: {
                    this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, ((XJoinColumns)anno).value());
                    continue block56;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)fm, (Object)anno.toString()));
                }
            }
        }
    }

    protected boolean handleUnknownMemberMappingAnnotation(FieldMapping fm, Annotation anno) {
        return false;
    }

    protected static int toPolymorphicConstant(NonpolymorphicType val) {
        switch (val) {
            case EXACT: {
                return 1;
            }
            case JOINABLE: {
                return 2;
            }
            case FALSE: {
                return 0;
            }
        }
        throw new InternalException();
    }

    private void parseAssociationOverrides(FieldMapping fm, AssociationOverride ... assocs) {
        for (AssociationOverride assoc : assocs) {
            FieldMapping efm = AnnotationPersistenceMappingParser.getEmbeddedFieldMapping(fm, assoc.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)assoc.name()));
            }
            JoinColumn[] ecols = assoc.joinColumns();
            JoinTable joinTbl = assoc.joinTable();
            if ((ecols == null || ecols.length == 0) && joinTbl == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)assoc.name()));
            }
            if (ecols != null && ecols.length > 0) {
                int unique = 0;
                ArrayList<Column> jcols = new ArrayList<Column>(ecols.length);
                for (JoinColumn ecol : ecols) {
                    unique |= ecol.unique() ? 1 : 2;
                    jcols.add(this.newColumn(ecol));
                }
                this.setColumns(efm, (MappingInfo)efm.getValueInfo(), jcols, unique);
                continue;
            }
            if (joinTbl == null) continue;
            this.parseJoinTable(efm, joinTbl);
        }
    }

    private void parseAttributeOverrides(FieldMapping fm, AttributeOverride ... attrs) {
        for (AttributeOverride attr : attrs) {
            String attrName = attr.name();
            FieldMapping efm = AnnotationPersistenceMappingParser.getEmbeddedFieldMapping(fm, attrName);
            if (attr.column() == null) continue;
            this.parseColumns(efm, attr.column());
        }
    }

    public static FieldMapping getEmbeddedFieldMapping(FieldMapping fm, String attrName) {
        return AnnotationPersistenceMappingParser.getEmbeddedFieldMapping(fm, attrName, true);
    }

    public static FieldMapping getEmbeddedFieldMapping(FieldMapping fm, String attrName, boolean mustExist) {
        ClassMapping embed = null;
        boolean isKey = false;
        boolean isValue = false;
        if (attrName != null && attrName.startsWith("key.")) {
            isKey = true;
        } else if (attrName != null && attrName.startsWith("value.")) {
            isValue = true;
        }
        if (isKey || isValue) {
            attrName = attrName.substring(attrName.indexOf(".") + 1);
        }
        int typeCode = fm.getValue().getDeclaredTypeCode();
        switch (typeCode) {
            case 12: {
                if (isKey || isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                embed = fm.getElementMapping().getEmbeddedMapping();
                break;
            }
            case 13: {
                if (!isKey && !isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                if (isKey) {
                    embed = AnnotationPersistenceMappingParser.getEmbeddedMapping(fm.getKeyMapping(), mustExist);
                    break;
                }
                if (!isValue) break;
                embed = AnnotationPersistenceMappingParser.getEmbeddedMapping(fm.getElementMapping(), mustExist);
                break;
            }
            default: {
                if (isKey || isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                embed = AnnotationPersistenceMappingParser.getEmbeddedMapping(fm.getValueMapping(), mustExist);
            }
        }
        if (embed == null) {
            if (mustExist) {
                throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
            }
            return null;
        }
        return AnnotationPersistenceMappingParser.getAttributeOverrideField(attrName, fm, embed);
    }

    public static Class<?> getEmbeddedClassType(FieldMapping fm, String attrName) {
        ValueMapping embed = null;
        boolean isKey = false;
        boolean isValue = false;
        if (attrName != null && attrName.startsWith("key.")) {
            isKey = true;
        } else if (attrName != null && attrName.startsWith("value.")) {
            isValue = true;
        }
        if (isKey || isValue) {
            attrName = attrName.substring(attrName.indexOf(".") + 1);
        }
        int typeCode = fm.getValue().getDeclaredTypeCode();
        switch (typeCode) {
            case 12: {
                if (isKey || isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                embed = fm.getElementMapping();
                break;
            }
            case 13: {
                if (!isKey && !isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                if (isKey) {
                    embed = fm.getKeyMapping();
                    break;
                }
                if (!isValue) break;
                embed = fm.getElementMapping();
                break;
            }
            default: {
                if (isKey || isValue) {
                    throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
                }
                embed = fm.getValueMapping();
            }
        }
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
        }
        return embed.getDeclaredType();
    }

    public static ClassMapping getEmbeddedMapping(ValueMapping val, boolean createNew) {
        ClassMapping embed = val.getEmbeddedMapping();
        if (embed != null || !createNew) {
            return embed;
        }
        val.addEmbeddedMetaData();
        return val.getEmbeddedMapping();
    }

    public static ClassMapping getEmbeddedMapping(ValueMapping val) {
        return AnnotationPersistenceMappingParser.getEmbeddedMapping(val, true);
    }

    public static FieldMapping getAttributeOverrideField(String attrName, FieldMapping fm, ClassMapping embed) {
        int idxOfDot = attrName.indexOf(".");
        if (idxOfDot == -1) {
            FieldMapping efm = embed.getFieldMapping(attrName);
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName));
            }
            return efm;
        }
        String attrName1 = attrName.substring(0, idxOfDot);
        String attrName2 = attrName.substring(idxOfDot + 1);
        FieldMapping efm = embed.getFieldMapping(attrName1);
        if (efm == null) {
            throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attrName1));
        }
        ClassMapping embed1 = AnnotationPersistenceMappingParser.getEmbeddedMapping(efm.getValueMapping());
        return AnnotationPersistenceMappingParser.getAttributeOverrideField(attrName2, efm, embed1);
    }

    private void parseEnumerated(FieldMapping fm, Enumerated anno) {
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(anno.value() == EnumType.ORDINAL) + ")";
        if (fm.isElementCollection()) {
            fm.getElementMapping().getValueInfo().setStrategy(strat);
        } else {
            fm.getValueInfo().setStrategy(strat);
        }
    }

    private void parseMapKeyEnumerated(FieldMapping fm, MapKeyEnumerated anno) {
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(anno.value() == EnumType.ORDINAL) + ")";
        fm.getKeyMapping().getValueInfo().setStrategy(strat);
    }

    private void parseTemporal(FieldMapping fm, Temporal anno) {
        List cols = fm.getValueInfo().getColumns();
        if (!cols.isEmpty() && cols.size() != 1) {
            throw new MetaDataException(_loc.get("num-cols-mismatch", (Object)fm, (Object)String.valueOf(cols.size()), (Object)"1"));
        }
        if (cols.isEmpty()) {
            cols = Arrays.asList(new Column());
            if (fm.isElementCollection()) {
                if (!fm.getElementMapping().getValueInfo().getColumns().isEmpty()) {
                    cols = fm.getElementMapping().getValueInfo().getColumns();
                } else {
                    fm.getElementMapping().getValueInfo().setColumns(cols);
                }
            } else {
                fm.getValueInfo().setColumns(cols);
            }
        }
        Column col = (Column)cols.get(0);
        switch (anno.value()) {
            case DATE: {
                col.setType(91);
                break;
            }
            case TIME: {
                col.setType(92);
                break;
            }
            case TIMESTAMP: {
                col.setType(93);
            }
        }
    }

    private void parseMapKeyTemporal(FieldMapping fm, MapKeyTemporal anno) {
        List<Column> cols = fm.getKeyMapping().getValueInfo().getColumns();
        if (!cols.isEmpty() && cols.size() != 1) {
            throw new MetaDataException(_loc.get("num-cols-mismatch", (Object)fm, (Object)String.valueOf(cols.size()), (Object)"1"));
        }
        if (cols.isEmpty()) {
            cols = Arrays.asList(new Column());
            fm.getKeyMapping().getValueInfo().setColumns(cols);
        }
        Column col = (Column)cols.get(0);
        switch (anno.value()) {
            case DATE: {
                col.setType(91);
                break;
            }
            case TIME: {
                col.setType(92);
                break;
            }
            case TIMESTAMP: {
                col.setType(93);
            }
        }
    }

    protected void parseColumns(FieldMapping fm, javax.persistence.Column ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = fm.getValueInfo().getColumns();
        if (!cols.isEmpty() && cols.size() != pcols.length) {
            throw new MetaDataException(_loc.get("num-cols-mismatch", (Object)fm, (Object)String.valueOf(cols.size()), (Object)String.valueOf(pcols.length)));
        }
        Class<?> xmlRootElementClass = null;
        try {
            xmlRootElementClass = Class.forName("javax.xml.bind.annotation.XmlRootElement");
        }
        catch (Exception e) {
            // empty catch block
        }
        int unique = 0;
        DBIdentifier sSecondary = DBIdentifier.NULL;
        for (int i = 0; i < pcols.length; ++i) {
            if (cols.size() > i) {
                AnnotationPersistenceMappingParser.setupColumn((Column)cols.get(i), pcols[i], this.delimit());
            } else {
                if (cols.isEmpty()) {
                    cols = new ArrayList<Column>(pcols.length);
                }
                cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i], this.delimit()));
            }
            if (xmlRootElementClass != null && StringUtils.isEmpty((String)pcols[i].columnDefinition()) && ((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)fm.getDeclaredType(), xmlRootElementClass))).booleanValue()) {
                DBDictionary dict = ((MappingRepository)this.getRepository()).getDBDictionary();
                if (dict.supportsXMLColumn) {
                    ((Column)cols.get(i)).setTypeIdentifier(DBIdentifier.newColumnDefinition((String)dict.xmlTypeName));
                }
            }
            unique |= pcols[i].unique() ? 1 : 2;
            DBIdentifier sSecTable = DBIdentifier.newTable((String)pcols[i].table(), (boolean)this.delimit());
            sSecondary = this.trackSecondaryTable(fm, sSecondary, sSecTable, i);
        }
        if (fm.isElementCollection()) {
            this.setColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), (List<Column>)cols, unique);
        } else {
            this.setColumns(fm, (MappingInfo)fm.getValueInfo(), (List<Column>)cols, unique);
        }
        if (!DBIdentifier.isNull((DBIdentifier)sSecondary)) {
            fm.getMappingInfo().setTableIdentifier(sSecondary);
        }
    }

    private static Column newColumn(javax.persistence.Column anno, boolean delimit) {
        Column col = new Column();
        AnnotationPersistenceMappingParser.setupColumn(col, anno, delimit);
        return col;
    }

    private static void setupColumn(Column col, javax.persistence.Column anno, boolean delimit) {
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)anno.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)anno.columnDefinition()));
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
    }

    protected void setColumns(FieldMapping fm, MappingInfo info, List<Column> cols, int unique) {
        Log log;
        info.setColumns(cols);
        if (unique == 1) {
            info.setUnique(new org.apache.openjpa.jdbc.schema.Unique());
        }
        if ((log = this.getLog()).isWarnEnabled() && unique == 3) {
            log.warn((Object)_loc.get("inconsist-col-attrs", (Object)fm));
        }
    }

    private DBIdentifier trackSecondaryTable(FieldMapping fm, DBIdentifier secondary, DBIdentifier colSecondary, int col) {
        if (DBIdentifier.isEmpty((DBIdentifier)colSecondary)) {
            colSecondary = DBIdentifier.NULL;
        }
        if (col == 0) {
            return colSecondary;
        }
        if (!DBIdentifier.equalsIgnoreCase((DBIdentifier)secondary, (DBIdentifier)colSecondary)) {
            throw new MetaDataException(_loc.get("second-inconsist", (Object)fm));
        }
        return secondary;
    }

    private void parseJoinTable(FieldMapping fm, JoinTable join) {
        FieldMappingInfo info = fm.getMappingInfo();
        DBIdentifier joinTbl = this.toTableIdentifier(join.schema(), join.name());
        info.setTableIdentifier(joinTbl);
        this.parseJoinColumns(fm, (MappingInfo)info, false, join.joinColumns());
        this.parseJoinColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), false, join.inverseJoinColumns());
        this.addUniqueConstraints(info.getTableIdentifier().getName(), (MetaDataContext)fm, (MappingInfo)info, join.uniqueConstraints());
    }

    private void parseJoinColumns(FieldMapping fm, MappingInfo info, boolean secondaryAllowed, JoinColumn ... joins) {
        String mappedByIdValue;
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        DBIdentifier sSecondary = DBIdentifier.NULL;
        for (int i = 0; i < joins.length; ++i) {
            Column col = this.newColumn(joins[i]);
            cols.add(col);
            unique |= joins[i].unique() ? 1 : 2;
            DBIdentifier sTable = DBIdentifier.NULL;
            if (info instanceof FieldMappingInfo && secondaryAllowed) {
                sTable = ((FieldMappingInfo)info).getTableIdentifier();
            }
            if (sTable.isNull()) {
                sTable = DBIdentifier.newTable((String)joins[i].table(), (boolean)this.delimit());
            }
            sSecondary = this.trackSecondaryTable(fm, sSecondary, sTable, i);
            if (secondaryAllowed || DBIdentifier.isNull((DBIdentifier)sSecondary)) continue;
            throw new MetaDataException(_loc.get("bad-second", (Object)fm));
        }
        this.setColumns(fm, info, cols, unique);
        if (!DBIdentifier.isNull((DBIdentifier)sSecondary)) {
            fm.getMappingInfo().setTableIdentifier(sSecondary);
        }
        if ((mappedByIdValue = fm.getMappedByIdValue()) != null) {
            FieldMapping[] pks = fm.getDefiningMapping().getPrimaryKeyFieldMappings();
            pks[0].setMapsIdCols(true);
            if (mappedByIdValue.length() == 0) {
                pks[0].getValueInfo().setMapsIdColumns(cols);
            } else {
                FieldMapping fmd;
                ClassMapping embeddedMeta = (ClassMapping)pks[0].getValue().getEmbeddedMetaData();
                if (embeddedMeta != null && (fmd = embeddedMeta.getFieldMapping(mappedByIdValue)) != null) {
                    fmd.getValueInfo().setMapsIdColumns(cols);
                }
            }
        }
    }

    private Column newColumn(JoinColumn join) {
        String refColumnName;
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)(refColumnName = join.referencedColumnName()))) {
            this.setTargetIdentifier(col, refColumnName);
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    protected void setTargetIdentifier(Column col, String refColumnName) {
        if (refColumnName.charAt(0) == '\'') {
            col.setTargetIdentifier(DBIdentifier.newConstant((String)refColumnName));
        } else {
            col.setTargetIdentifier(DBIdentifier.newColumn((String)refColumnName, (boolean)this.delimit()));
        }
    }

    private void parseKeyColumns(FieldMapping fm, KeyColumn ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(pcols.length);
        int unique = 0;
        for (int i = 0; i < pcols.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i], this.delimit()));
            unique |= pcols[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(KeyColumn anno, boolean delimit) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)anno.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)anno.columnDefinition()));
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
        return col;
    }

    private void parsePrimaryKeyJoinColumns(FieldMapping fm, PrimaryKeyJoinColumn ... joins) {
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        for (PrimaryKeyJoinColumn join : joins) {
            cols.add(this.newColumn(join));
        }
        this.setColumns(fm, (MappingInfo)fm.getValueInfo(), cols, 0);
    }

    protected void parseXJoinColumns(FieldMapping fm, MappingInfo info, boolean secondaryAllowed, XJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        DBIdentifier sSecondary = DBIdentifier.NULL;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(this.newColumn(joins[i], this.delimit()));
            unique |= joins[i].unique() ? 1 : 2;
            sSecondary = this.trackSecondaryTable(fm, sSecondary, DBIdentifier.newTable((String)joins[i].table(), (boolean)this.delimit()), i);
            if (secondaryAllowed || DBIdentifier.isNull((DBIdentifier)sSecondary)) continue;
            throw new MetaDataException(_loc.get("bad-second", (Object)fm));
        }
        this.setColumns(fm, info, cols, unique);
        if (!DBIdentifier.isNull((DBIdentifier)sSecondary)) {
            fm.getMappingInfo().setTableIdentifier(sSecondary);
        }
    }

    private Column newColumn(XJoinColumn join, boolean delimit) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            this.setTargetIdentifier(col, join.referencedColumnName());
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private void parseEmbeddedMapping(FieldMapping fm, EmbeddedMapping anno) {
        ClassMapping embed = fm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
        }
        for (MappingOverride over : anno.overrides()) {
            FieldMapping efm = embed.getFieldMapping(over.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)over.name()));
            }
            this.populate(efm, over);
        }
        DBIdentifier nullInd = DBIdentifier.NULL;
        if (!StringUtils.isEmpty((String)anno.nullIndicatorAttributeName())) {
            nullInd = DBIdentifier.newConstant((String)anno.nullIndicatorAttributeName());
        } else if (!StringUtils.isEmpty((String)anno.nullIndicatorColumnName())) {
            nullInd = DBIdentifier.newColumn((String)anno.nullIndicatorColumnName(), (boolean)this.delimit());
        }
        if (DBIdentifier.isNull((DBIdentifier)nullInd)) {
            return;
        }
        ValueMappingInfo info = fm.getValueInfo();
        this.populateNullIndicator(nullInd, info);
    }

    private void parseEmbeddedMapping(ValueMapping vm, DBIdentifier nullIndicatorAttribute, DBIdentifier nullIndicatorColumn, XMappingOverride[] overrides) {
        ClassMapping embed = vm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)vm));
        }
        for (XMappingOverride over : overrides) {
            FieldMapping efm = embed.getFieldMapping(over.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)vm, (Object)over.name()));
            }
            this.populate(efm, over);
        }
        DBIdentifier nullInd = DBIdentifier.NULL;
        if (!DBIdentifier.isEmpty((DBIdentifier)nullIndicatorAttribute)) {
            nullInd = nullIndicatorAttribute;
        } else if (!DBIdentifier.isEmpty((DBIdentifier)nullIndicatorColumn)) {
            nullInd = nullIndicatorColumn;
        }
        if (DBIdentifier.isNull((DBIdentifier)nullInd)) {
            return;
        }
        ValueMappingInfo info = vm.getValueInfo();
        this.populateNullIndicator(nullInd, info);
    }

    private void populateNullIndicator(DBIdentifier nullInd, ValueMappingInfo info) {
        if ("false".equals(nullInd.getName())) {
            info.setCanIndicateNull(false);
        } else {
            Column col = new Column();
            if (!"true".equals(nullInd.getName())) {
                col.setIdentifier(nullInd);
            }
            info.setColumns(Arrays.asList(col));
        }
    }

    protected void parseContainerTable(FieldMapping fm, ContainerTable ctbl) {
        DBIdentifier tblName = this.toTableIdentifier(ctbl.schema(), ctbl.name());
        fm.getMappingInfo().setTableIdentifier(tblName);
        this.parseXJoinColumns(fm, (MappingInfo)fm.getMappingInfo(), false, ctbl.joinColumns());
        if (ctbl.joinForeignKey().specified()) {
            this.parseForeignKey((MappingInfo)fm.getMappingInfo(), ctbl.joinForeignKey());
        }
        if (ctbl.joinIndex().specified()) {
            this.parseIndex((MappingInfo)fm.getMappingInfo(), ctbl.joinIndex());
        }
    }

    protected void parseCollectionTable(FieldMapping fm, CollectionTable ctbl) {
        FieldMappingInfo info = fm.getMappingInfo();
        DBIdentifier tblName = this.toTableIdentifier(ctbl.schema(), ctbl.name());
        info.setTableIdentifier(tblName);
        this.parseJoinColumns(fm, (MappingInfo)fm.getMappingInfo(), false, ctbl.joinColumns());
        this.addUniqueConstraints(info.getTableIdentifier().getName(), (MetaDataContext)fm.getDefiningMetaData(), (MappingInfo)info, ctbl.uniqueConstraints());
    }

    private void parseOrderColumn(FieldMapping fm, OrderColumn order) {
        if (!order.enabled()) {
            fm.getMappingInfo().setCanOrderColumn(false);
            return;
        }
        Column col = new Column();
        if (!StringUtils.isEmpty((String)order.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)order.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)order.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)order.columnDefinition()));
        }
        if (order.precision() != 0) {
            col.setSize(order.precision());
        }
        col.setFlag(2, !order.insertable());
        col.setFlag(4, !order.updatable());
        fm.getMappingInfo().setOrderColumn(col);
    }

    private void parseJavaxOrderColumn(FieldMapping fm, javax.persistence.OrderColumn order) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)order.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)order.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)order.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)order.columnDefinition()));
        }
        col.setNotNull(!order.nullable());
        col.setFlag(2, !order.insertable());
        col.setFlag(4, !order.updatable());
        fm.getMappingInfo().setOrderColumn(col);
    }

    protected void parseElementJoinColumns(FieldMapping fm, ElementJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(this.newColumn(joins[i], this.delimit()));
            unique |= joins[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), cols, unique);
    }

    private Column newColumn(ElementJoinColumn join, boolean delimit) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)delimit));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            this.setTargetIdentifier(col, join.referencedColumnName());
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    protected void parseMapKeyColumn(FieldMapping fm, MapKeyColumn anno) {
        int unique = 0;
        FieldMappingInfo info = fm.getMappingInfo();
        if (anno.table() != null && anno.table().length() > 0) {
            info.setTableIdentifier(DBIdentifier.newTable((String)anno.table(), (boolean)this.delimit()));
        }
        Column col = new Column();
        this.setupMapKeyColumn(fm, col, anno);
        this.setMapKeyColumn(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), col, unique |= anno.unique() ? 1 : 2);
    }

    private void setupMapKeyColumn(FieldMapping fm, Column col, MapKeyColumn anno) {
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)anno.name(), (boolean)this.delimit()));
        } else {
            col.setIdentifier(DBIdentifier.newColumn((String)(fm.getName() + "_" + "KEY"), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)anno.columnDefinition()));
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
    }

    protected void setMapKeyColumn(FieldMapping fm, MappingInfo info, Column col, int unique) {
        ArrayList<Column> cols = new ArrayList<Column>();
        cols.add(col);
        info.setColumns(cols);
        if (unique == 1) {
            info.setUnique(new org.apache.openjpa.jdbc.schema.Unique());
        }
    }

    private void parseMapKeyJoinColumns(FieldMapping fm, MapKeyJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(this.newColumn(joins[i]));
            unique |= joins[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), cols, unique);
    }

    private Column newColumn(MapKeyJoinColumn join) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setIdentifier(DBIdentifier.newColumn((String)join.name(), (boolean)this.delimit()));
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeIdentifier(DBIdentifier.newColumnDefinition((String)join.columnDefinition()));
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            this.setTargetIdentifier(col, join.referencedColumnName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    protected String normalizeSequenceName(String seqName) {
        if (StringUtils.isEmpty((String)seqName)) {
            return seqName;
        }
        return DBIdentifier.newSequence((String)seqName, (boolean)this.delimit()).getName();
    }

    protected String normalizeSchemaName(String schName) {
        if (StringUtils.isEmpty((String)schName)) {
            return schName;
        }
        return DBIdentifier.newSchema((String)schName, (boolean)this.delimit()).getName();
    }

    protected String normalizeCatalogName(String catName) {
        if (StringUtils.isEmpty((String)catName)) {
            return catName;
        }
        return DBIdentifier.newCatalog((String)catName, (boolean)this.delimit()).getName();
    }

    private boolean delimit() {
        return this._dict.getDelimitIdentifiers();
    }

    static {
        _tags.put(AssociationOverride.class, MappingTag.ASSOC_OVERRIDE);
        _tags.put(AssociationOverrides.class, MappingTag.ASSOC_OVERRIDES);
        _tags.put(AttributeOverride.class, MappingTag.ATTR_OVERRIDE);
        _tags.put(AttributeOverrides.class, MappingTag.ATTR_OVERRIDES);
        _tags.put(javax.persistence.Column.class, MappingTag.COL);
        _tags.put(ColumnResult.class, MappingTag.COLUMN_RESULT);
        _tags.put(DiscriminatorColumn.class, MappingTag.DISCRIM_COL);
        _tags.put(DiscriminatorValue.class, MappingTag.DISCRIM_VAL);
        _tags.put(ElementColumn.class, MappingTag.ELEM_COL);
        _tags.put(ElementColumns.class, MappingTag.ELEM_COLS);
        _tags.put(ElementEmbeddedMapping.class, MappingTag.ELEM_EMBEDDED_MAPPING);
        _tags.put(ElementStrategy.class, MappingTag.ELEM_STRAT);
        _tags.put(EntityResult.class, MappingTag.ENTITY_RESULT);
        _tags.put(Enumerated.class, MappingTag.ENUMERATED);
        _tags.put(FieldResult.class, MappingTag.FIELD_RESULT);
        _tags.put(Inheritance.class, MappingTag.INHERITANCE);
        _tags.put(JoinColumn.class, MappingTag.JOIN_COL);
        _tags.put(JoinColumns.class, MappingTag.JOIN_COLS);
        _tags.put(JoinTable.class, MappingTag.JOIN_TABLE);
        _tags.put(KeyColumn.class, MappingTag.KEY_COL);
        _tags.put(KeyColumns.class, MappingTag.KEY_COLS);
        _tags.put(KeyClassCriteria.class, MappingTag.KEY_CLASS_CRIT);
        _tags.put(KeyEmbeddedMapping.class, MappingTag.KEY_EMBEDDED_MAPPING);
        _tags.put(KeyForeignKey.class, MappingTag.KEY_FK);
        _tags.put(KeyIndex.class, MappingTag.KEY_INDEX);
        _tags.put(KeyJoinColumn.class, MappingTag.KEY_JOIN_COL);
        _tags.put(KeyJoinColumns.class, MappingTag.KEY_JOIN_COLS);
        _tags.put(KeyNonpolymorphic.class, MappingTag.KEY_NONPOLY);
        _tags.put(KeyStrategy.class, MappingTag.KEY_STRAT);
        _tags.put(MapKeyColumn.class, MappingTag.MAP_KEY_COL);
        _tags.put(MapKeyEnumerated.class, MappingTag.MAP_KEY_ENUMERATED);
        _tags.put(MapKeyJoinColumn.class, MappingTag.MAP_KEY_JOIN_COL);
        _tags.put(MapKeyJoinColumns.class, MappingTag.MAP_KEY_JOIN_COLS);
        _tags.put(MapKeyTemporal.class, MappingTag.MAP_KEY_TEMPORAL);
        _tags.put(PrimaryKeyJoinColumn.class, MappingTag.PK_JOIN_COL);
        _tags.put(PrimaryKeyJoinColumns.class, MappingTag.PK_JOIN_COLS);
        _tags.put(SecondaryTable.class, MappingTag.SECONDARY_TABLE);
        _tags.put(SecondaryTables.class, MappingTag.SECONDARY_TABLES);
        _tags.put(SqlResultSetMapping.class, MappingTag.SQL_RESULT_SET_MAPPING);
        _tags.put(SqlResultSetMappings.class, MappingTag.SQL_RESULT_SET_MAPPINGS);
        _tags.put(Table.class, MappingTag.TABLE);
        _tags.put(Temporal.class, MappingTag.TEMPORAL);
        _tags.put(TableGenerator.class, MappingTag.TABLE_GEN);
        _tags.put(ClassCriteria.class, MappingTag.CLASS_CRIT);
        _tags.put(Columns.class, MappingTag.COLS);
        _tags.put(ContainerTable.class, MappingTag.CONTAINER_TABLE);
        _tags.put(CollectionTable.class, MappingTag.COLLECTION_TABLE);
        _tags.put(DataStoreIdColumn.class, MappingTag.DATASTORE_ID_COL);
        _tags.put(DiscriminatorStrategy.class, MappingTag.DISCRIM_STRAT);
        _tags.put(EagerFetchMode.class, MappingTag.EAGER_FETCH_MODE);
        _tags.put(ElementClassCriteria.class, MappingTag.ELEM_CLASS_CRIT);
        _tags.put(ElementForeignKey.class, MappingTag.ELEM_FK);
        _tags.put(ElementIndex.class, MappingTag.ELEM_INDEX);
        _tags.put(ElementJoinColumn.class, MappingTag.ELEM_JOIN_COL);
        _tags.put(ElementJoinColumns.class, MappingTag.ELEM_JOIN_COLS);
        _tags.put(ElementNonpolymorphic.class, MappingTag.ELEM_NONPOLY);
        _tags.put(EmbeddedMapping.class, MappingTag.EMBEDDED_MAPPING);
        _tags.put(ForeignKey.class, MappingTag.FK);
        _tags.put(Index.class, MappingTag.INDEX);
        _tags.put(MappingOverride.class, MappingTag.MAPPING_OVERRIDE);
        _tags.put(MappingOverrides.class, MappingTag.MAPPING_OVERRIDES);
        _tags.put(Nonpolymorphic.class, MappingTag.NONPOLY);
        _tags.put(OrderColumn.class, MappingTag.ORDER_COL);
        _tags.put(javax.persistence.OrderColumn.class, MappingTag.ORDER_COLUMN);
        _tags.put(Strategy.class, MappingTag.STRAT);
        _tags.put(SubclassFetchMode.class, MappingTag.SUBCLASS_FETCH_MODE);
        _tags.put(org.apache.openjpa.jdbc.schema.Unique.class, MappingTag.UNIQUE);
        _tags.put(VersionColumn.class, MappingTag.VERSION_COL);
        _tags.put(VersionColumns.class, MappingTag.VERSION_COLS);
        _tags.put(VersionStrategy.class, MappingTag.VERSION_STRAT);
        _tags.put(XEmbeddedMapping.class, MappingTag.X_EMBEDDED_MAPPING);
        _tags.put(XJoinColumn.class, MappingTag.X_JOIN_COL);
        _tags.put(XJoinColumns.class, MappingTag.X_JOIN_COLS);
        _tags.put(XMappingOverride.class, MappingTag.X_MAPPING_OVERRIDE);
        _tags.put(XMappingOverrides.class, MappingTag.X_MAPPING_OVERRIDES);
        _tags.put(XSecondaryTable.class, MappingTag.X_SECONDARY_TABLE);
        _tags.put(XSecondaryTables.class, MappingTag.X_SECONDARY_TABLES);
        _tags.put(XTable.class, MappingTag.X_TABLE);
    }
}

