/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.QueryImpl;

public class HintHandler {
    protected final QueryImpl<?> owner;
    private static final Localizer _loc = Localizer.forPackage(HintHandler.class);
    protected static Set<String> _supportedHints = ProductDerivations.getSupportedQueryHints();
    protected static final String PREFIX_OPENJPA = "openjpa.";
    protected static final String PREFIX_JDBC = "openjpa.jdbc.";
    protected static final String PREFIX_FETCHPLAN = "openjpa.FetchPlan.";
    private Map<String, Object> _hints;

    HintHandler(QueryImpl<?> impl) {
        this.owner = impl;
    }

    protected Boolean record(String hint, Object value) {
        if (hint == null) {
            return Boolean.FALSE;
        }
        if (_supportedHints.contains(hint)) {
            if (this._hints == null) {
                this._hints = new TreeMap<String, Object>();
            }
            this._hints.put(hint, value);
            return Boolean.TRUE;
        }
        if (this.isKnownPrefix(hint)) {
            Log log = this.owner.getDelegate().getBroker().getConfiguration().getLog("openjpa.Runtime");
            String possible = StringDistance.getClosestLevenshteinDistance((String)hint, this.getSupportedHints());
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get("bad-query-hint", (Object)hint, (Object)possible));
            }
            return null;
        }
        return Boolean.FALSE;
    }

    public void setHint(String key, Object value) {
        Boolean status = this.record(key, value);
        if (Boolean.FALSE.equals(status)) {
            return;
        }
        FetchPlan plan = this.owner.getFetchPlan();
        if (status == null) {
            plan.setHint(key, value);
            return;
        }
        ClassLoader loader = this.owner.getDelegate().getBroker().getClassLoader();
        if ("openjpa.Subclasses".equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.owner.setSubclasses((Boolean)value);
        } else if ("openjpa.hint.RelaxParameterTypeChecking".equals(key)) {
            this.owner.setRelaxBindParameterTypeChecking(value);
        } else if ("openjpa.FilterListener".equals(key)) {
            this.owner.addFilterListener(Filters.hintToFilterListener((Object)value, (ClassLoader)loader));
        } else if ("openjpa.FilterListeners".equals(key)) {
            FilterListener[] arr = Filters.hintToFilterListeners((Object)value, (ClassLoader)loader);
            for (int i = 0; i < arr.length; ++i) {
                this.owner.addFilterListener(arr[i]);
            }
        } else if ("openjpa.AggregateListener".equals(key)) {
            this.owner.addAggregateListener(Filters.hintToAggregateListener((Object)value, (ClassLoader)loader));
        } else if ("openjpa.AggregateListeners".equals(key)) {
            AggregateListener[] arr = Filters.hintToAggregateListeners((Object)value, (ClassLoader)loader);
            for (int i = 0; i < arr.length; ++i) {
                this.owner.addAggregateListener(arr[i]);
            }
        } else if ("openjpa.hint.OptimizeResultCount".equals(key)) {
            int v = (Integer)Filters.convert((Object)value, Integer.class);
            if (v < 0) {
                throw new IllegalArgumentException(_loc.get("bad-query-hint-value", (Object)key, value).toString());
            }
            plan.setHint(key, v);
        } else if ("openjpa.hint.InvalidatePreparedQuery".equals(key)) {
            plan.setHint(key, Filters.convert((Object)value, Boolean.class));
            this.owner.invalidatePreparedQuery();
        } else if ("openjpa.hint.IgnorePreparedQuery".equals(key)) {
            plan.setHint(key, Filters.convert((Object)value, Boolean.class));
            this.owner.ignorePreparedQuery();
        } else if ("openjpa.hint.UseLiteralInSQL".equals(key)) {
            Boolean convertedValue = (Boolean)Filters.convert((Object)value, Boolean.class);
            plan.setHint(key, convertedValue);
        } else {
            plan.setHint(key, value);
        }
    }

    protected boolean isKnownPrefix(String key) {
        if (key == null) {
            return false;
        }
        for (String prefix : ProductDerivations.getConfigurationPrefixes()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSupportedHints() {
        return _supportedHints;
    }

    public Map<String, Object> getHints() {
        if (this._hints == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._hints);
    }
}

