/*
 * Decompiled with CFR 0.152.
 */
package opennlp.dl;

import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtSession;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import opennlp.tools.tokenize.Tokenizer;

public abstract class AbstractDL {
    public static final String INPUT_IDS = "input_ids";
    public static final String ATTENTION_MASK = "attention_mask";
    public static final String TOKEN_TYPE_IDS = "token_type_ids";
    protected OrtEnvironment env;
    protected OrtSession session;
    protected Tokenizer tokenizer;
    protected Map<String, Integer> vocab;

    public Map<String, Integer> loadVocab(File vocabFile) throws IOException {
        HashMap<String, Integer> vocab = new HashMap<String, Integer>();
        AtomicInteger counter = new AtomicInteger(0);
        try (Stream<String> lines = Files.lines(Path.of(vocabFile.getPath(), new String[0]));){
            lines.forEach(line -> vocab.put((String)line, counter.getAndIncrement()));
        }
        return vocab;
    }
}

