/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderModel
extends BaseModel {
    private static final String COMPONENT_NAME = "NameFinderME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "nameFinder.model";
    private static final String GENERATOR_DESCRIPTOR_ENTRY_NAME = "generator.featuregen";

    public TokenNameFinderModel(String languageCode, AbstractModel nameFinderModel, byte[] generatorDescriptor, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        if (!TokenNameFinderModel.isModelValid((MaxentModel)nameFinderModel)) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, nameFinderModel);
        if (generatorDescriptor != null && generatorDescriptor.length > 0) {
            this.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, generatorDescriptor);
        }
        if (resources != null) {
            if (resources.containsKey(MAXENT_MODEL_ENTRY_NAME) || resources.containsKey(GENERATOR_DESCRIPTOR_ENTRY_NAME)) {
                throw new IllegalArgumentException();
            }
            this.artifactMap.putAll(resources);
        }
        this.checkArtifactMap();
    }

    public TokenNameFinderModel(String languageCode, AbstractModel nameFinderModel, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        this(languageCode, nameFinderModel, null, resources, manifestInfoEntries);
    }

    public TokenNameFinderModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public TokenNameFinderModel(File modelFile) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelFile);
    }

    public TokenNameFinderModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    public AbstractModel getNameFinderModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        byte[] descriptorBytes = (byte[])this.artifactMap.get(GENERATOR_DESCRIPTOR_ENTRY_NAME);
        if (descriptorBytes != null) {
            ByteArrayInputStream descriptorIn = new ByteArrayInputStream(descriptorBytes);
            AdaptiveFeatureGenerator generator = null;
            try {
                generator = GeneratorFactory.create(descriptorIn, new FeatureGeneratorResourceProvider(){

                    public Object getResource(String key) {
                        return TokenNameFinderModel.this.artifactMap.get(key);
                    }
                });
            }
            catch (InvalidFormatException e) {
                throw new FeatureGeneratorCreationError(e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Reading from mem cannot result in an I/O error", e);
            }
            return generator;
        }
        return null;
    }

    public TokenNameFinderModel updateFeatureGenerator(byte[] descriptor) {
        TokenNameFinderModel model = new TokenNameFinderModel(this.getLanguage(), this.getNameFinderModel(), descriptor, Collections.<String, Object>emptyMap(), Collections.<String, String>emptyMap());
        model.artifactMap.clear();
        model.artifactMap.putAll(this.artifactMap);
        model.artifactMap.put(GENERATOR_DESCRIPTOR_ENTRY_NAME, descriptor);
        return model;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
        serializers.put("featuregen", new ByteArraySerializer());
    }

    public static Map<String, ArtifactSerializer> createArtifactSerializers() {
        Map<String, ArtifactSerializer> serializers = BaseModel.createArtifactSerializers();
        serializers.put("featuregen", new ByteArraySerializer());
        return serializers;
    }

    public static boolean isModelValid(MaxentModel model) {
        ArrayList<String> start = new ArrayList<String>();
        ArrayList<String> cont = new ArrayList<String>();
        for (int i = 0; i < model.getNumOutcomes(); ++i) {
            String outcome = model.getOutcome(i);
            if (outcome.endsWith("start")) {
                start.add(outcome.substring(0, outcome.length() - "start".length()));
                continue;
            }
            if (outcome.endsWith("cont")) {
                cont.add(outcome.substring(0, outcome.length() - "cont".length()));
                continue;
            }
            if (outcome.equals("other")) continue;
            return false;
        }
        if (start.size() == 0) {
            return false;
        }
        for (String contPreffix : cont) {
            if (start.contains(contPreffix)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token Name Finder model is incomplete!");
        }
        AbstractModel model = (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
        TokenNameFinderModel.isModelValid((MaxentModel)model);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteArraySerializer
    implements ArtifactSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        @Override
        public byte[] create(InputStream in) throws IOException, InvalidFormatException {
            return ModelUtil.read(in);
        }

        @Override
        public void serialize(byte[] artifact, OutputStream out) throws IOException {
            out.write(artifact);
        }
    }

    public static class FeatureGeneratorCreationError
    extends RuntimeException {
        FeatureGeneratorCreationError(Throwable t) {
            super(t);
        }
    }
}

