/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;

public class ArgumentParser {
    private static final Map<Class<?>, ArgumentFactory> argumentFactories;

    private ArgumentParser() {
    }

    private static <T> void checkProxyInterfaces(Class<T> ... proxyInterfaces) {
        for (Class<T> proxyInterface : proxyInterfaces) {
            if (null == proxyInterface) continue;
            if (!proxyInterface.isInterface()) {
                throw new IllegalArgumentException("proxy interface is not an interface!");
            }
            Method[] methods = proxyInterface.getMethods();
            if (methods.length == 0) {
                throw new IllegalArgumentException("proxy interface must at least declare one method!");
            }
            for (Method method : methods) {
                if (!method.getName().startsWith("get") && method.getName().length() > 3) {
                    throw new IllegalArgumentException(method.getName() + " method name does not start with 'get'!");
                }
                if (method.getParameterTypes().length != 0) {
                    throw new IllegalArgumentException(method.getName() + " method must have zero parameters but has " + method.getParameterTypes().length + "!");
                }
                Class<?> returnType = method.getReturnType();
                Set<Class<?>> compatibleReturnTypes = argumentFactories.keySet();
                if (compatibleReturnTypes.contains(returnType)) continue;
                throw new IllegalArgumentException(method.getName() + " method must have compatible return type! Got " + returnType + ", expected one of " + compatibleReturnTypes);
            }
        }
    }

    private static String methodNameToParameter(String methodName) {
        char[] parameterNameChars = methodName.toCharArray();
        parameterNameChars[3] = Character.toLowerCase(parameterNameChars[3]);
        return "-" + new String(parameterNameChars).substring(3);
    }

    public static <T> String createUsage(Class<T> argProxyInterface) {
        return ArgumentParser.createUsage(new Class[]{argProxyInterface});
    }

    public static <T> List<Argument> createArguments(Class<T> ... argProxyInterfaces) {
        ArgumentParser.checkProxyInterfaces(argProxyInterfaces);
        HashSet<String> duplicateFilter = new HashSet<String>();
        LinkedList<Argument> arguments = new LinkedList<Argument>();
        for (Class<T> argProxyInterface : argProxyInterfaces) {
            if (null == argProxyInterface) continue;
            for (Method method : argProxyInterface.getMethods()) {
                String paramName;
                ParameterDescription desc = method.getAnnotation(ParameterDescription.class);
                OptionalParameter optional = method.getAnnotation(OptionalParameter.class);
                if (desc == null || duplicateFilter.contains(paramName = ArgumentParser.methodNameToParameter(method.getName()))) continue;
                duplicateFilter.add(paramName);
                boolean isOptional = false;
                if (optional != null) {
                    isOptional = true;
                }
                Argument arg = new Argument(paramName.substring(1), desc.valueName(), desc.description(), isOptional);
                arguments.add(arg);
            }
        }
        return arguments;
    }

    public static <T> String createUsage(Class<T> ... argProxyInterfaces) {
        ArgumentParser.checkProxyInterfaces(argProxyInterfaces);
        HashSet<String> duplicateFilter = new HashSet<String>();
        StringBuilder usage = new StringBuilder();
        StringBuilder details = new StringBuilder();
        for (Class<T> argProxyInterface : argProxyInterfaces) {
            if (null == argProxyInterface) continue;
            for (Method method : argProxyInterface.getMethods()) {
                String paramName;
                ParameterDescription desc = method.getAnnotation(ParameterDescription.class);
                OptionalParameter optional = method.getAnnotation(OptionalParameter.class);
                if (desc == null || duplicateFilter.contains(paramName = ArgumentParser.methodNameToParameter(method.getName()))) continue;
                duplicateFilter.add(paramName);
                if (optional != null) {
                    usage.append('[');
                }
                usage.append(paramName).append(' ').append(desc.valueName());
                details.append('\t').append(paramName).append(' ').append(desc.valueName()).append('\n');
                if (desc.description().length() > 0) {
                    details.append("\t\t").append(desc.description()).append('\n');
                }
                if (optional != null) {
                    usage.append(']');
                }
                usage.append(' ');
            }
        }
        if (usage.length() > 0) {
            usage.setLength(usage.length() - 1);
        }
        if (details.length() > 0) {
            details.setLength(details.length() - 1);
            usage.append("\n\nArguments description:\n").append(details.toString());
        }
        return usage.toString();
    }

    public static <T> boolean validateArguments(String[] args, Class<T> argProxyInterface) {
        return ArgumentParser.validateArguments(args, new Class[]{argProxyInterface});
    }

    public static <T> boolean validateArguments(String[] args, Class<T> ... argProxyInterfaces) {
        return null == ArgumentParser.validateArgumentsLoudly(args, argProxyInterfaces);
    }

    public static <T> String validateArgumentsLoudly(String[] args, Class<T> argProxyInterface) {
        return ArgumentParser.validateArgumentsLoudly(args, new Class[]{argProxyInterface});
    }

    public static <T> String validateArgumentsLoudly(String[] args, Class<T> ... argProxyInterfaces) {
        if (args.length % 2 != 0) {
            return "Number of parameters must be always be even";
        }
        int argumentCount = 0;
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        for (Class<T> argProxyInterface : argProxyInterfaces) {
            for (Method method : argProxyInterface.getMethods()) {
                String paramName = ArgumentParser.methodNameToParameter(method.getName());
                int paramIndex = CmdLineUtil.getParameterIndex(paramName, args);
                String valueString = CmdLineUtil.getParameter(paramName, args);
                if (valueString == null) {
                    OptionalParameter optionalParam = method.getAnnotation(OptionalParameter.class);
                    if (optionalParam == null) {
                        if (-1 < paramIndex) {
                            return "Missing mandatory parameter value: " + paramName;
                        }
                        return "Missing mandatory parameter: " + paramName;
                    }
                    parameters.remove("-" + paramName);
                    continue;
                }
                parameters.remove(paramName);
                parameters.remove(valueString);
                ++argumentCount;
            }
        }
        if (args.length / 2 > argumentCount) {
            return "Unrecognized parameters encountered: " + ((Object)parameters).toString();
        }
        return null;
    }

    public static <T> T parse(String[] args, Class<T> argProxyInterface) {
        ArgumentParser.checkProxyInterfaces(argProxyInterface);
        if (!ArgumentParser.validateArguments(args, argProxyInterface)) {
            throw new IllegalArgumentException("Passed args must be valid!");
        }
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (Method method : argProxyInterface.getMethods()) {
            Object value;
            String parameterName = ArgumentParser.methodNameToParameter(method.getName());
            String valueString = CmdLineUtil.getParameter(parameterName, args);
            if (valueString == null) {
                OptionalParameter optionalParam = method.getAnnotation(OptionalParameter.class);
                valueString = optionalParam.defaultValue().length() > 0 ? optionalParam.defaultValue() : null;
            }
            Class<?> returnType = method.getReturnType();
            if (valueString != null) {
                ArgumentFactory factory = argumentFactories.get(returnType);
                if (factory == null) {
                    throw new IllegalStateException("factory for '" + returnType + "' must not be null");
                }
                value = factory.parseArgument(method, parameterName, valueString);
            } else {
                value = null;
            }
            arguments.put(method.getName(), value);
        }
        return (T)Proxy.newProxyInstance(argProxyInterface.getClassLoader(), new Class[]{argProxyInterface}, (InvocationHandler)new ArgumentProxy(arguments));
    }

    public static <T> String[] filter(String[] args, Class<T> argProxyInterface) {
        ArrayList<String> parameters = new ArrayList<String>(args.length);
        for (Method method : argProxyInterface.getMethods()) {
            String parameterName = ArgumentParser.methodNameToParameter(method.getName());
            int idx = CmdLineUtil.getParameterIndex(parameterName, args);
            if (-1 >= idx) continue;
            parameters.add(parameterName);
            String valueString = CmdLineUtil.getParameter(parameterName, args);
            if (null == valueString) continue;
            parameters.add(valueString);
        }
        return parameters.toArray(new String[parameters.size()]);
    }

    static {
        HashMap<Class<Charset>, ArgumentFactory> factories = new HashMap<Class<Charset>, ArgumentFactory>();
        factories.put(Integer.class, new IntegerArgumentFactory());
        factories.put(Boolean.class, new BooleanArgumentFactory());
        factories.put(String.class, new StringArgumentFactory());
        factories.put(File.class, new FileArgumentFactory());
        factories.put(Charset.class, new CharsetArgumentFactory());
        argumentFactories = Collections.unmodifiableMap(factories);
    }

    static class Argument {
        private final String argument;
        private final String value;
        private final String description;
        private final boolean optional;

        public Argument(String argument, String value, String description, boolean optional) {
            this.argument = argument;
            this.value = value;
            this.description = description;
            this.optional = optional;
        }

        public String getArgument() {
            return this.argument;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getOptional() {
            return this.optional;
        }
    }

    private static class ArgumentProxy
    implements InvocationHandler {
        private final Map<String, Object> arguments;

        ArgumentProxy(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args != null) {
                throw new IllegalStateException();
            }
            return this.arguments.get(method.getName());
        }
    }

    private static class CharsetArgumentFactory
    implements ArgumentFactory {
        private CharsetArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String argName, String charsetName) {
            try {
                if ("DEFAULT_CHARSET".equals(charsetName)) {
                    return Charset.defaultCharset();
                }
                if (Charset.isSupported(charsetName)) {
                    return Charset.forName(charsetName);
                }
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", argName, charsetName) + "Encoding not supported on this platform.");
            }
            catch (IllegalCharsetNameException e) {
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", argName, charsetName) + "Illegal encoding name.");
            }
        }
    }

    private static class FileArgumentFactory
    implements ArgumentFactory {
        private FileArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String argName, String argValue) {
            return new File(argValue);
        }
    }

    private static class StringArgumentFactory
    implements ArgumentFactory {
        private StringArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String argName, String argValue) {
            return argValue;
        }
    }

    private static class BooleanArgumentFactory
    implements ArgumentFactory {
        private BooleanArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String argName, String argValue) {
            return Boolean.parseBoolean(argValue);
        }
    }

    private static class IntegerArgumentFactory
    implements ArgumentFactory {
        private IntegerArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String argName, String argValue) {
            Integer value;
            try {
                value = Integer.parseInt(argValue);
            }
            catch (NumberFormatException e) {
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", argName, argValue) + "Value must be an integer!", e);
            }
            return value;
        }
    }

    private static interface ArgumentFactory {
        public static final String INVALID_ARG = "Invalid argument: %s %s \n";

        public Object parseArgument(Method var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParameterDescription {
        public String valueName();

        public String description() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OptionalParameter {
        public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";

        public String defaultValue() default "";
    }
}

