/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import opennlp.tools.ml.maxent.io.PlainTextGISModelReader;
import opennlp.tools.ml.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.ml.model.Context;

public class OldFormatGISModelReader
extends PlainTextGISModelReader {
    private DataInputStream paramsInput;

    public OldFormatGISModelReader(String modelname) throws IOException {
        super(new File(modelname + ".mei.gz"));
        this.paramsInput = new DataInputStream(new GZIPInputStream(new FileInputStream(modelname + ".mep.gz")));
    }

    @Override
    protected Context[] getParameters(int[][] outcomePatterns) throws IOException {
        Context[] params = new Context[this.NUM_PREDS];
        int pid = 0;
        for (int i = 0; i < outcomePatterns.length; ++i) {
            int[] outcomePattern = new int[outcomePatterns[i].length - 1];
            System.arraycopy(outcomePatterns[i], 1, outcomePattern, 0, outcomePatterns[i].length - 1);
            for (int j = 0; j < outcomePatterns[i][0]; ++j) {
                double[] contextParameters = new double[outcomePatterns[i].length - 1];
                for (int k = 1; k < outcomePatterns[i].length; ++k) {
                    contextParameters[k - 1] = this.readDouble();
                }
                params[pid] = new Context(outcomePattern, contextParameters);
                ++pid;
            }
        }
        return params;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Usage: java opennlp.tools.ml.maxent.io.OldFormatGISModelReader model_name_prefix (new_model_name)");
            System.exit(0);
        }
        int nameIndex = 0;
        String infilePrefix = args[nameIndex];
        String outfile = args.length > nameIndex ? args[nameIndex + 1] : infilePrefix + ".bin.gz";
        OldFormatGISModelReader reader = new OldFormatGISModelReader(infilePrefix);
        new SuffixSensitiveGISModelWriter(reader.getModel(), new File(outfile)).persist();
    }
}

