/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.doccat.DoccatEvaluationErrorListener;
import opennlp.tools.cmdline.doccat.DoccatFineGrainedReportListener;
import opennlp.tools.cmdline.doccat.DoccatTrainerTool;
import opennlp.tools.cmdline.doccat.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.doccat.DoccatCrossValidator;
import opennlp.tools.doccat.DoccatEvaluationMonitor;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.model.ModelUtil;

public final class DoccatCrossValidatorTool
extends AbstractCrossValidatorTool<DocumentSample, CVToolParams> {
    public DoccatCrossValidatorTool() {
        super(DocumentSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Document Categorizer";
    }

    @Override
    public void run(String format, String[] args) {
        DoccatCrossValidator validator;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        LinkedList<DoccatEvaluationMonitor> listeners = new LinkedList<DoccatEvaluationMonitor>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new DoccatEvaluationErrorListener());
        }
        DoccatFineGrainedReportListener reportListener = null;
        File reportFile = ((CVToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new DoccatFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw this.createTerminationIOException(e);
            }
        }
        FeatureGenerator[] featureGenerators = DoccatTrainerTool.createFeatureGenerators(((CVToolParams)this.params).getFeatureGenerators());
        Tokenizer tokenizer = DoccatTrainerTool.createTokenizer(((CVToolParams)this.params).getTokenizer());
        DoccatEvaluationMonitor[] listenersArr = listeners.toArray(new DoccatEvaluationMonitor[listeners.size()]);
        try {
            DoccatFactory factory = DoccatFactory.create(((CVToolParams)this.params).getFactory(), tokenizer, featureGenerators);
            validator = new DoccatCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, factory, listenersArr);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("done");
        if (reportListener != null) {
            System.out.println("Writing fine-grained report to " + ((CVToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println();
        System.out.println("Accuracy: " + validator.getDocumentAccuracy() + "\n" + "Number of documents: " + validator.getDocumentCount());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
        @ArgumentParser.ParameterDescription(valueName="outputFile", description="the path of the fine-grained report file.")
        @ArgumentParser.OptionalParameter
        public File getReportOutputFile();
    }
}

