/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import opennlp.tools.ml.AbstractEventTrainer;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.maxent.GISTrainer;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.UniformPrior;
import opennlp.tools.util.ObjectStream;

public class GIS
extends AbstractEventTrainer {
    public static final String MAXENT_VALUE = "MAXENT";
    public static boolean PRINT_MESSAGES = true;
    private static final double SMOOTHING_OBSERVATION = 0.1;
    private static final String SMOOTHING_PARAM = "smoothing";
    private static final boolean SMOOTHING_DEFAULT = false;

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String algorithmName = this.getAlgorithm();
        return algorithmName == null || MAXENT_VALUE.equals(algorithmName);
    }

    @Override
    public boolean isSortAndMerge() {
        return true;
    }

    @Override
    public AbstractModel doTrain(DataIndexer indexer) throws IOException {
        int iterations = this.getIterations();
        boolean printMessages = this.trainingParameters.getBooleanParameter("PrintMessages", true);
        boolean smoothing = this.trainingParameters.getBooleanParameter(SMOOTHING_PARAM, false);
        int threads = this.trainingParameters.getIntParameter("Threads", 1);
        GISModel model = GIS.trainModel(iterations, indexer, printMessages, smoothing, null, threads);
        return model;
    }

    public static GISModel trainModel(ObjectStream<Event> eventStream) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(ObjectStream<Event> eventStream, boolean smoothing) throws IOException {
        return GIS.trainModel(eventStream, 100, 0, smoothing, PRINT_MESSAGES);
    }

    public static GISModel trainModel(ObjectStream<Event> eventStream, int iterations, int cutoff) throws IOException {
        return GIS.trainModel(eventStream, iterations, cutoff, false, PRINT_MESSAGES);
    }

    public static GISModel trainModel(ObjectStream<Event> eventStream, int iterations, int cutoff, boolean smoothing, boolean printMessagesWhileTraining) throws IOException {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(0.1);
        return trainer.trainModel(eventStream, iterations, cutoff);
    }

    public static GISModel trainModel(ObjectStream<Event> eventStream, int iterations, int cutoff, double sigma) throws IOException {
        GISTrainer trainer = new GISTrainer(PRINT_MESSAGES);
        if (sigma > 0.0) {
            trainer.setGaussianSigma(sigma);
        }
        return trainer.trainModel(eventStream, iterations, cutoff);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean smoothing) {
        return GIS.trainModel(iterations, indexer, true, smoothing, null, 1);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer) {
        return GIS.trainModel(iterations, indexer, true, false, null, 1);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, Prior modelPrior, int cutoff) {
        return GIS.trainModel(iterations, indexer, true, false, modelPrior, cutoff);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean printMessagesWhileTraining, boolean smoothing, Prior modelPrior) {
        return GIS.trainModel(iterations, indexer, printMessagesWhileTraining, smoothing, modelPrior, 1);
    }

    public static GISModel trainModel(int iterations, DataIndexer indexer, boolean printMessagesWhileTraining, boolean smoothing, Prior modelPrior, int threads) {
        GISTrainer trainer = new GISTrainer(printMessagesWhileTraining);
        trainer.setSmoothing(smoothing);
        trainer.setSmoothingObservation(0.1);
        if (modelPrior == null) {
            modelPrior = new UniformPrior();
        }
        return trainer.trainModel(iterations, indexer, modelPrior, threads);
    }
}

