/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelWriter;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;

public abstract class GISModelWriter
extends AbstractModelWriter {
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected int CORRECTION_CONSTANT;
    protected double CORRECTION_PARAM;
    protected String[] PRED_LABELS;

    public GISModelWriter(AbstractModel model) {
        Object[] data = model.getDataStructures();
        this.PARAMS = (Context[])data[0];
        Map pmap = (Map)data[1];
        this.OUTCOME_LABELS = (String[])data[2];
        this.CORRECTION_CONSTANT = (Integer)data[3];
        this.CORRECTION_PARAM = (Double)data[4];
        this.PRED_LABELS = new String[pmap.size()];
        Iterator iterator = pmap.keySet().iterator();
        while (iterator.hasNext()) {
            String pred;
            this.PRED_LABELS[((Integer)pmap.get((Object)pred)).intValue()] = pred = (String)iterator.next();
        }
    }

    @Override
    public void persist() throws IOException {
        int i;
        this.writeUTF("GIS");
        this.writeInt(this.CORRECTION_CONSTANT);
        this.writeDouble(this.CORRECTION_PARAM);
        this.writeInt(this.OUTCOME_LABELS.length);
        for (int i2 = 0; i2 < this.OUTCOME_LABELS.length; ++i2) {
            this.writeUTF(this.OUTCOME_LABELS[i2]);
        }
        ComparablePredicate[] sorted = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.compressOutcomes(sorted);
        this.writeInt(compressed.size());
        for (i = 0; i < compressed.size(); ++i) {
            List<ComparablePredicate> a = compressed.get(i);
            this.writeUTF(a.size() + ((Object)a.get(0)).toString());
        }
        this.writeInt(this.PARAMS.length);
        for (i = 0; i < sorted.length; ++i) {
            this.writeUTF(sorted[i].name);
        }
        for (i = 0; i < sorted.length; ++i) {
            for (int j = 0; j < sorted[i].params.length; ++j) {
                this.writeDouble(sorted[i].params[j]);
            }
        }
        this.close();
    }

    protected ComparablePredicate[] sortValues() {
        Object[] sortPreds = new ComparablePredicate[this.PARAMS.length];
        int numParams = 0;
        for (int pid = 0; pid < this.PARAMS.length; ++pid) {
            int[] predkeys = this.PARAMS[pid].getOutcomes();
            int numActive = predkeys.length;
            double[] activeParams = this.PARAMS[pid].getParameters();
            numParams += numActive;
            sortPreds[pid] = new ComparablePredicate(this.PRED_LABELS[pid], predkeys, activeParams);
        }
        Arrays.sort(sortPreds);
        return sortPreds;
    }

    protected List<List<ComparablePredicate>> compressOutcomes(ComparablePredicate[] sorted) {
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        if (sorted.length > 0) {
            ComparablePredicate cp = sorted[0];
            ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
            for (int i = 0; i < sorted.length; ++i) {
                if (cp.compareTo(sorted[i]) == 0) {
                    newGroup.add(sorted[i]);
                    continue;
                }
                cp = sorted[i];
                outcomePatterns.add(newGroup);
                newGroup = new ArrayList();
                newGroup.add(sorted[i]);
            }
            outcomePatterns.add(newGroup);
        }
        return outcomePatterns;
    }
}

