/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.dictionary.serializer.Attributes;
import opennlp.tools.dictionary.serializer.DictionarySerializer;
import opennlp.tools.dictionary.serializer.Entry;
import opennlp.tools.postag.MutableTagDictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;

public class POSDictionary
implements Iterable<String>,
MutableTagDictionary {
    private Map<String, String[]> dictionary = new HashMap<String, String[]>();
    private boolean caseSensitive = true;

    public POSDictionary() {
        this(true);
    }

    public POSDictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String[] getTags(String word) {
        if (this.caseSensitive) {
            return this.dictionary.get(word);
        }
        return this.dictionary.get(StringUtil.toLowerCase(word));
    }

    void addTags(String word, String ... tags) {
        this.put(word, tags);
    }

    @Override
    public Iterator<String> iterator() {
        return this.dictionary.keySet().iterator();
    }

    private static String tagsToString(String[] tags) {
        StringBuilder tagString = new StringBuilder();
        for (String tag : tags) {
            tagString.append(tag);
            tagString.append(' ');
        }
        if (tagString.length() > 0) {
            tagString.setLength(tagString.length() - 1);
        }
        return tagString.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        Iterator<Entry> entries = new Iterator<Entry>(){
            Iterator<String> iterator;
            {
                this.iterator = POSDictionary.this.dictionary.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Entry next() {
                String word = this.iterator.next();
                Attributes tagAttribute = new Attributes();
                tagAttribute.setValue("tags", POSDictionary.tagsToString(POSDictionary.this.getTags(word)));
                return new Entry(new StringList(word), tagAttribute);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        DictionarySerializer.serialize(out, entries, this.caseSensitive);
    }

    public int hashCode() {
        int[] keyHashes = new int[this.dictionary.size()];
        int[] valueHashes = new int[this.dictionary.size()];
        int i = 0;
        for (String word : this) {
            keyHashes[i] = word.hashCode();
            valueHashes[i] = Arrays.hashCode(this.getTags(word));
            ++i;
        }
        Arrays.sort(keyHashes);
        Arrays.sort(valueHashes);
        return Objects.hash(Arrays.hashCode(keyHashes), Arrays.hashCode(valueHashes));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof POSDictionary) {
            POSDictionary posDictionary = (POSDictionary)obj;
            if (this.dictionary.size() == posDictionary.dictionary.size()) {
                for (String word : this) {
                    if (Arrays.equals(this.getTags(word), posDictionary.getTags(word))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "POSDictionary{size=" + this.dictionary.size() + ", caseSensitive=" + this.caseSensitive + "}";
    }

    public static POSDictionary create(InputStream in) throws IOException {
        boolean isCaseSensitive;
        POSDictionary newPosDict = new POSDictionary();
        newPosDict.caseSensitive = isCaseSensitive = DictionarySerializer.create(in, entry -> {
            String tagString = entry.getAttributes().getValue("tags");
            String[] tags = tagString.split(" ");
            StringList word = entry.getTokens();
            if (word.size() != 1) {
                throw new InvalidFormatException("Each entry must have exactly one token! " + word);
            }
            pOSDictionary.dictionary.put(word.getToken(0), tags);
        });
        if (!isCaseSensitive) {
            HashMap<String, String[]> lowerCasedDictionary = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> entry2 : newPosDict.dictionary.entrySet()) {
                lowerCasedDictionary.put(StringUtil.toLowerCase(entry2.getKey()), entry2.getValue());
            }
            newPosDict.dictionary = lowerCasedDictionary;
        }
        return newPosDict;
    }

    @Override
    public String[] put(String word, String ... tags) {
        if (this.caseSensitive) {
            return this.dictionary.put(word, tags);
        }
        return this.dictionary.put(StringUtil.toLowerCase(word), tags);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

