/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;

public class ConlluStream
implements ObjectStream<ConlluSentence> {
    private final ObjectStream<String> sentenceStream;

    public ConlluStream(InputStreamFactory in) throws IOException {
        this.sentenceStream = new ParagraphStream(new PlainTextByLineStream(in, StandardCharsets.UTF_8));
    }

    @Override
    public ConlluSentence read() throws IOException {
        String sentence = this.sentenceStream.read();
        if (sentence != null) {
            String line;
            ArrayList<ConlluWordLine> wordLines = new ArrayList<ConlluWordLine>();
            BufferedReader reader = new BufferedReader(new StringReader(sentence));
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                wordLines.add(new ConlluWordLine(line));
            }
            return new ConlluSentence(wordLines);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.sentenceStream.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.sentenceStream.reset();
    }
}

