/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.util.InvalidFormatException;

public class ConlluWordLine {
    private final String id;
    private final String form;
    private final String lemma;
    private final String uPosTag;
    private final String xPosTag;
    private final String feats;
    private final String head;
    private final String deprel;
    private final String deps;
    private final String misc;

    ConlluWordLine(String line) throws InvalidFormatException {
        String[] fields = line.split("\t");
        if (fields.length != 10) {
            throw new InvalidFormatException("Line must have exactly 10 fields");
        }
        this.id = fields[0];
        this.form = fields[1];
        this.lemma = fields[2];
        this.uPosTag = fields[3];
        this.xPosTag = fields[4];
        this.feats = fields[5];
        this.head = fields[6];
        this.deprel = fields[7];
        this.deps = fields[8];
        this.misc = fields[9];
    }

    public String getId() {
        return this.id;
    }

    public String getForm() {
        return this.form;
    }

    public String getLemma() {
        return this.lemma;
    }

    public String getPosTag(ConlluTagset tagset) {
        switch (tagset) {
            case U: {
                return this.uPosTag;
            }
            case X: {
                return this.xPosTag;
            }
        }
        throw new IllegalStateException("Unexpected tagset value: " + (Object)((Object)tagset));
    }

    public String getFeats() {
        return this.feats;
    }

    public String getHead() {
        return this.head;
    }

    public String getDeprel() {
        return this.deprel;
    }

    public String getDeps() {
        return this.deps;
    }

    public String getMisc() {
        return this.misc;
    }
}

