/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.Prior;
import opennlp.tools.ml.model.UniformPrior;

public final class GISModel
extends AbstractModel {
    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        this(params, predLabels, outcomeNames, new UniformPrior());
    }

    public GISModel(Context[] params, String[] predLabels, String[] outcomeNames, Prior prior) {
        super(params, predLabels, outcomeNames);
        this.prior = prior;
        prior.setLabels(outcomeNames, predLabels);
        this.modelType = AbstractModel.ModelType.Maxent;
    }

    @Override
    public final double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public final double[] eval(String[] context, double[] outsums) {
        return this.eval(context, null, outsums);
    }

    public final double[] eval(String[] context, float[] values, double[] outsums) {
        int[] scontexts = new int[context.length];
        for (int i = 0; i < context.length; ++i) {
            Integer ci = (Integer)this.pmap.get(context[i]);
            scontexts[i] = ci == null ? -1 : ci;
        }
        this.prior.logPrior(outsums, scontexts, values);
        return GISModel.eval(scontexts, values, outsums, this.evalParams);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return GISModel.eval(context, null, prior, model);
    }

    @Deprecated
    public static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model) {
        int oid;
        Context[] params = model.getParams();
        int[] numfeats = new int[model.getNumOutcomes()];
        double value = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] < 0) continue;
            Context predParams = params[context[ci]];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values != null) {
                value = values[ci];
            }
            for (int ai = 0; ai < activeOutcomes.length; ++ai) {
                int oid2;
                int n = oid2 = activeOutcomes[ai];
                numfeats[n] = numfeats[n] + 1;
                int n2 = oid2;
                prior[n2] = prior[n2] + activeParameters[ai] * value;
            }
        }
        double normal = 0.0;
        for (oid = 0; oid < model.getNumOutcomes(); ++oid) {
            prior[oid] = Math.exp(prior[oid]);
            normal += prior[oid];
        }
        oid = 0;
        while (oid < model.getNumOutcomes()) {
            int n = oid++;
            prior[n] = prior[n] / normal;
        }
        return prior;
    }
}

