/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.Prior;

public abstract class AbstractModel
implements MaxentModel {
    protected Map<String, Integer> pmap;
    protected String[] outcomeNames;
    protected EvalParameters evalParams;
    protected Prior prior;
    protected ModelType modelType;

    @Deprecated
    public AbstractModel(Context[] params, String[] predLabels, Map<String, Integer> pmap, String[] outcomeNames) {
        this.pmap = pmap;
        this.outcomeNames = outcomeNames;
        this.evalParams = new EvalParameters(params, outcomeNames.length);
    }

    public AbstractModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        this.init(predLabels, outcomeNames);
        this.evalParams = new EvalParameters(params, outcomeNames.length);
    }

    private void init(String[] predLabels, String[] outcomeNames) {
        this.pmap = new HashMap<String, Integer>(predLabels.length);
        for (int i = 0; i < predLabels.length; ++i) {
            this.pmap.put(predLabels[i], i);
        }
        this.outcomeNames = outcomeNames;
    }

    @Override
    public final String getBestOutcome(double[] ocs) {
        int best = 0;
        for (int i = 1; i < ocs.length; ++i) {
            if (!(ocs[i] > ocs[best])) continue;
            best = i;
        }
        return this.outcomeNames[best];
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public final String getAllOutcomes(double[] ocs) {
        if (ocs.length != this.outcomeNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        StringBuilder sb = new StringBuilder(ocs.length * 2);
        sb.append(this.outcomeNames[0]).append("[").append(df.format(ocs[0])).append("]");
        for (int i = 1; i < ocs.length; ++i) {
            sb.append("  ").append(this.outcomeNames[i]).append("[").append(df.format(ocs[i])).append("]");
        }
        return sb.toString();
    }

    @Override
    public final String getOutcome(int i) {
        return this.outcomeNames[i];
    }

    @Override
    public int getIndex(String outcome) {
        for (int i = 0; i < this.outcomeNames.length; ++i) {
            if (!this.outcomeNames[i].equals(outcome)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumOutcomes() {
        return this.evalParams.getNumOutcomes();
    }

    public final Object[] getDataStructures() {
        Object[] data = new Object[]{this.evalParams.getParams(), this.pmap, this.outcomeNames};
        return data;
    }

    public int hashCode() {
        return Objects.hash(this.pmap, Arrays.hashCode(this.outcomeNames), this.evalParams, this.prior);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractModel) {
            AbstractModel model = (AbstractModel)obj;
            return this.pmap.equals(model.pmap) && Objects.deepEquals(this.outcomeNames, model.outcomeNames) && this.evalParams.equals(model.evalParams) && Objects.equals(this.prior, model.prior);
        }
        return false;
    }

    public static enum ModelType {
        Maxent,
        Perceptron,
        MaxentQn,
        NaiveBayes;

    }
}

