/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.Arrays;
import java.util.Map;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.EvalParameters;
import opennlp.tools.ml.naivebayes.LogProbabilities;
import opennlp.tools.ml.naivebayes.NaiveBayesEvalParameters;
import opennlp.tools.ml.naivebayes.Probabilities;

public class NaiveBayesModel
extends AbstractModel {
    protected double[] outcomeTotals;
    protected long vocabulary;

    @Deprecated
    public NaiveBayesModel(Context[] params, String[] predLabels, Map<String, Integer> pmap, String[] outcomeNames) {
        super(params, predLabels, pmap, outcomeNames);
        this.outcomeTotals = this.initOutcomeTotals(outcomeNames, params);
        this.evalParams = new NaiveBayesEvalParameters(params, outcomeNames.length, this.outcomeTotals, predLabels.length);
        this.modelType = AbstractModel.ModelType.NaiveBayes;
    }

    public NaiveBayesModel(Context[] params, String[] predLabels, String[] outcomeNames) {
        super(params, predLabels, outcomeNames);
        this.outcomeTotals = this.initOutcomeTotals(outcomeNames, params);
        this.evalParams = new NaiveBayesEvalParameters(params, outcomeNames.length, this.outcomeTotals, predLabels.length);
        this.modelType = AbstractModel.ModelType.NaiveBayes;
    }

    protected double[] initOutcomeTotals(String[] outcomeNames, Context[] params) {
        double[] outcomeTotals = new double[outcomeNames.length];
        for (int i = 0; i < params.length; ++i) {
            Context context = params[i];
            for (int j = 0; j < context.getOutcomes().length; ++j) {
                int outcome = context.getOutcomes()[j];
                double count = context.getParameters()[j];
                int n = outcome;
                outcomeTotals[n] = outcomeTotals[n] + count;
            }
        }
        return outcomeTotals;
    }

    @Override
    public double[] eval(String[] context) {
        return this.eval(context, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, float[] values) {
        return this.eval(context, values, new double[this.evalParams.getNumOutcomes()]);
    }

    @Override
    public double[] eval(String[] context, double[] probs) {
        return this.eval(context, null, probs);
    }

    public double[] eval(String[] context, float[] values, double[] outsums) {
        int[] scontexts = new int[context.length];
        Arrays.fill(outsums, 0.0);
        for (int i = 0; i < context.length; ++i) {
            Integer ci = (Integer)this.pmap.get(context[i]);
            scontexts[i] = ci == null ? -1 : ci;
        }
        return NaiveBayesModel.eval(scontexts, values, outsums, this.evalParams, true);
    }

    public static double[] eval(int[] context, double[] prior, EvalParameters model) {
        return NaiveBayesModel.eval(context, null, prior, model, true);
    }

    @Deprecated
    public static double[] eval(int[] context, float[] values, double[] prior, EvalParameters model, boolean normalize) {
        int i;
        LogProbabilities<Integer> probabilities = new LogProbabilities<Integer>();
        Context[] params = model.getParams();
        double[] outcomeTotals = model instanceof NaiveBayesEvalParameters ? ((NaiveBayesEvalParameters)model).getOutcomeTotals() : new double[prior.length];
        long vocabulary = model instanceof NaiveBayesEvalParameters ? ((NaiveBayesEvalParameters)model).getVocabulary() : 0L;
        double value = 1.0;
        for (int ci = 0; ci < context.length; ++ci) {
            if (context[ci] < 0) continue;
            Context predParams = params[context[ci]];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            if (values != null) {
                value = values[ci];
            }
            int ai = 0;
            for (int i2 = 0; i2 < outcomeTotals.length && ai < activeOutcomes.length; ++i2) {
                int oid = activeOutcomes[ai];
                double numerator = oid == i2 ? activeParameters[ai++] * value : 0.0;
                double denominator = outcomeTotals[i2];
                ((Probabilities)probabilities).addIn(i2, NaiveBayesModel.getProbability(numerator, denominator, vocabulary, true), 1);
            }
        }
        double total = 0.0;
        for (i = 0; i < outcomeTotals.length; ++i) {
            total += outcomeTotals[i];
        }
        for (i = 0; i < outcomeTotals.length; ++i) {
            double numerator = outcomeTotals[i];
            ((Probabilities)probabilities).addIn(i, numerator / total, 1);
        }
        for (i = 0; i < outcomeTotals.length; ++i) {
            prior[i] = ((Probabilities)probabilities).get(i);
        }
        return prior;
    }

    private static double getProbability(double numerator, double denominator, double vocabulary, boolean isSmoothed) {
        if (isSmoothed) {
            return NaiveBayesModel.getSmoothedProbability(numerator, denominator, vocabulary);
        }
        if (denominator == 0.0 || denominator < Double.MIN_VALUE) {
            return 0.0;
        }
        return 1.0 * numerator / denominator;
    }

    private static double getSmoothedProbability(double numerator, double denominator, double vocabulary) {
        double delta = 0.05;
        return 1.0 * (numerator + 0.05) / (denominator + 0.05 * vocabulary);
    }
}

