/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.AbstractEventModelSequenceTrainer;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MutableContext;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.ml.model.SequenceStreamEventStream;
import opennlp.tools.ml.perceptron.PerceptronModel;

public class SimplePerceptronSequenceTrainer
extends AbstractEventModelSequenceTrainer {
    public static final String PERCEPTRON_SEQUENCE_VALUE = "PERCEPTRON_SEQUENCE";
    private int iterations;
    private SequenceStream sequenceStream;
    private int numEvents;
    private int numPreds;
    private int numOutcomes;
    private int[] outcomeList;
    private String[] outcomeLabels;
    private MutableContext[] averageParams;
    private Map<String, Integer> pmap;
    private Map<String, Integer> omap;
    private MutableContext[] params;
    private boolean useAverage;
    private int[][][] updates;
    private static final int VALUE = 0;
    private static final int ITER = 1;
    private static final int EVENT = 2;
    private String[] predLabels;
    private int numSequences;

    @Override
    public void validate() {
        super.validate();
        String algorithmName = this.getAlgorithm();
        if (algorithmName != null && !PERCEPTRON_SEQUENCE_VALUE.equals(algorithmName)) {
            throw new IllegalArgumentException("algorithmName must be PERCEPTRON_SEQUENCE");
        }
    }

    @Override
    @Deprecated
    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public AbstractModel doTrain(SequenceStream events) throws IOException {
        int iterations = this.getIterations();
        int cutoff = this.getCutoff();
        boolean useAverage = this.trainingParameters.getBooleanParameter("UseAverage", true);
        return this.trainModel(iterations, events, cutoff, useAverage);
    }

    public AbstractModel trainModel(int iterations, SequenceStream sequenceStream, int cutoff, boolean useAverage) throws IOException {
        this.iterations = iterations;
        this.sequenceStream = sequenceStream;
        this.trainingParameters.put("Cutoff", cutoff);
        this.trainingParameters.put("sort", false);
        OnePassDataIndexer di = new OnePassDataIndexer();
        di.init(this.trainingParameters, this.reportMap);
        di.index(new SequenceStreamEventStream(sequenceStream));
        this.numSequences = 0;
        sequenceStream.reset();
        while (sequenceStream.read() != null) {
            ++this.numSequences;
        }
        this.outcomeList = di.getOutcomeList();
        this.predLabels = di.getPredLabels();
        this.pmap = new HashMap<String, Integer>();
        for (int i = 0; i < this.predLabels.length; ++i) {
            this.pmap.put(this.predLabels[i], i);
        }
        this.display("Incorporating indexed data for training...  \n");
        this.useAverage = useAverage;
        this.numEvents = di.getNumEvents();
        this.iterations = iterations;
        this.outcomeLabels = di.getOutcomeLabels();
        this.omap = new HashMap<String, Integer>();
        for (int oli = 0; oli < this.outcomeLabels.length; ++oli) {
            this.omap.put(this.outcomeLabels[oli], oli);
        }
        this.outcomeList = di.getOutcomeList();
        this.numPreds = this.predLabels.length;
        this.numOutcomes = this.outcomeLabels.length;
        if (useAverage) {
            this.updates = new int[this.numPreds][this.numOutcomes][3];
        }
        this.display("done.\n");
        this.display("\tNumber of Event Tokens: " + this.numEvents + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        this.params = new MutableContext[this.numPreds];
        if (useAverage) {
            this.averageParams = new MutableContext[this.numPreds];
        }
        int[] allOutcomesPattern = new int[this.numOutcomes];
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            allOutcomesPattern[oi] = oi;
        }
        for (int pi = 0; pi < this.numPreds; ++pi) {
            this.params[pi] = new MutableContext(allOutcomesPattern, new double[this.numOutcomes]);
            if (useAverage) {
                this.averageParams[pi] = new MutableContext(allOutcomesPattern, new double[this.numOutcomes]);
            }
            for (int aoi = 0; aoi < this.numOutcomes; ++aoi) {
                this.params[pi].setParameter(aoi, 0.0);
                if (!useAverage) continue;
                this.averageParams[pi].setParameter(aoi, 0.0);
            }
        }
        double[] modelDistribution = new double[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        this.display("...done.\n");
        String[] updatedPredLabels = this.predLabels;
        if (useAverage) {
            return new PerceptronModel(this.averageParams, updatedPredLabels, this.outcomeLabels);
        }
        return new PerceptronModel(this.params, updatedPredLabels, this.outcomeLabels);
    }

    private void findParameters(int iterations) throws IOException {
        this.display("Performing " + iterations + " iterations.\n");
        for (int i = 1; i <= iterations; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            this.nextIteration(i);
        }
        if (this.useAverage) {
            this.trainingStats(this.averageParams);
        } else {
            this.trainingStats(this.params);
        }
    }

    public void nextIteration(int iteration) throws IOException {
        Sequence sequence;
        --iteration;
        int numCorrect = 0;
        int oei = 0;
        int si = 0;
        ArrayList featureCounts = new ArrayList(this.numOutcomes);
        for (int oi = 0; oi < this.numOutcomes; ++oi) {
            featureCounts.add(new HashMap());
        }
        PerceptronModel model = new PerceptronModel(this.params, this.predLabels, this.pmap, this.outcomeLabels);
        this.sequenceStream.reset();
        while ((sequence = (Sequence)this.sequenceStream.read()) != null) {
            Event[] taggerEvents = this.sequenceStream.updateContext(sequence, model);
            Event[] events = sequence.getEvents();
            boolean update = false;
            int ei = 0;
            while (ei < events.length) {
                if (!taggerEvents[ei].getOutcome().equals(events[ei].getOutcome())) {
                    update = true;
                } else {
                    ++numCorrect;
                }
                ++ei;
                ++oei;
            }
            if (update) {
                int oi;
                for (oi = 0; oi < this.numOutcomes; ++oi) {
                    ((Map)featureCounts.get(oi)).clear();
                }
                ei = 0;
                while (ei < events.length) {
                    String[] contextStrings = events[ei].getContext();
                    float[] values = events[ei].getValues();
                    int oi2 = this.omap.get(events[ei].getOutcome());
                    for (int ci = 0; ci < contextStrings.length; ++ci) {
                        Float c;
                        float value = 1.0f;
                        if (values != null) {
                            value = values[ci];
                        }
                        c = (c = (Float)((Map)featureCounts.get(oi2)).get(contextStrings[ci])) == null ? Float.valueOf(value) : Float.valueOf(c.floatValue() + value);
                        ((Map)featureCounts.get(oi2)).put(contextStrings[ci], c);
                    }
                    ++ei;
                    ++oei;
                }
                for (Event taggerEvent : taggerEvents) {
                    String[] contextStrings = taggerEvent.getContext();
                    float[] values = taggerEvent.getValues();
                    int oi3 = this.omap.get(taggerEvent.getOutcome());
                    for (int ci = 0; ci < contextStrings.length; ++ci) {
                        Float c;
                        float value = 1.0f;
                        if (values != null) {
                            value = values[ci];
                        }
                        if ((c = (c = (Float)((Map)featureCounts.get(oi3)).get(contextStrings[ci])) == null ? Float.valueOf(-1.0f * value) : Float.valueOf(c.floatValue() - value)).floatValue() == 0.0f) {
                            ((Map)featureCounts.get(oi3)).remove(contextStrings[ci]);
                            continue;
                        }
                        ((Map)featureCounts.get(oi3)).put(contextStrings[ci], c);
                    }
                }
                for (oi = 0; oi < this.numOutcomes; ++oi) {
                    for (String feature : ((Map)featureCounts.get(oi)).keySet()) {
                        int pi = this.pmap.get(feature);
                        if (pi == -1) continue;
                        this.params[pi].updateParameter(oi, ((Float)((Map)featureCounts.get(oi)).get(feature)).floatValue());
                        if (!this.useAverage) continue;
                        if (this.updates[pi][oi][0] != 0) {
                            this.averageParams[pi].updateParameter(oi, this.updates[pi][oi][0] * (this.numSequences * (iteration - this.updates[pi][oi][1]) + (si - this.updates[pi][oi][2])));
                        }
                        this.updates[pi][oi][0] = (int)this.params[pi].getParameters()[oi];
                        this.updates[pi][oi][1] = iteration;
                        this.updates[pi][oi][2] = si;
                    }
                }
                model = new PerceptronModel(this.params, this.predLabels, this.pmap, this.outcomeLabels);
            }
            ++si;
        }
        double totIterations = (double)this.iterations * (double)si;
        if (this.useAverage && iteration == this.iterations - 1) {
            for (int pi = 0; pi < this.numPreds; ++pi) {
                double[] predParams = this.averageParams[pi].getParameters();
                for (int oi = 0; oi < this.numOutcomes; ++oi) {
                    if (this.updates[pi][oi][0] != 0) {
                        int n = oi;
                        predParams[n] = predParams[n] + (double)(this.updates[pi][oi][0] * (this.numSequences * (this.iterations - this.updates[pi][oi][1]) - this.updates[pi][oi][2]));
                    }
                    if (predParams[oi] == 0.0) continue;
                    int n = oi;
                    predParams[n] = predParams[n] / totIterations;
                    this.averageParams[pi].setParameter(oi, predParams[oi]);
                }
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }

    private void trainingStats(MutableContext[] params) throws IOException {
        Sequence sequence;
        int numCorrect = 0;
        int oei = 0;
        this.sequenceStream.reset();
        while ((sequence = (Sequence)this.sequenceStream.read()) != null) {
            Event[] taggerEvents = this.sequenceStream.updateContext(sequence, new PerceptronModel(params, this.predLabels, this.pmap, this.outcomeLabels));
            int ei = 0;
            while (ei < taggerEvents.length) {
                int max = this.omap.get(taggerEvents[ei].getOutcome());
                if (max == this.outcomeList[oei]) {
                    ++numCorrect;
                }
                ++ei;
                ++oei;
            }
        }
        this.display(". (" + numCorrect + "/" + this.numEvents + ") " + (double)numCorrect / (double)this.numEvents + "\n");
    }
}

