/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.util.Heap;

@Deprecated
public class ListHeap<E extends Comparable<E>>
implements Heap<E> {
    private List<E> list;
    private Comparator<E> comp;
    private int size;
    private E max = null;

    public ListHeap(int sz, Comparator<E> c) {
        this.size = sz;
        this.comp = c;
        this.list = new ArrayList(sz);
    }

    public ListHeap(int sz) {
        this(sz, null);
    }

    private int parent(int i) {
        return (i - 1) / 2;
    }

    private int left(int i) {
        return (i + 1) * 2 - 1;
    }

    private int right(int i) {
        return (i + 1) * 2;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    private void swap(int x, int y) {
        Comparable ox = (Comparable)this.list.get(x);
        Comparable oy = (Comparable)this.list.get(y);
        this.list.set(y, ox);
        this.list.set(x, oy);
    }

    private boolean lt(E o1, E o2) {
        if (this.comp != null) {
            return this.comp.compare(o1, o2) < 0;
        }
        return o1.compareTo(o2) < 0;
    }

    private boolean gt(E o1, E o2) {
        if (this.comp != null) {
            return this.comp.compare(o1, o2) > 0;
        }
        return o1.compareTo(o2) > 0;
    }

    private void heapify(int i) {
        while (true) {
            int l = this.left(i);
            int r = this.right(i);
            int smallest = l < this.list.size() && this.lt((Comparable)this.list.get(l), (Comparable)this.list.get(i)) ? l : i;
            if (r < this.list.size() && this.lt((Comparable)this.list.get(r), (Comparable)this.list.get(smallest))) {
                smallest = r;
            }
            if (smallest == i) break;
            this.swap(smallest, i);
            i = smallest;
        }
    }

    @Override
    public E extract() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        Comparable top = (Comparable)this.list.get(0);
        int last = this.list.size() - 1;
        if (last != 0) {
            this.list.set(0, this.list.remove(last));
            this.heapify(0);
        } else {
            this.list.remove(last);
        }
        return (E)top;
    }

    @Override
    public E first() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        return (E)((Comparable)this.list.get(0));
    }

    @Override
    public E last() {
        if (this.list.size() == 0) {
            throw new RuntimeException("Heap Underflow");
        }
        return this.max;
    }

    @Override
    public void add(E o) {
        if (this.max == null) {
            this.max = o;
        } else if (this.gt(o, this.max)) {
            if (this.list.size() < this.size) {
                this.max = o;
            } else {
                return;
            }
        }
        this.list.add(o);
        int i = this.list.size() - 1;
        while (i > 0 && this.gt((Comparable)this.list.get(this.parent(i)), o)) {
            this.list.set(i, this.list.get(this.parent(i)));
            i = this.parent(i);
        }
        this.list.set(i, o);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

