/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;
import java.util.Objects;

public class TokenTag {
    private final String token;
    private final String tag;
    private final String[] addtionalData;

    public TokenTag(String token, String tag, String[] addtionalData) {
        this.token = token;
        this.tag = tag;
        this.addtionalData = addtionalData != null ? Arrays.copyOf(addtionalData, addtionalData.length) : null;
    }

    public String getToken() {
        return this.token;
    }

    public String getTag() {
        return this.tag;
    }

    public String[] getAddtionalData() {
        return this.addtionalData;
    }

    public static String[] extractTokens(TokenTag[] tuples) {
        String[] tokens = new String[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            tokens[i] = tuples[i].getToken();
        }
        return tokens;
    }

    public static String[] extractTags(TokenTag[] tuples) {
        String[] tags = new String[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            tags[i] = tuples[i].getTag();
        }
        return tags;
    }

    public static TokenTag[] create(String[] toks, String[] tags) {
        TokenTag[] tuples = new TokenTag[toks.length];
        for (int i = 0; i < toks.length; ++i) {
            tuples[i] = new TokenTag(toks[i], tags[i], null);
        }
        return tuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TokenTag) {
            return Objects.equals(this.token, ((TokenTag)o).token) && Objects.equals(this.tag, ((TokenTag)o).tag) && Objects.equals(this.addtionalData, ((TokenTag)o).addtionalData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.token, this.tag, this.addtionalData);
    }

    public String toString() {
        return this.token + "_" + this.tag;
    }
}

