/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import opennlp.tools.commons.Sample;
import opennlp.tools.util.Span;

public class ChunkSample
implements Sample {
    private static final long serialVersionUID = -3092850871020409815L;
    private final List<String> sentence;
    private final List<String> tags;
    private final List<String> preds;

    public ChunkSample(String[] sentence, String[] tags, String[] preds) {
        this(Arrays.asList(sentence), Arrays.asList(tags), Arrays.asList(preds));
    }

    public ChunkSample(List<String> sentence, List<String> tags, List<String> preds) {
        ChunkSample.validateArguments(sentence.size(), tags.size(), preds.size());
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(sentence));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.preds = Collections.unmodifiableList(new ArrayList<String>(preds));
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getPreds() {
        return this.preds.toArray(new String[this.preds.size()]);
    }

    public Span[] getPhrasesAsSpanList() {
        return ChunkSample.phrasesAsSpanList(this.getSentence(), this.getTags(), this.getPreds());
    }

    public static Span[] phrasesAsSpanList(String[] aSentence, String[] aTags, String[] aPreds) {
        ChunkSample.validateArguments(aSentence.length, aTags.length, aPreds.length);
        ArrayList<Span> phrases = new ArrayList<Span>(aSentence.length);
        String startTag = "";
        int startIndex = 0;
        boolean foundPhrase = false;
        int cn = aPreds.length;
        for (int ci = 0; ci < cn; ++ci) {
            String pred = aPreds[ci];
            if (pred.startsWith("B-") || !pred.equals("I-" + startTag) && !pred.equals("O")) {
                if (foundPhrase) {
                    phrases.add(new Span(startIndex, ci, startTag));
                }
                startIndex = ci;
                startTag = pred.substring(2);
                foundPhrase = true;
                continue;
            }
            if (pred.equals("I-" + startTag) || !foundPhrase) continue;
            phrases.add(new Span(startIndex, ci, startTag));
            foundPhrase = false;
            startTag = "";
        }
        if (foundPhrase) {
            phrases.add(new Span(startIndex, aPreds.length, startTag));
        }
        return phrases.toArray(new Span[phrases.size()]);
    }

    private static void validateArguments(int sentenceSize, int tagsSize, int predsSize) throws IllegalArgumentException {
        if (sentenceSize != tagsSize || tagsSize != predsSize) {
            throw new IllegalArgumentException("All arrays must have the same length: sentenceSize: " + sentenceSize + ", tagsSize: " + tagsSize + ", predsSize: " + predsSize + "!");
        }
    }

    public String nicePrint() {
        Span[] spans = this.getPhrasesAsSpanList();
        StringBuilder result = new StringBuilder(" ");
        for (int tokenIndex = 0; tokenIndex < this.sentence.size(); ++tokenIndex) {
            Span[] spanArray = spans;
            int n = spanArray.length;
            for (int i = 0; i < n; ++i) {
                Span span = spanArray[i];
                if (span.getStart() == tokenIndex) {
                    result.append("[").append(span.getType()).append(" ");
                }
                if (span.getEnd() != tokenIndex) continue;
                result.append("]").append(' ');
            }
            result.append(this.sentence.get(tokenIndex)).append("_").append(this.tags.get(tokenIndex)).append(' ');
        }
        if (this.sentence.size() > 1) {
            result.setLength(result.length() - 1);
        }
        for (Span span : spans) {
            if (span.getEnd() != this.sentence.size()) continue;
            result.append(']');
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder chunkString = new StringBuilder();
        for (int ci = 0; ci < this.preds.size(); ++ci) {
            chunkString.append(this.sentence.get(ci)).append(" ").append(this.tags.get(ci)).append(" ").append(this.preds.get(ci)).append("\n");
        }
        return chunkString.toString();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getSentence()), Arrays.hashCode(this.getTags()), Arrays.hashCode(this.getPreds()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChunkSample) {
            ChunkSample a = (ChunkSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getTags(), a.getTags()) && Arrays.equals(this.getPreds(), a.getPreds());
        }
        return false;
    }
}

