/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import opennlp.tools.util.XmlUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LetsmtDocument {
    private static final String ORG_XML_FEATURES_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private final List<LetsmtSentence> sentences;

    private LetsmtDocument(List<LetsmtSentence> sentences) {
        this.sentences = sentences;
    }

    public List<LetsmtSentence> getSentences() {
        return Collections.unmodifiableList(this.sentences);
    }

    static LetsmtDocument parse(InputStream letsmtXmlIn) throws IOException {
        SAXParser saxParser = XmlUtil.createSaxParser();
        try {
            XMLReader xmlReader = saxParser.getXMLReader();
            LetsmtDocumentHandler docHandler = new LetsmtDocumentHandler();
            xmlReader.setContentHandler(docHandler);
            xmlReader.setFeature(ORG_XML_FEATURES_DISALLOW_DOCTYPE_DECL, true);
            xmlReader.parse(new InputSource(letsmtXmlIn));
            return new LetsmtDocument(docHandler.sentences);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse letsmt xml!", e);
        }
    }

    static LetsmtDocument parse(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            LetsmtDocument letsmtDocument = LetsmtDocument.parse(in);
            return letsmtDocument;
        }
    }

    public static class LetsmtDocumentHandler
    extends DefaultHandler {
        private final List<LetsmtSentence> sentences = new ArrayList<LetsmtSentence>();
        private final StringBuilder chars = new StringBuilder();
        private List<String> tokens = new ArrayList<String>();

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            switch (qName) {
                case "w": {
                    this.tokens.add(this.chars.toString().trim());
                    this.chars.setLength(0);
                    break;
                }
                case "s": {
                    LetsmtSentence sentence = new LetsmtSentence();
                    if (this.tokens.size() > 0) {
                        sentence.tokens = this.tokens.toArray(new String[this.tokens.size()]);
                        this.tokens = new ArrayList<String>();
                    } else {
                        sentence.nonTokenizedText = this.chars.toString().trim();
                    }
                    this.sentences.add(sentence);
                    this.chars.setLength(0);
                }
            }
        }
    }

    public static class LetsmtSentence {
        private String nonTokenizedText;
        private String[] tokens;

        public String getNonTokenizedText() {
            return this.nonTokenizedText;
        }

        public String[] getTokens() {
            if (this.tokens != null) {
                return Arrays.copyOf(this.tokens, this.tokens.length);
            }
            return null;
        }
    }
}

