/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.IOException;
import java.util.List;
import opennlp.tools.formats.masc.MascDocument;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class MascTokenSampleStream
extends FilterObjectStream<MascDocument, TokenSample> {
    private MascDocument buffer;

    public MascTokenSampleStream(ObjectStream<MascDocument> samples) throws IOException {
        super(samples);
        try {
            do {
                this.buffer = samples.read();
            } while (!this.buffer.hasPennTags());
        }
        catch (Exception e) {
            throw new IOException("None of the documents has Penn tokenization" + e.getMessage());
        }
    }

    @Override
    public TokenSample read() throws IOException {
        try {
            List<Span> tokenSpans;
            String sentenceString;
            boolean sentenceFound = true;
            do {
                MascSentence sentence = this.buffer.read();
                while (sentence == null) {
                    this.buffer = (MascDocument)this.samples.read();
                    if (this.buffer == null) {
                        return null;
                    }
                    if (!this.buffer.hasPennTags()) continue;
                    sentence = this.buffer.read();
                }
                sentenceString = sentence.getTokenText();
                tokenSpans = sentence.getTokensSpans();
                if (sentenceString.length() == 0) {
                    System.err.println("[WARNING] Zero sentence found: there is a sentence without any tokens.");
                    System.err.println(sentenceString);
                    System.err.println(tokenSpans.toString());
                    sentenceFound = false;
                }
                for (int i = 0; i < tokenSpans.size(); ++i) {
                    Span t = tokenSpans.get(i);
                    if (t.getEnd() - t.getStart() != 0) continue;
                    System.err.println("[WARNING] Zero token found: there is a token without any quarks.");
                    System.err.println(sentenceString);
                    System.err.println(tokenSpans);
                    sentenceFound = false;
                }
            } while (!sentenceFound);
            Span[] tokensSpansArray = new Span[tokenSpans.size()];
            tokenSpans.toArray(tokensSpansArray);
            return new TokenSample(sentenceString, tokensSpansArray);
        }
        catch (IOException e) {
            throw new IOException("Could not get a sample of tokens from the data.");
        }
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
        this.buffer = (MascDocument)this.samples.read();
    }
}

