/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import opennlp.tools.formats.conllu.ConlluWordLine;

public class ConlluSentence {
    private final List<ConlluWordLine> wordLines;
    private final String sentenceIdComment;
    private final String textComment;
    private boolean newDocument;
    private String documentId;
    private boolean newParagraph;
    private String paragraphId;
    private Map<Locale, String> textLang;
    private String translit;

    ConlluSentence(List<ConlluWordLine> wordLines, String sentenceIdComment, String textComment) {
        this.wordLines = wordLines;
        this.sentenceIdComment = sentenceIdComment;
        this.textComment = textComment;
    }

    public ConlluSentence(List<ConlluWordLine> wordLines, String sentenceIdComment, String textComment, boolean newDocument, String documentId, boolean newParagraph, String paragraphId, Map<Locale, String> textLang, String translit) {
        this.wordLines = wordLines;
        this.sentenceIdComment = sentenceIdComment;
        this.textComment = textComment;
        this.newDocument = newDocument;
        this.documentId = documentId;
        this.newParagraph = newParagraph;
        this.paragraphId = paragraphId;
        this.textLang = textLang;
        this.translit = translit;
    }

    public List<ConlluWordLine> getWordLines() {
        return this.wordLines;
    }

    public String getSentenceIdComment() {
        return this.sentenceIdComment;
    }

    public String getTextComment() {
        return this.textComment;
    }

    public boolean isNewDocument() {
        return this.newDocument;
    }

    public Optional<String> getDocumentId() {
        return Optional.ofNullable(this.documentId);
    }

    public boolean isNewParagraph() {
        return this.newParagraph;
    }

    public Optional<String> getParagraphId() {
        return Optional.ofNullable(this.paragraphId);
    }

    public Optional<Map<Locale, String>> getTextLang() {
        return Optional.ofNullable(this.textLang);
    }

    public Optional<String> getTranslit() {
        return Optional.ofNullable(this.translit);
    }
}

