/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.commons.Trainer;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractTrainer
implements Trainer {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String TRAINER_TYPE_PARAM = "TrainerType";
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final int CUTOFF_DEFAULT = 5;
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final int ITERATIONS_DEFAULT = 100;
    protected TrainingParameters trainingParameters;
    protected Map<String, String> reportMap;

    public AbstractTrainer() {
    }

    public AbstractTrainer(TrainingParameters trainParams) {
        this.init(trainParams, new HashMap<String, String>());
    }

    @Override
    public void init(TrainingParameters trainParams, Map<String, String> reportMap) {
        this.trainingParameters = trainParams;
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        this.reportMap = reportMap;
    }

    public String getAlgorithm() {
        return this.trainingParameters.getStringParameter(ALGORITHM_PARAM, "MAXENT");
    }

    public int getCutoff() {
        return this.trainingParameters.getIntParameter(CUTOFF_PARAM, 5);
    }

    public int getIterations() {
        return this.trainingParameters.getIntParameter(ITERATIONS_PARAM, 100);
    }

    public void validate() {
        try {
            this.trainingParameters.getIntParameter(CUTOFF_PARAM, 5);
            this.trainingParameters.getIntParameter(ITERATIONS_PARAM, 100);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void addToReport(String key, String value) {
        this.reportMap.put(key, value);
    }
}

