/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.languagemodel;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.languagemodel.NGramLanguageModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NGramLanguageModelTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(NGramLanguageModelTool.class);

    @Override
    public String getShortDescription() {
        return "Gives the probability and most probable next token(s) of a sequence of tokens in a language model";
    }

    @Override
    public void run(String[] args) {
        File lmFile = new File(args[0]);
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(lmFile));){
            NGramLanguageModel nGramLanguageModel = new NGramLanguageModel(stream);
            PerformanceMonitor perfMon = null;
            try (PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                perfMon = new PerformanceMonitor("nglm");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    Object[] predicted;
                    double probability;
                    Object[] tokens = line.split(" ");
                    try {
                        probability = nGramLanguageModel.calculateProbability((String[])tokens);
                        predicted = nGramLanguageModel.predictNextTokens((String[])tokens);
                    }
                    catch (Exception e) {
                        logger.error("Error for line: {}", (Object)line, (Object)e);
                        continue;
                    }
                    logger.info("{} -> prob: {}, next: {}", new Object[]{Arrays.toString(tokens), probability, Arrays.toString(predicted)});
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
        catch (IOException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model";
    }
}

