/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.conllu.ConlluLemmaSampleStream;
import opennlp.tools.formats.conllu.ConlluStream;
import opennlp.tools.formats.conllu.ConlluTagset;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;

@Internal
public class ConlluLemmaSampleStreamFactory<P>
extends AbstractSampleStreamFactory<LemmaSample, P> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(LemmaSample.class, "conllu", new ConlluLemmaSampleStreamFactory<Parameters>(Parameters.class));
    }

    protected ConlluLemmaSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<LemmaSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        ConlluTagset tagset = switch (params.getTagset()) {
            case "u" -> ConlluTagset.U;
            case "x" -> ConlluTagset.X;
            default -> throw new TerminateToolException(-1, "Unknown tagset parameter: " + params.getTagset());
        };
        InputStreamFactory inFactory = CmdLineUtil.createInputStreamFactory(params.getData());
        try {
            return new ConlluLemmaSampleStream(new ConlluStream(inFactory), tagset);
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="tagset", description="u|x u for unified tags and x for language-specific part-of-speech tags")
        @ArgumentParser.OptionalParameter(defaultValue="u")
        public String getTagset();
    }
}

